/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.network.serverSide;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.network.PacketHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChocoboChangeOwnership
implements IMessage {
    public int entityID;
    public String ownerID;
    public boolean setTamed;
    public int dimensionId;

    public ChocoboChangeOwnership() {
    }

    public ChocoboChangeOwnership(EntityAnimalChocobo chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.ownerID = chocobo.func_184753_b() == null ? "" : chocobo.func_184753_b().toString();
        this.setTamed = chocobo.func_70909_n();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.getDimension();
    }

    public ChocoboChangeOwnership(EntityAnimalChocobo chocobo, boolean setTamed) {
        this.entityID = chocobo.func_145782_y();
        this.ownerID = chocobo.func_184753_b() == null ? "" : chocobo.func_184753_b().toString();
        this.setTamed = setTamed;
        this.dimensionId = chocobo.field_70170_p.field_73011_w.getDimension();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerID);
        buffer.writeBoolean(this.setTamed);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.ownerID = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.setTamed = buffer.readBoolean();
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboChangeOwnership, IMessage> {
        public IMessage onMessage(ChocoboChangeOwnership message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null) {
                chocobo.func_70903_f(message.setTamed);
                if (message.setTamed) {
                    chocobo.func_184754_b(UUID.fromString(message.ownerID));
                } else {
                    chocobo.func_184754_b(null);
                }
            }
            return null;
        }
    }
}

