/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.network.serverSide;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.network.PacketHelper;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChocoboAttribute
implements IMessage {
    public int entityID;
    public String chocoboName;
    public boolean hideName;
    public boolean isFollowing;
    public boolean isWander;
    public int dimensionId;

    public ChocoboAttribute() {
    }

    public ChocoboAttribute(EntityAnimalChocobo chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.chocoboName = chocobo.func_70005_c_();
        this.hideName = chocobo.isHidename();
        this.isFollowing = chocobo.isFollowing();
        this.isWander = chocobo.isWander();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.getDimension();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.chocoboName);
        buffer.writeBoolean(this.hideName);
        buffer.writeBoolean(this.isFollowing);
        buffer.writeBoolean(this.isWander);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.chocoboName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.hideName = buffer.readBoolean();
        this.isFollowing = buffer.readBoolean();
        this.isWander = buffer.readBoolean();
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboAttribute, IMessage> {
        public IMessage onMessage(ChocoboAttribute message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null) {
                chocobo.setHidename(message.hideName);
                chocobo.setFollowing(message.isFollowing);
                chocobo.setWander(message.isWander);
                chocobo.setName(message.chocoboName);
            }
            return null;
        }
    }
}

