/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.network.clientSide;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.network.PacketHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChocoboTamed
implements IMessage {
    public int entityID;
    public boolean isTamed;
    public String ownerUUID;
    public int dimensionId;

    public ChocoboTamed() {
    }

    public ChocoboTamed(EntityAnimalChocobo chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.isTamed = chocobo.func_70909_n();
        this.ownerUUID = chocobo.getOwner().func_110124_au().toString();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.getDimension();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeBoolean(this.isTamed);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerUUID);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.isTamed = buffer.readBoolean();
        this.ownerUUID = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboTamed, IMessage> {
        public IMessage onMessage(ChocoboTamed message, MessageContext ctx) {
            EntityAnimalChocobo chicobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chicobo != null) {
                chicobo.func_70903_f(message.isTamed);
                chicobo.func_184754_b(UUID.fromString(message.ownerUUID));
            }
            return null;
        }
    }
}

