/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.network.clientSide;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.helper.ChocoboParticleHelper;
import chococraftplus.common.network.PacketHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChocoboParticles
implements IMessage {
    public int entityID;
    public int particleID;
    public int particleAmount;
    public int dimensionId;

    public ChocoboParticles() {
    }

    public ChocoboParticles(EntityAnimalChocobo chocobo, int particleID, int particleAmount) {
        this.entityID = chocobo.func_145782_y();
        this.particleID = particleID;
        this.particleAmount = particleAmount;
        this.dimensionId = chocobo.field_70170_p.field_73011_w.getDimension();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.particleID);
        buffer.writeInt(this.particleAmount);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.particleID = buffer.readInt();
        this.particleAmount = buffer.readInt();
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboParticles, IMessage> {
        public IMessage onMessage(ChocoboParticles message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null) {
                ChocoboParticleHelper.showParticleAroundEntityFx(message.particleID, (Entity)chocobo, message.particleAmount);
            }
            return null;
        }
    }
}

