/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.network.clientSide;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.network.PacketHelper;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChocoboHunger
implements IMessage {
    public int entityID;
    public int hungerTime;
    public int dimensionId;
    public int chocoAge;

    public ChocoboHunger() {
    }

    public ChocoboHunger(EntityAnimalChocobo chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.hungerTime = chocobo.getTimeUntilHunger();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.getDimension();
        this.chocoAge = chocobo.getChocoAge();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.hungerTime);
        buffer.writeInt(this.dimensionId);
        buffer.writeInt(this.chocoAge);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.hungerTime = buffer.readInt();
        this.dimensionId = buffer.readInt();
        this.chocoAge = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboHunger, IMessage> {
        public IMessage onMessage(ChocoboHunger message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null) {
                chocobo.setTimeUntilHunger(message.hungerTime);
                chocobo.setChocoAge(message.chocoAge);
            }
            return null;
        }
    }
}

