/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.items.spawnegg;

import chococraftplus.common.items.spawnegg.ItemSpawnEggCCP;
import chococraftplus.common.items.spawnegg.SpawnEggInfo;
import chococraftplus.common.utils.LogHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public class SpawnEggRegistry {
    private static final Map<Short, SpawnEggInfo> SPAWN_EGGS = new LinkedHashMap<Short, SpawnEggInfo>();
    private static final int MOD_MOBS_IDS_START = 1;
    private static final int[] yellowEggColors = new int[]{15127169, 11635002, 15327928};
    private static final int[] blueEggColors = new int[]{6324673, 1781085, 11188420};
    private static final int[] greenEggColors = new int[]{8760134, 15855972, 12373643};
    private static final int[] redEggColors = new int[]{12142904, 15718811, 13999492};
    private static final int[] whiteEggColors = new int[]{0xD8D8D8, 0x1B1B1B, 15461081};
    private static final int[] blackEggColors = new int[]{0x2F2F2F, 0xDEDEDE, 9539712};
    private static final int[] pinkEggColors = new int[]{13013393, 9325130, 14204847};
    private static final int[] royalEggColors = new int[]{6040211, 16767591, 10781876};
    private static final int[] goldEggColors = new int[]{14992742, 12883204, 15855839};
    public static final ItemSpawnEggCCP SPAWN_EGG = new ItemSpawnEggCCP();
    public static final String KEY_SPAWNEGG = "spawn_egg";
    public static final Object[][] spawnEggData = new Object[][]{{"chocobo.yellow", "chocobo.yellow", yellowEggColors[0], yellowEggColors[1], new NBTTagCompound()}, {"chocobo.blue", "chocobo.blue", blueEggColors[0], blueEggColors[1], new NBTTagCompound()}, {"chocobo.green", "chocobo.green", greenEggColors[0], greenEggColors[1], new NBTTagCompound()}, {"chocobo.red", "chocobo.red", redEggColors[0], redEggColors[1], new NBTTagCompound()}, {"chocobo.white", "chocobo.white", whiteEggColors[0], whiteEggColors[1], new NBTTagCompound()}, {"chocobo.black", "chocobo.black", blackEggColors[0], blackEggColors[1], new NBTTagCompound()}, {"chocobo.pink", "chocobo.pink", pinkEggColors[0], pinkEggColors[1], new NBTTagCompound()}, {"chocobo.royal", "chocobo.royal", royalEggColors[0], royalEggColors[1], new NBTTagCompound()}, {"chocobo.gold", "chocobo.gold", goldEggColors[0], goldEggColors[1], new NBTTagCompound()}, {"chicobo", "chicobo.yellow", yellowEggColors[0], yellowEggColors[2], SpawnEggRegistry.chicoboColor(0)}, {"chicobo", "chicobo.blue", blueEggColors[0], blueEggColors[2], SpawnEggRegistry.chicoboColor(1)}, {"chicobo", "chicobo.green", greenEggColors[0], greenEggColors[2], SpawnEggRegistry.chicoboColor(2)}, {"chicobo", "chicobo.red", redEggColors[0], redEggColors[2], SpawnEggRegistry.chicoboColor(3)}, {"chicobo", "chicobo.white", whiteEggColors[0], whiteEggColors[2], SpawnEggRegistry.chicoboColor(4)}, {"chicobo", "chicobo.black", blackEggColors[0], blackEggColors[2], SpawnEggRegistry.chicoboColor(5)}, {"chicobo", "chicobo.pink", pinkEggColors[0], pinkEggColors[2], SpawnEggRegistry.chicoboColor(6)}, {"chicobo", "chicobo.royal", royalEggColors[0], royalEggColors[2], SpawnEggRegistry.chicoboColor(7)}, {"chicobo", "chicobo.gold", goldEggColors[0], goldEggColors[2], SpawnEggRegistry.chicoboColor(8)}, {"chocobo.yellow", "chocobo.stable", yellowEggColors[0], 14312015, SpawnEggRegistry.chocoboStable()}};

    public static void registerSpawnEgg(SpawnEggInfo info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException("SpawnEggInfo cannot be null");
        }
        if (!SpawnEggRegistry.isValidSpawnEggID(info.eggID)) {
            throw new IllegalArgumentException("Duplicate spawn egg with id " + info.eggID);
        }
        SPAWN_EGGS.put(info.eggID, info);
    }

    public static boolean isValidSpawnEggID(short id) {
        return !SPAWN_EGGS.containsKey(id);
    }

    public static SpawnEggInfo getEggInfo(short id) {
        return SPAWN_EGGS.get(id);
    }

    public static Collection<SpawnEggInfo> getEggInfoList() {
        return Collections.unmodifiableCollection(SPAWN_EGGS.values());
    }

    public static void addAllSpawnEggs() {
        for (int i = 0; i < spawnEggData.length; ++i) {
            int currentID = i + 1;
            try {
                SpawnEggRegistry.registerSpawnEgg(new SpawnEggInfo((short)currentID, (String)spawnEggData[i][0], (String)spawnEggData[i][1], (Integer)spawnEggData[i][2], (Integer)spawnEggData[i][3], (NBTTagCompound)spawnEggData[i][4]));
                continue;
            }
            catch (IllegalArgumentException e) {
                LogHelper.warn("Could not register spawn egg for entity " + (String)spawnEggData[i][0] + " into ID " + currentID);
            }
        }
    }

    public static NBTTagCompound chicoboColor(int type) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("ChicoboColor", type);
        return tag;
    }

    public static NBTTagCompound chocoboStable() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("tamed", true);
        return tag;
    }

    private static int getRGBInt(int rInt, int gInt, int bInt) {
        return (rInt << 16) + (gInt << 8) + bInt;
    }

    public static void inventoryRenders() {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)SPAWN_EGG, 0, new ModelResourceLocation("chococraftplus:spawn_egg", "inventory"));
        for (int i = 0; i < spawnEggData.length; ++i) {
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a((Item)SPAWN_EGG, i + 1, new ModelResourceLocation("chococraftplus:spawn_egg", "inventory"));
        }
    }
}

