/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.items.spawnegg;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChicobo;
import chococraftplus.common.entities.FactoryEntityChocobo;
import chococraftplus.common.entities.colours.EntityChocoboYellow;
import chococraftplus.common.items.spawnegg.SpawnEggInfo;
import chococraftplus.common.items.spawnegg.SpawnEggRegistry;
import chococraftplus.common.registry.ChocoCraftCreativeTabs;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpawnEggCCP
extends Item {
    public ItemSpawnEggCCP() {
        this.func_77627_a(true);
        this.func_77637_a(ChocoCraftCreativeTabs.tabChococraft);
        this.func_77655_b("spawn_egg");
    }

    public String func_77653_i(ItemStack stack) {
        String name = ("" + I18n.func_74838_a((String)"item.monsterPlacer.name")).trim();
        SpawnEggInfo info = SpawnEggRegistry.getEggInfo((short)stack.func_77952_i());
        if (info == null) {
            return name;
        }
        String mobID = info.mobID;
        String displayName = info.displayName;
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound.func_74764_b("mobID")) {
                mobID = compound.func_74779_i("mobID");
            }
            if (compound.func_74764_b("displayName")) {
                displayName = compound.func_74779_i("displayName");
            }
        }
        name = displayName == null ? name + " " + ItemSpawnEggCCP.attemptToTranslate("entity." + mobID + ".name", mobID) : name + " " + ("" + I18n.func_74838_a((String)("eggdisplay.chococraftplus." + displayName + ".name"))).trim();
        return name;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150474_ac && (tileentity = world.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).func_145881_a();
            mobspawnerbaselogic.func_190894_a(ItemSpawnEggCCP.getNamedIdFrom(itemstack));
            tileentity.func_70296_d();
            world.func_184138_a(pos, iblockstate, iblockstate, 3);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(world, blockpos);
        Entity entity = ItemSpawnEggCCP.spawnCreature(world, itemstack, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                entity.func_96094_a(itemstack.func_82833_r());
            }
            ItemSpawnEggCCP.applyItemEntityDataToEntity(world, player, itemstack, entity);
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72314_b(0.0, -1.0, 0.0);
        List list = world.func_184144_a((Entity)null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)pos.func_177956_o();
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("EntityTag", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.func_189511_e(new NBTTagCompound());
            UUID uuid = targetEntity.func_110124_au();
            nbttagcompound1.func_179237_a(nbttagcompound.func_74775_l("EntityTag"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(nbttagcompound1);
        }
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "chococraftplus".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    public String func_77667_c(ItemStack itemStack) {
        return String.format("item.%s%s", "chococraftplus".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                Entity entity = ItemSpawnEggCCP.spawnCreature(worldIn, itemstack, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
                }
                if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                    entity.func_96094_a(itemstack.func_82833_r());
                }
                ItemSpawnEggCCP.applyItemEntityDataToEntity(worldIn, playerIn, itemstack, entity);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                playerIn.func_71029_a(StatList.func_188057_b((Item)this));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    public static Entity spawnCreature(World world, ItemStack stack, double x, double y, double z) {
        int stackDamage = stack.func_77952_i();
        SpawnEggInfo info = SpawnEggRegistry.getEggInfo((short)stackDamage);
        if (info == null) {
            return null;
        }
        String mobID = info.mobID;
        String displayName = info.displayName;
        NBTTagCompound spawnData = info.spawnData;
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            if (compound.func_74764_b("mobID")) {
                mobID = compound.func_74779_i("mobID");
            }
            if (compound.func_74764_b("displayName")) {
                displayName = compound.func_74779_i("displayName");
            }
            if (compound.func_74764_b("spawnData")) {
                spawnData = compound.func_74775_l("spawnData");
            }
        }
        Object entity = null;
        entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation("chococraftplus:" + mobID), (World)world);
        if (entity != null && entity instanceof EntityLiving) {
            if (!spawnData.func_82582_d()) {
                ItemSpawnEggCCP.addNBTData(entity, spawnData);
                if (entity instanceof EntityChocoboYellow && ((EntityChocoboYellow)((Object)entity)).func_70909_n()) {
                    entity = FactoryEntityChocobo.createStableChocobo(entity.field_70170_p, entity.field_70170_p.field_73012_v);
                }
            }
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    private static void addNBTData(Entity entity, NBTTagCompound spawnData) {
        NBTTagCompound newTag = new NBTTagCompound();
        entity.func_70039_c(newTag);
        block10: for (String name : spawnData.func_150296_c()) {
            if (name.equals("ChicoboColor") && entity instanceof EntityChicobo) {
                NBTBase colorTag = spawnData.func_74781_a(name);
                if (colorTag.func_74732_a() == 3) {
                    int color = ((NBTTagInt)colorTag).func_150287_d();
                    String colorTagName = "Color";
                    switch (color) {
                        default: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.YELLOW.toString());
                            continue block10;
                        }
                        case 1: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.BLUE.toString());
                            continue block10;
                        }
                        case 2: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.GREEN.toString());
                            continue block10;
                        }
                        case 3: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.RED.toString());
                            continue block10;
                        }
                        case 4: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.WHITE.toString());
                            continue block10;
                        }
                        case 5: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.BLACK.toString());
                            continue block10;
                        }
                        case 6: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.PINK.toString());
                            continue block10;
                        }
                        case 7: {
                            newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.ROYAL.toString());
                            continue block10;
                        }
                        case 8: 
                    }
                    newTag.func_74778_a(colorTagName, EntityAnimalChocobo.ChocoboColor.GOLD.toString());
                    continue;
                }
                ((EntityChicobo)entity).setColor(EntityAnimalChocobo.ChocoboColor.YELLOW);
                continue;
            }
            newTag.func_74782_a(name, spawnData.func_74781_a(name).func_74737_b());
        }
        entity.func_70020_e(newTag);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(creativeTab)) {
            for (SpawnEggInfo info : SpawnEggRegistry.getEggInfoList()) {
                subItems.add((Object)new ItemStack((Item)this, 1, (int)info.eggID));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String attemptToTranslate(String key, String _default) {
        String result = I18n.func_74838_a((String)key);
        return result.equals(key) ? _default : result;
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack itemStack) {
        NBTTagCompound nbttagcompound = itemStack.func_77978_p();
        if (nbttagcompound == null) {
            return null;
        }
        if (!nbttagcompound.func_150297_b("EntityTag", 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("EntityTag");
        if (!nbttagcompound1.func_150297_b("id", 8)) {
            return null;
        }
        String s = nbttagcompound1.func_74779_i("id");
        ResourceLocation resourcelocation = new ResourceLocation(s);
        if (!s.contains(":")) {
            nbttagcompound1.func_74778_a("id", resourcelocation.toString());
        }
        return resourcelocation;
    }
}

