/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.integration.antiqueatlas;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.utils.LogHelper;
import com.google.common.collect.ImmutableMap;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.api.TileAPI;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerRegistry;
import hunternif.mc.atlas.registry.MarkerType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StableWatcherAA {
    public static final String TILE_CHOCOBO_STABLE = "npcChocoboStable";
    public static final String CHOCOBO_STABLE_VILLAGE_MARKER = "chocobo_stable_village";
    public static final String CHOCOBO_STABLE_WORLD_MARKER = "chocobo_stable_world";
    private final Set<String> visited = new HashSet<String>();
    private static final Map<String, String> COMPONENT_TO_TILE_MAP;
    private static final Map<String, Integer> TILE_TO_PRIORITY_MAP;

    @SideOnly(value=Side.CLIENT)
    public static void registerTextures() {
        TileAPI tileAPI = AtlasAPI.getTileAPI();
        tileAPI.setCustomTileTexture(TILE_CHOCOBO_STABLE, tileAPI.registerTextureSet("Chocobo Stable Tile", new ResourceLocation[]{new ResourceLocation("antiqueatlas", "textures/gui/tiles/house.png")}));
        StableWatcherAA.registerMarker(CHOCOBO_STABLE_VILLAGE_MARKER, CHOCOBO_STABLE_VILLAGE_MARKER);
        StableWatcherAA.registerMarker(CHOCOBO_STABLE_WORLD_MARKER, CHOCOBO_STABLE_WORLD_MARKER);
    }

    public static void registerMarker(String markerName, String textureName) {
        MarkerRegistry.register((MarkerType)new MarkerType(new ResourceLocation("antiqueatlas", markerName), new ResourceLocation[]{new ResourceLocation("chococraftplus:textures/gui/antiqueatlas/markers/" + textureName + ".png")}));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            this.visitAllUnvisitedVillages(event.getWorld());
            this.visitAllUnvisitedWorldStables(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Post event) {
        if (!event.getWorld().field_72995_K && event.getWorld().field_73011_w.getDimension() == 0) {
            this.visitAllUnvisitedVillages(event.getWorld());
            this.visitAllUnvisitedWorldStables(event.getWorld());
        }
    }

    public void visitAllUnvisitedVillages(World world) {
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
        if (data == null) {
            return;
        }
        NBTTagCompound villageNBTData = data.func_143041_a();
        Set tagSet = villageNBTData.func_150296_c();
        for (String coords : tagSet) {
            NBTBase tag;
            if (this.visited.contains(coords) || (tag = villageNBTData.func_74781_a(coords)).func_74732_a() != 10) continue;
            this.visitVillage(world, (NBTTagCompound)tag);
            this.visited.add(coords);
        }
    }

    public void visitAllUnvisitedWorldStables(World world) {
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "ChocoboStable");
        if (data == null) {
            return;
        }
        NBTTagCompound stableNBTData = data.func_143041_a();
        Set tagSet = stableNBTData.func_150296_c();
        for (String coords : tagSet) {
            NBTBase tag;
            if (this.visited.contains(coords) || (tag = stableNBTData.func_74781_a(coords)).func_74732_a() != 10) continue;
            this.visitWorldStable(world, (NBTTagCompound)tag);
            this.visited.add(coords);
        }
    }

    private void visitVillage(World world, NBTTagCompound tag) {
        if (!tag.func_74767_n("Valid")) {
            StableWatcherAA.removeVillageStableMarker(world, tag);
            return;
        }
        int startChunkX = tag.func_74762_e("ChunkX");
        int startChunkZ = tag.func_74762_e("ChunkZ");
        if (GeneralConfig.debugMessages) {
            LogHelper.info("Visiting NPC Village in dimension #" + world.field_73011_w.getDimension() + " at chunk (" + startChunkX + ", " + startChunkZ + ") ~ blocks (" + (startChunkX << 4) + ", " + (startChunkZ << 4) + ")");
        }
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            String tileName;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            int x = (boundingBox.field_78897_a + boundingBox.field_78893_d + 1) / 2;
            int y = (boundingBox.field_78895_b + boundingBox.field_78894_e + 1) / 2;
            int z = (boundingBox.field_78896_c + boundingBox.field_78892_f + 1) / 2;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if ("ChocStbl".equals(childID)) {
                boolean foundMarker = false;
                for (int j = -1; j <= 1; ++j) {
                    block2: for (int k = -1; k <= 1; ++k) {
                        List markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), j + chunkX / 8, k + chunkZ / 8);
                        if (markers == null) continue;
                        for (Marker marker : markers) {
                            if (!marker.getType().equals(CHOCOBO_STABLE_VILLAGE_MARKER)) continue;
                            foundMarker = true;
                            continue block2;
                        }
                    }
                }
                if (!foundMarker && GeneralConfig.antiqueAtlasStableMarkersVillage) {
                    AtlasAPI.markers.putGlobalMarker(world, false, CHOCOBO_STABLE_VILLAGE_MARKER, "gui.antiqueatlas.marker.chocobostable", x, z);
                }
            }
            if ((tileName = COMPONENT_TO_TILE_MAP.get(childID)) == null) continue;
            Integer curTilePriority = TILE_TO_PRIORITY_MAP.get(tileName);
            Integer prevTilePriority = TILE_TO_PRIORITY_MAP.get(StableWatcherAA.tileAt(chunkX, chunkZ));
            if (curTilePriority != null && prevTilePriority != null) {
                if (curTilePriority < prevTilePriority) continue;
                AtlasAPI.getTileAPI().putCustomGlobalTile(world, tileName, chunkX, chunkZ);
                continue;
            }
            AtlasAPI.getTileAPI().putCustomGlobalTile(world, tileName, chunkX, chunkZ);
        }
    }

    private void visitWorldStable(World world, NBTTagCompound tag) {
        int startChunkX = tag.func_74762_e("ChunkX");
        int startChunkZ = tag.func_74762_e("ChunkZ");
        if (GeneralConfig.debugMessages) {
            LogHelper.info("Visiting World Chocobo Stable in dimension #" + world.field_73011_w.getDimension() + " at chunk (" + startChunkX + ", " + startChunkZ + ") ~ blocks (" + (startChunkX << 4) + ", " + (startChunkZ << 4) + ")");
        }
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            String tileName;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            if (!"Stbl".equals(childID)) continue;
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            int x = (boundingBox.field_78897_a + boundingBox.field_78893_d + 1) / 2;
            int y = (boundingBox.field_78895_b + boundingBox.field_78894_e + 1) / 2;
            int z = (boundingBox.field_78896_c + boundingBox.field_78892_f + 1) / 2;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            boolean foundMarker = false;
            for (int j = -1; j <= 1; ++j) {
                block2: for (int k = -1; k <= 1; ++k) {
                    List markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), j + chunkX / 8, k + chunkZ / 8);
                    if (markers == null) continue;
                    for (Marker marker : markers) {
                        if (!marker.getType().equals(CHOCOBO_STABLE_WORLD_MARKER)) continue;
                        foundMarker = true;
                        continue block2;
                    }
                }
            }
            if (!foundMarker && GeneralConfig.antiqueAtlasStableMarkersWorld) {
                AtlasAPI.markers.putGlobalMarker(world, false, CHOCOBO_STABLE_WORLD_MARKER, "gui.antiqueatlas.marker.chocobostable", x, z);
            }
            if ((tileName = COMPONENT_TO_TILE_MAP.get(childID)) == null) continue;
            Integer curTilePriority = TILE_TO_PRIORITY_MAP.get(tileName);
            Integer prevTilePriority = TILE_TO_PRIORITY_MAP.get(StableWatcherAA.tileAt(chunkX, chunkZ));
            if (curTilePriority != null && prevTilePriority != null) {
                if (curTilePriority < prevTilePriority) continue;
                AtlasAPI.getTileAPI().putCustomGlobalTile(world, tileName, chunkX, chunkZ);
                continue;
            }
            AtlasAPI.getTileAPI().putCustomGlobalTile(world, tileName, chunkX, chunkZ);
        }
    }

    private static void removeVillageStableMarker(World world, NBTTagCompound tag) {
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            List markers;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            int x = (boundingBox.field_78897_a + boundingBox.field_78893_d + 1) / 2;
            int z = (boundingBox.field_78896_c + boundingBox.field_78892_f + 1) / 2;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if ("ChocStbl".equals(childID) && (markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), chunkX / 8, chunkZ / 8)) != null) {
                for (Marker marker : markers) {
                    if (!marker.getType().equals(CHOCOBO_STABLE_VILLAGE_MARKER)) continue;
                    AtlasAPI.markers.deleteGlobalMarker(world, marker.getId());
                    if (!GeneralConfig.debugMessages) break;
                    LogHelper.info("Removed faux village marker at x=" + (chunkX << 4) + " z=" + (chunkZ << 4));
                    break;
                }
            }
            AtlasAPI.tiles.deleteCustomGlobalTile(world, chunkX, chunkZ);
            if (!GeneralConfig.debugMessages) continue;
            LogHelper.info("Removed faux village tile at x=" + (chunkX << 4) + " z=" + (chunkZ << 4));
        }
    }

    private static String tileAt(int chunkX, int chunkZ) {
        int biomeID = AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(0, chunkX, chunkZ);
        return ExtTileIdMap.instance().getPseudoBiomeName(biomeID);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"ChocStbl", (Object)TILE_CHOCOBO_STABLE);
        builder.put((Object)"Stbl", (Object)TILE_CHOCOBO_STABLE);
        COMPONENT_TO_TILE_MAP = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put((Object)TILE_CHOCOBO_STABLE, (Object)7);
        TILE_TO_PRIORITY_MAP = builder.build();
    }
}

