/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.helper;

import chococraftplus.common.entities.EntityChocobo;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChocoboEntityHelper {
    public static int countEntities(Class entityClass, World world) {
        int amountEntities = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!entityClass.isAssignableFrom(entity.getClass())) continue;
            ++amountEntities;
        }
        return amountEntities;
    }

    public static int countWildChocobos(World world) {
        int amountEntities = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityChocobo) || ((EntityChocobo)entity).func_70909_n()) continue;
            ++amountEntities;
        }
        return amountEntities;
    }

    public static int countWildChocobosInChunk(World world, Chunk chunk) {
        int amountEntities = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Chunk entityChunk;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityChocobo) || ((EntityChocobo)entity).func_70909_n() || !(entityChunk = world.func_175726_f(new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), 0, MathHelper.func_76128_c((double)entity.field_70161_v)))).equals(chunk)) continue;
            ++amountEntities;
        }
        return amountEntities;
    }

    public static boolean isEntityViewingUnderWater(World world, EntityLiving entity) {
        Vec3d vector = ActiveRenderInfo.func_178806_a((Entity)entity, (double)90.0);
        BlockPos chunkPos = new BlockPos(vector);
        IBlockState blockstateFront = world.func_180495_p(chunkPos);
        IBlockState blockstateAbove = world.func_180495_p(chunkPos.func_177984_a());
        if (blockstateAbove.func_177230_c().equals(Blocks.field_150350_a) || blockstateFront.func_177230_c().equals(Blocks.field_150350_a)) {
            return false;
        }
        boolean frontWater = blockstateFront.func_185904_a().equals(Material.field_151586_h);
        boolean aboveWater = blockstateAbove.func_185904_a().equals(Material.field_151586_h);
        return frontWater && aboveWater;
    }

    public static boolean isSpaceAroundFree(World world, EntityLiving entity, int radX, int spcY, int radZ) {
        return ChocoboEntityHelper.isSpaceAroundLocationFree(world, new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v), radX, spcY, radZ);
    }

    public static boolean isSpaceAroundLocationFree(World world, BlockPos startPos, int radX, int spcY, int radZ) {
        int startX = startPos.func_177958_n();
        int startY = startPos.func_177956_o();
        int startZ = startPos.func_177952_p();
        int sPosX = startX - radX;
        int sPosY = startY + 1;
        int sPosZ = startZ - radZ;
        int ePosX = startX + radX;
        int ePosY = startY + spcY;
        int ePosZ = startZ + radZ;
        for (int x = sPosX; x <= ePosX; ++x) {
            for (int y = sPosY; y <= ePosY; ++y) {
                for (int z = sPosZ; z <= ePosZ; ++z) {
                    if (world.func_175623_d(new BlockPos(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

