/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.helper;

import chococraftplus.common.utils.ChocoFunctions;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.biome.BiomeHell;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ChocoboBiomeHelper {
    public static Biome[] getBiomeArray() {
        ArrayList<Biome> bgbList = new ArrayList<Biome>();
        for (Biome bgb : ForgeRegistries.BIOMES.getValues()) {
            if (null == bgb || bgb instanceof BiomeHell || bgb instanceof BiomeEnd) continue;
            bgbList.add(bgb);
        }
        Biome[] returnBgbList = new Biome[bgbList.size()];
        int i = 0;
        for (Object e : bgbList) {
            if (e instanceof Biome) {
                returnBgbList[i] = (Biome)e;
            }
            ++i;
        }
        return returnBgbList;
    }

    public static String[] getBiomeNameArray() {
        return ChocoboBiomeHelper.getBiomeGenNameArray(ChocoboBiomeHelper.getBiomeArray());
    }

    public static String[] getBiomeGenNameArray(Biome[] bgbArray) {
        if (null != bgbArray) {
            if (0 != bgbArray.length) {
                String[] bgbNames = new String[bgbArray.length];
                int idx = 0;
                for (Biome bgb : bgbArray) {
                    if (null == bgb) continue;
                    bgbNames[idx] = ChocoFunctions.getBiomeName(bgb);
                    ++idx;
                }
                return bgbNames;
            }
            return null;
        }
        return ChocoboBiomeHelper.getBiomeNameArray();
    }

    public static boolean isBiomeHell(World world, int posX, int posZ) {
        Biome chocoBgb = world.func_180494_b(new BlockPos(posX, 0, posZ));
        return chocoBgb instanceof BiomeHell || chocoBgb instanceof BiomeEnd;
    }

    public static boolean isWorldHell(World world) {
        return ChocoboBiomeHelper.isBiomeHell(world, 0, 0);
    }
}

