/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.gui;

import chococraftplus.common.ModChocoCraft;
import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChocoboRideable;
import chococraftplus.common.gui.ChocopediaPages;
import chococraftplus.common.gui.GuiChocopediaButtonNextPage;
import chococraftplus.common.gui.GuiNameChocobo;
import chococraftplus.common.gui.GuiSelectNewOwner;
import chococraftplus.common.gui.GuiSetFree;
import chococraftplus.common.helper.ChocoboEntityHelper;
import chococraftplus.common.network.PacketRegistry;
import chococraftplus.common.network.serverSide.MessageCurrPage;
import chococraftplus.common.utils.ChocoFunctions;
import chococraftplus.common.utils.Reference;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChocopedia
extends GuiScreen {
    private static final int BUTTON_ID_RENAME = 0;
    private static final int BUTTON_ID_EXIT = 1;
    private static final int BUTTON_ID_HIDENAME = 2;
    private static final int BUTTON_ID_FOLLOWING = 3;
    private static final int BUTTON_ID_DROPGEAR = 4;
    private static final int BUTTON_ID_CHANGEOWNER = 5;
    private static final int BUTTON_ID_SETFREE = 9;
    private static final int BUTTON_ID_BOOK_DONE = 6;
    private static final int BUTTON_ID_BOOK_PREV = 7;
    private static final int BUTTON_ID_BOOK_NEXT = 8;
    private EntityAnimalChocobo chocobo;
    private EntityPlayer player;
    private GuiScreen parentGuiScreen;
    public final ItemStack chocopediaObj;
    private GuiButton hideNameButton;
    private GuiButton followingButton;
    private GuiButton dropGearButton;
    private GuiButton renameButton;
    private GuiButton exitButton;
    private GuiButton changeOwnerButton;
    private GuiButton changeSetFreeButton;
    private String bookTitle = "The Chocopedia";
    private String bookEdition = "2nd Edition";
    private String bookAuthor = "by The Chocobo Sage";
    private String bookEditor = "Edited by AstroTibs";
    private String bookEditor2 = "and Clienthax";
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private GuiChocopediaButtonNextPage buttonNextPage;
    private GuiChocopediaButtonNextPage buttonPreviousPage;
    private GuiButton buttonDone;
    public int currPage;
    public int lastCurrPage;
    private ResourceLocation bookResourceLoc = Reference.chocopediaGUI;

    public GuiChocopedia(GuiScreen guiscreen, EntityAnimalChocobo entitychocobo, EntityPlayer thePlayer, ItemStack chocopedia) {
        this.chocobo = entitychocobo;
        this.player = thePlayer;
        this.parentGuiScreen = guiscreen;
        this.chocopediaObj = chocopedia;
    }

    public void func_73876_c() {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        if (null != this.chocobo) {
            EntityChocoboRideable chocoboRideable;
            Keyboard.enableRepeatEvents((boolean)true);
            this.field_146292_n.clear();
            int yPos = this.field_146295_m / 4 - 60 + 24;
            int xPos = this.field_146294_l / 2 - 100;
            this.exitButton = this.createGuiButton(1, xPos, yPos += 24, "Exit");
            this.field_146292_n.add(this.exitButton);
            String lblNameShown = this.chocobo.isHidename() ? "Show Name" : "Hide Name";
            this.hideNameButton = this.createGuiButton(2, xPos, yPos += 24, lblNameShown);
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.hideNameButton, true);
            this.field_146292_n.add(this.hideNameButton);
            this.renameButton = this.createGuiButton(0, xPos, yPos += 24, "Rename");
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.renameButton, true);
            this.field_146292_n.add(this.renameButton);
            String lblFollowing = this.getFollowStatus();
            this.followingButton = this.createGuiButton(3, xPos, yPos += 24, lblFollowing);
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.followingButton, true);
            this.field_146292_n.add(this.followingButton);
            if (this.chocobo instanceof EntityChocoboRideable && null == this.chocobo.func_184179_bs() && ((chocoboRideable = (EntityChocoboRideable)this.chocobo).isSaddled() || chocoboRideable.isPackBagged().booleanValue())) {
                String lblDropGear = "Drop Gear";
                this.dropGearButton = this.createGuiButton(4, xPos, yPos += 24, lblDropGear);
                if (this.chocobo.func_184753_b() == null || this.chocobo.func_184753_b().equals(Reference.STABLEHAND_UUID)) {
                    this.dropGearButton.field_146124_l = true;
                } else {
                    this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.dropGearButton, true);
                }
                this.field_146292_n.add(this.dropGearButton);
            }
            yPos += 6;
            this.changeOwnerButton = this.createGuiButton(5, xPos, yPos += 24, "Change Owner");
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.changeOwnerButton, true);
            this.field_146292_n.add(this.changeOwnerButton);
            this.changeSetFreeButton = this.createGuiButton(9, xPos, yPos += 24, "Set Free");
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.changeSetFreeButton, true);
            this.field_146292_n.add(this.changeSetFreeButton);
        } else {
            this.currPage = ChocoFunctions.getCurrentPage(this.chocopediaObj);
            if (this.currPage < 0) {
                this.currPage = 0;
            }
            this.lastCurrPage = this.currPage;
            this.buttonDone = new GuiButton(6, this.field_146294_l / 2 - 100, 4 + this.bookImageHeight, 200, 20, I18n.func_74838_a((String)"gui.done"));
            this.field_146292_n.add(this.buttonDone);
            int i = (this.field_146294_l - this.bookImageWidth) / 2;
            this.buttonNextPage = new GuiChocopediaButtonNextPage(8, i + 120, 156, true);
            this.field_146292_n.add(this.buttonNextPage);
            this.buttonPreviousPage = new GuiChocopediaButtonNextPage(7, i + 38, 156, false);
            this.field_146292_n.add(this.buttonPreviousPage);
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.buttonNextPage.field_146124_l = this.currPage < ChocopediaPages.Instance().getNPages() - 1;
        this.buttonPreviousPage.field_146124_l = this.currPage > 0;
        this.buttonDone.field_146124_l = true;
    }

    protected GuiButton createGuiButton(int id, int xPos, int yPos, String label) {
        return new GuiButton(id, xPos, yPos, 90, 20, label);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        if (guibutton.field_146127_k == 1) {
            this.field_146297_k.func_147108_a(this.parentGuiScreen);
        } else if (guibutton.field_146127_k == 2) {
            this.chocobo.setHidename(!this.chocobo.isHidename());
            this.chocobo.func_96094_a(this.chocobo.isHidename() || GeneralConfig.useChocoCraftNameRendering || !GeneralConfig.showChocoboNames ? "" : this.chocobo.func_70005_c_());
            this.hideNameButton.field_146126_j = this.chocobo.isHidename() ? "Show Name" : "Hide Name";
        } else if (guibutton.field_146127_k == 3) {
            this.chocobo.toggleFollowWanderStay(this.player, true);
            this.followingButton.field_146126_j = this.getFollowStatus();
        } else if (guibutton.field_146127_k == 0) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiNameChocobo(this, this.chocobo));
        } else if (guibutton.field_146127_k == 4) {
            if (this.chocobo instanceof EntityChocoboRideable && null == this.chocobo.func_184179_bs()) {
                ((EntityChocoboRideable)this.chocobo).sendDropGearUpdate();
            }
            this.field_146297_k.func_147108_a(this.parentGuiScreen);
        } else if (guibutton.field_146127_k == 5) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSelectNewOwner(this, this.player, this.chocobo));
        } else if (guibutton.field_146127_k == 9) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSetFree(this, this.chocobo));
        } else if (guibutton.field_146127_k == 6) {
            this.field_146297_k.func_147108_a(this.parentGuiScreen);
        } else if (guibutton.field_146127_k == 8) {
            if (this.currPage < ChocopediaPages.Instance().getNPages() - 1) {
                ++this.currPage;
                this.updateButtons();
                this.updateAndSendCurrPage();
            }
        } else if (guibutton.field_146127_k == 7 && this.currPage > 0) {
            --this.currPage;
            this.updateButtons();
            this.updateAndSendCurrPage();
        }
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
    }

    public void func_73863_a(int i, int j, float f) {
        if (null != this.chocobo) {
            this.func_146276_q_();
            String breedStatus = this.chocobo.getChocoAge() <= 0 && !this.chocobo.func_70631_g_() && this.chocobo.func_184753_b() != null && !this.chocobo.func_184753_b().toString().equals("") && !this.chocobo.func_184753_b().equals(Reference.STABLEHAND_UUID) ? TextFormatting.LIGHT_PURPLE + "  [Can breed]" : "";
            String eatStatus = this.chocobo.isHungry() && this.chocobo.func_184753_b() != null && !this.chocobo.func_184753_b().toString().equals("") && !this.chocobo.func_184753_b().equals(Reference.STABLEHAND_UUID) ? TextFormatting.GREEN + "  [Can feed]" : "";
            String gender = this.chocobo.getGender();
            String ownerName = "";
            try {
                ownerName = this.chocobo.func_184753_b().equals(null) || this.chocobo.func_184753_b().toString().equals("") || this.chocobo.func_184753_b().equals(Reference.STABLEHAND_UUID) ? "(Stablehand Villager)" : this.chocobo.field_70170_p.func_152378_a(this.chocobo.func_184753_b()).func_70005_c_();
            }
            catch (Exception e) {
                ownerName = "(Offline)";
            }
            String ownerNameLine = "Owner: " + ownerName;
            if (this.chocobo.func_70005_c_().equals(null) || this.chocobo.func_70005_c_().equals("")) {
                this.func_73732_a(this.field_146297_k.field_71466_p, "(Unnamed)", this.field_146294_l / 2, this.field_146295_m / 4 - 60 + 20, 0xC0C0C0);
            } else {
                this.func_73732_a(this.field_146297_k.field_71466_p, this.chocobo.func_70005_c_(), this.field_146294_l / 2, this.field_146295_m / 4 - 60 + 20, 0xFFFFFF);
            }
            int posY = this.field_146295_m / 4 - 60 + 24;
            int posX = this.field_146294_l / 2 + 10;
            int lineHeight = 13;
            this.func_73731_b(this.field_146297_k.field_71466_p, ownerNameLine, posX, posY += 2 * lineHeight, 0xC0C0C0);
            this.func_73731_b(this.field_146297_k.field_71466_p, gender + breedStatus + eatStatus + TextFormatting.RESET, posX, posY += lineHeight, 0xC0C0C0);
            String health = "Health: " + (this.chocobo.func_110143_aJ() * 4.0f > this.chocobo.func_110138_aP() ? TextFormatting.GOLD : TextFormatting.RED) + (int)this.chocobo.func_110143_aJ() + (TextFormatting.GOLD + "/") + (int)this.chocobo.func_110138_aP();
            this.func_73731_b(this.field_146297_k.field_71466_p, health, posX, posY += 2 * lineHeight, 16504421);
            String speedString = "Running speed: " + TextFormatting.GOLD + (this.chocobo.func_70631_g_() ? "???" : String.format("%.1f", Float.valueOf((float)this.chocobo.getRun() * 100.0f / 10000.0f)) + " km/h");
            this.func_73731_b(this.field_146297_k.field_71466_p, speedString, posX, posY += lineHeight, 16504421);
            String dashString = "Sprint speed: " + TextFormatting.GOLD + (this.chocobo.func_70631_g_() ? "???" : String.format("%.1f", Float.valueOf((float)this.chocobo.getDash() * 100.0f / 10000.0f)) + " km/h");
            this.func_73731_b(this.field_146297_k.field_71466_p, dashString, posX, posY += lineHeight, 16504421);
            String intelligenceString = "Intelligence: " + TextFormatting.GOLD + (this.chocobo.func_70631_g_() ? "???" : Integer.valueOf(this.chocobo.getIntelligence()));
            this.func_73731_b(this.field_146297_k.field_71466_p, intelligenceString, posX, posY += lineHeight, 16504421);
            this.func_73731_b(this.field_146297_k.field_71466_p, "Temperament: " + TextFormatting.GOLD + (this.chocobo.getPersonality() / 2 >= 41 ? "Friendly" : (this.chocobo.getPersonality() % 2 == 1 ? "Stolid" : "Stubborn")), posX, posY += lineHeight, 16504421);
            if (!this.chocobo.func_70631_g_()) {
                if (this.chocobo.canWaterTread) {
                    this.func_73731_b(this.field_146297_k.field_71466_p, TextFormatting.BLUE + "[Water Tread]", posX, posY += lineHeight, 16504421);
                }
                if (this.chocobo.canHighStep) {
                    this.func_73731_b(this.field_146297_k.field_71466_p, TextFormatting.GREEN + "[High Step]", posX, posY += lineHeight, 16504421);
                }
                if (this.chocobo.canHighJump && !this.chocobo.canFly) {
                    this.func_73731_b(this.field_146297_k.field_71466_p, TextFormatting.RED + "[High Jump]", posX, posY += lineHeight, 16504421);
                }
                if (this.chocobo.canSoftFall) {
                    this.func_73731_b(this.field_146297_k.field_71466_p, TextFormatting.WHITE + "[Soft Fall]", posX, posY += lineHeight, 16504421);
                }
                if (this.chocobo.canFly) {
                    this.func_73731_b(this.field_146297_k.field_71466_p, TextFormatting.GOLD + "[Flight]", posX, posY += lineHeight, 16504421);
                }
            }
            if (ChocoFunctions.isChocoCraftAuthor(this.player) && GeneralConfig.debugMessages) {
                this.func_73731_b(this.field_146297_k.field_71466_p, "Stamina: " + this.chocobo.getStamina(), posX, posY += lineHeight, 0x11A0A0);
                int cooperation = this.chocobo.getCooperation();
                String cooperationString = "Cooperation: " + cooperation;
                this.func_73731_b(this.field_146297_k.field_71466_p, cooperationString, posX, posY += lineHeight, 0x11A0A0);
                this.func_73731_b(this.field_146297_k.field_71466_p, "Strafe percent: " + this.chocobo.getAcceleration(), posX, posY += lineHeight, 0x11A0A0);
                String geneQuality = "";
                switch (this.chocobo.getRating()) {
                    case 0: {
                        geneQuality = "Poor";
                        break;
                    }
                    case 1: {
                        geneQuality = "Weak";
                        break;
                    }
                    case 2: {
                        geneQuality = "Mediocre";
                        break;
                    }
                    case 3: {
                        geneQuality = "Average";
                        break;
                    }
                    case 4: {
                        geneQuality = "Fair";
                        break;
                    }
                    case 5: {
                        geneQuality = "Good";
                        break;
                    }
                    case 6: {
                        geneQuality = "Great";
                        break;
                    }
                    case 7: {
                        geneQuality = "Wonderful";
                    }
                }
                this.func_73731_b(this.field_146297_k.field_71466_p, "Genetic quality: " + geneQuality, posX, posY += lineHeight, 0x11A0A0);
                int timeUntilHungry = this.chocobo.getTimeUntilHunger();
                String hungerString = "Time until hungry: " + timeUntilHungry;
                this.func_73731_b(this.field_146297_k.field_71466_p, hungerString, posX, posY += lineHeight, 0x11A0A0);
                int timeUntilCanBreed = this.chocobo.getChocoAge();
                String breedString = "Time until " + (this.chocobo.func_70631_g_() ? "adult: " : "can breed: ") + timeUntilCanBreed;
                this.func_73731_b(this.field_146297_k.field_71466_p, breedString, posX, posY += lineHeight, 0x11A0A0);
                int amountWildChocobos = ChocoboEntityHelper.countWildChocobos(this.chocobo.field_70170_p);
                int amountChocobos = ChocoboEntityHelper.countEntities(EntityAnimalChocobo.class, this.chocobo.field_70170_p);
                String chocoAmountString = "Chocos: " + amountChocobos + " wild: " + amountWildChocobos;
                this.func_73731_b(this.field_146297_k.field_71466_p, chocoAmountString, posX, posY += lineHeight, 0x11A0A0);
                String biomeName = ChocoFunctions.getBiomeName(this.chocobo.field_70170_p.func_180494_b(new BlockPos((int)this.chocobo.field_70165_t, 0, (int)this.chocobo.field_70161_v)));
                String biomeDisplayString = "Biome: " + biomeName;
                this.func_73731_b(this.field_146297_k.field_71466_p, biomeDisplayString, posX, posY += lineHeight, 0x11A0A0);
                this.func_73731_b(this.field_146297_k.field_71466_p, "Spawn: " + ModChocoCraft.spawnDbStatus, posX, posY += lineHeight, 0x11A0A0);
                long spawnTimeDelay = this.chocobo.field_70170_p.func_82737_E() - ModChocoCraft.spawnDbTimeDelay;
                String spawnTimeDelayString = "Spawn Time: " + spawnTimeDelay;
                this.func_73731_b(this.field_146297_k.field_71466_p, spawnTimeDelayString, posX, posY += lineHeight, 0x11A0A0);
                String statusRemoteClient = "Remote Client: " + Boolean.toString(ModChocoCraft.isRemoteClient);
                this.func_73731_b(this.field_146297_k.field_71466_p, statusRemoteClient, posX, posY += lineHeight, 0x11A0A0);
            }
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.bookResourceLoc);
            int xCenter = (this.field_146294_l - this.bookImageWidth) / 2;
            this.func_73729_b(xCenter, 2, 0, 0, this.bookImageWidth, this.bookImageHeight);
            if (this.currPage == 0) {
                int posY = 50;
                int titleWidth = this.field_146297_k.field_71466_p.func_78256_a(this.bookTitle);
                this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.GOLD + this.bookTitle, xCenter + 36 + (116 - titleWidth) / 2, posY, 0);
                int editionWidth = this.field_146297_k.field_71466_p.func_78256_a(this.bookEdition);
                this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.GOLD + this.bookEdition, xCenter + 36 + (116 - editionWidth) / 2, posY += 10, 0);
                posY += 5;
                int authorWidth = this.field_146297_k.field_71466_p.func_78256_a(this.bookAuthor);
                this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.DARK_RED + this.bookAuthor, xCenter + 36 + (116 - authorWidth) / 2, posY += 10, 0);
                posY += 5;
                int editorWidth = this.field_146297_k.field_71466_p.func_78256_a(this.bookEditor);
                this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.RED + this.bookEditor, xCenter + 36 + (116 - editorWidth) / 2, posY += 10, 0);
                int editorWidth2 = this.field_146297_k.field_71466_p.func_78256_a(this.bookEditor2);
                this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.RED + this.bookEditor2, xCenter + 36 + (116 - editorWidth2) / 2, posY += 10, 0);
                if (ChocoFunctions.isChocoCraftAuthor(this.player) && GeneralConfig.debugMessages) {
                    String biomeDisplayString = "Biome: " + ChocoFunctions.getBiomeName(this.player.field_70170_p.func_180494_b(new BlockPos((int)this.player.field_70165_t, 0, (int)this.player.field_70161_v)));
                    String spawnStatus = "Spawn: " + ModChocoCraft.spawnDbStatus;
                    int amountWildChocobos = ChocoboEntityHelper.countWildChocobos(this.player.field_70170_p);
                    int amountChocobos = ChocoboEntityHelper.countEntities(EntityAnimalChocobo.class, this.player.field_70170_p);
                    String chocoAmountString = "Chocos: " + amountChocobos + " wild: " + amountWildChocobos;
                    String statusRemoteClient = "Remote Client: " + Boolean.toString(ModChocoCraft.isRemoteClient);
                    this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.GRAY + "Dev debug info", xCenter + 36, posY += 15, 0);
                    this.field_146297_k.field_71466_p.func_78276_b(biomeDisplayString, xCenter + 36, posY += 10, 0);
                    this.field_146297_k.field_71466_p.func_78276_b(spawnStatus, xCenter + 36, posY += 10, 0);
                    this.field_146297_k.field_71466_p.func_78276_b(chocoAmountString, xCenter + 36, posY += 10, 0);
                }
            } else {
                ChocopediaPages pages = ChocopediaPages.Instance();
                String pageContent = "";
                if (this.currPage > 1) {
                    int indicatorCurrentPage = this.currPage - 1;
                    int indicatorAmountPages = ChocopediaPages.Instance().getNPages() - 2;
                    String pageIndicator = String.format(I18n.func_74838_a((String)"book.pageIndicator"), indicatorCurrentPage, indicatorAmountPages);
                    int pageIndicatorWidth = this.field_146297_k.field_71466_p.func_78256_a(pageIndicator);
                    this.field_146297_k.field_71466_p.func_78276_b(pageIndicator, xCenter - pageIndicatorWidth + this.bookImageWidth - 44, 18, 0);
                }
                if (this.currPage >= 0 && this.currPage < pages.getNPages()) {
                    pageContent = pages.getPage(this.currPage);
                }
                this.field_146297_k.field_71466_p.func_78279_b(pageContent, xCenter + 36, 34, 116, 0);
            }
        }
        super.func_73863_a(i, j, f);
    }

    private void checkButtonOwner(EntityPlayer player, EntityPlayer owner, GuiButton button, boolean enableWhenCreative) {
        boolean playerIsCreativeMode = player.field_71075_bZ.field_75098_d;
        if (!player.equals((Object)owner) && (!playerIsCreativeMode || playerIsCreativeMode && !enableWhenCreative)) {
            button.field_146124_l = false;
        }
    }

    private String getFollowStatus() {
        if (this.chocobo.isFollowing().booleanValue() && !this.chocobo.isWander()) {
            return "Follow";
        }
        if (!this.chocobo.isFollowing().booleanValue() && this.chocobo.isWander()) {
            return "Wander";
        }
        if (!this.chocobo.isFollowing().booleanValue() && !this.chocobo.isWander()) {
            return "Stay";
        }
        return "";
    }

    private void updateAndSendCurrPage() {
        if (this.lastCurrPage != this.currPage) {
            this.lastCurrPage = this.currPage;
            ChocoFunctions.setCurrentPage(this.chocopediaObj, this.currPage);
            PacketRegistry.INSTANCE.sendToServer((IMessage)new MessageCurrPage(this.currPage));
        }
    }
}

