/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.gui;

import chococraftplus.common.ModChocoCraft;
import chococraftplus.common.config.GeneralConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CCPGuiConfig
extends GuiConfig {
    public CCPGuiConfig(GuiScreen guiScreen) {
        super(guiScreen, CCPGuiConfig.getElements(), "chococraftplus", false, false, CCPGuiConfig.getHeader());
    }

    private static String getHeader() {
        return TextFormatting.YELLOW + ModChocoCraft.configDirectory.getAbsolutePath();
    }

    private static List<IConfigElement> getElements() {
        ArrayList<IConfigElement> subCats = new ArrayList<IConfigElement>();
        subCats = new ArrayList();
        ConfigCategory cc = GeneralConfig.config.getCategory("wild spawning");
        cc.setComment("Controls for how and where wild Chocobos spawn in the world");
        subCats.add((IConfigElement)new ConfigElement(cc));
        cc = GeneralConfig.config.getCategory("mod integration");
        cc.setComment("References to other mods");
        subCats.add((IConfigElement)new ConfigElement(cc));
        cc = GeneralConfig.config.getCategory("world generation");
        cc.setComment("In-situ generation like crop spawning, village structures, and chest loot");
        cc.setRequiresWorldRestart(true);
        cc.setRequiresMcRestart(true);
        subCats.add((IConfigElement)new ConfigElement(cc));
        cc = GeneralConfig.config.getCategory("domestication");
        cc.setComment("Settings for tamed chocobos");
        subCats.add((IConfigElement)new ConfigElement(cc));
        cc = GeneralConfig.config.getCategory("feeding and breeding");
        cc.setComment("Settings for crops and chocobo maintenance");
        subCats.add((IConfigElement)new ConfigElement(cc));
        cc = GeneralConfig.config.getCategory("miscellaneous");
        cc.setComment("Odds and ends");
        subCats.add((IConfigElement)new ConfigElement(cc));
        return subCats;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 2000) {
            boolean flag = true;
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof CCPGuiConfig)) && this.entryList.hasChangedEntry(true)) {
                    boolean requiresMcRestart = this.entryList.saveConfigElements();
                    if (Loader.isModLoaded((String)this.modID)) {
                        ConfigChangedEvent event = new ConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        FMLCommonHandler.instance().bus().post((Event)event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            FMLCommonHandler.instance().bus().post((Event)new ConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                            GeneralConfig.loadConfiguration();
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.field_146297_k.func_147108_a((GuiScreen)new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof CCPGuiConfig) {
                            ((CCPGuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (flag) {
                this.field_146297_k.func_147108_a(this.parentScreen);
            }
        }
    }
}

