/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.events;

import chococraftplus.common.blocks.BlockGysahlCrop;
import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityChocobo;
import chococraftplus.common.gui.GuiStarter;
import chococraftplus.common.helper.ChocoboPlayerHelper;
import chococraftplus.common.registry.ChocoCraftBlocks;
import chococraftplus.common.registry.ChocoCraftItems;
import chococraftplus.common.sound.SoundEventsCCP;
import chococraftplus.common.utils.LogHelper;
import chococraftplus.common.utils.Reference;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ChocoCraftEventCommon {
    @SubscribeEvent(receiveCanceled=true)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getEntityPlayer().field_70170_p.field_72995_K && event.getTarget() instanceof EntityLiving && !(event.getTarget() instanceof EntityPlayer)) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            EntityLiving target = (EntityLiving)event.getTarget();
            String targetClassPath = target.getClass().toString().substring(6);
            if (GeneralConfig.debugMessages) {
                player.func_145747_a((ITextComponent)new TextComponentString("Class path of this entity: " + targetClassPath));
                player.func_145747_a((ITextComponent)new TextComponentString(""));
            }
        }
    }

    @SubscribeEvent
    public void onRegisterSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        SoundEventsCCP.INSTANCE.init();
        event.getRegistry().registerAll((IForgeRegistryEntry[])SoundEventsCCP.INSTANCE.getSounds().toArray(new SoundEvent[0]));
    }

    @SubscribeEvent
    public void onUseBonemeal(BonemealEvent event) {
        if (event.getBlock().func_177230_c().equals(ChocoCraftBlocks.GYSAHL_GARDEN) && ((BlockGysahlCrop)ChocoCraftBlocks.GYSAHL_GARDEN).onBonemealUse(event.getWorld(), event.getPos())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityChocobo) {
            EntityPlayer player;
            EntityChocobo chocobo;
            block12: {
                chocobo = (EntityChocobo)event.getEntity();
                if (chocobo.func_70909_n() && event.getEntity() instanceof EntityPlayer) {
                    player = (EntityPlayer)event.getEntity();
                    if (player.func_70093_af()) {
                        event.setCanceled(true);
                    } else if (chocobo.func_184753_b() != null && !chocobo.func_184753_b().equals("") && !chocobo.field_70170_p.field_72995_K) {
                        try {
                            World world = chocobo.field_70170_p;
                            Village village = world.field_72982_D.func_176056_a(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v), 16);
                            int collectionRep = village.getPlayerReputation(player.func_110124_au());
                            if (event.getAmount() >= chocobo.func_110143_aJ()) {
                                village.modifyPlayerReputation(player.func_110124_au(), -3);
                            } else {
                                village.modifyPlayerReputation(player.func_110124_au(), -1);
                            }
                        }
                        catch (Exception e) {
                            if (!GeneralConfig.debugMessages) break block12;
                            LogHelper.error("Error decrementing " + player.func_145748_c_() + "'s reputation for attacking a village chocobo!");
                        }
                    }
                }
            }
            if (null != chocobo.func_184179_bs() && chocobo.func_184179_bs() instanceof EntityPlayer) {
                player = (EntityPlayer)chocobo.func_184179_bs();
                if (event.getSource().equals(DamageSource.func_76365_a((EntityPlayer)player))) {
                    event.setCanceled(true);
                }
            }
            if (event.getSource().equals(DamageSource.field_76368_d)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityChocobo) {
            EntityChocobo chocobo = (EntityChocobo)event.getEntity();
            chocobo.damageHandling();
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            IBlockState state = null;
            if (pos != null) {
                state = world.func_180495_p(pos);
            }
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack currentItem = player.func_184586_b(event.getHand());
            if (world.field_72995_K && event instanceof PlayerInteractEvent.RightClickItem && (state == null || state != null && !state.func_185898_k()) && currentItem != null && currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOPEDIA)) {
                GuiStarter.startChocopediaGui(null, event.getHand());
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            } else if (!world.field_72995_K) {
                if (currentItem != null && currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_YELLOW) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_BLUE) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_GREEN) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_RED) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_WHITE) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_BLACK) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_PINK) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_ROYAL) | currentItem.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_GOLD) && state != null && (state.func_177230_c() == Blocks.field_150342_X || state.func_177230_c().toString().toLowerCase().contains("bookshelf") || state.func_177230_c().toString().toLowerCase().contains("book_shelf"))) {
                    world.func_175698_g(pos);
                    ChocoboPlayerHelper.useCurrentItem(player);
                    ItemStack itemstack = new ItemStack(ChocoCraftItems.CHOCOPEDIA, 1, 0);
                    EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                    world.func_184133_a((EntityPlayer)null, pos, Reference.SE_FEED_CONFIRM, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    world.func_72838_d((Entity)entityItem);
                }
                if (state != null && GeneralConfig.debugMessages) {
                    Block targetBlock = state.func_177230_c();
                    int targetBlockMeta = targetBlock.func_176201_c(state);
                    String targetBlockUnlocName = targetBlock.func_149739_a();
                    player.func_145747_a((ITextComponent)new TextComponentString("Class path of this block: " + targetBlock.getClass().toString().substring(6)));
                    player.func_145747_a((ITextComponent)new TextComponentString("Unlocalized name: " + targetBlockUnlocName));
                    player.func_145747_a((ITextComponent)new TextComponentString("Meta value: " + targetBlockMeta));
                    player.func_145747_a((ITextComponent)new TextComponentString(""));
                }
            }
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("chococraftplus")) {
            GeneralConfig.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.isRecentlyHit()) {
            try {
                EntityLiving entity = (EntityLiving)event.getEntityLiving();
                String entityClassPath = entity.getClass().toString().substring(6);
                ArrayList classPaths = (ArrayList)GeneralConfig.unpackMobDrops(GeneralConfig.mobDrops)[0];
                ArrayList chocoItems = (ArrayList)GeneralConfig.unpackMobDrops(GeneralConfig.mobDrops)[1];
                ArrayList classdropChances = (ArrayList)GeneralConfig.unpackMobDrops(GeneralConfig.mobDrops)[2];
                String classpath = "dummy";
                String chocoItem = "dummy";
                int classdropChance = -1;
                for (int i = 0; i < classPaths.size(); ++i) {
                    classpath = (String)classPaths.get(i);
                    if (classpath.equals(entityClassPath)) {
                        NBTTagCompound compound = new NBTTagCompound();
                        entity.func_70014_b(compound);
                        int targetAge = compound.func_74762_e("Age");
                        if (targetAge < 0) continue;
                        Random random = entity.field_70170_p.field_73012_v;
                        int lootLevel = event.getLootingLevel();
                        classdropChance = (Integer)classdropChances.get(i);
                        if (random.nextInt(256) < classdropChance || lootLevel > 0 && random.nextInt(256 * lootLevel) < classdropChance * (lootLevel + 1)) {
                            chocoItem = (String)chocoItems.get(i);
                            Item itemToDrop = new Item();
                            if (chocoItem.toLowerCase().equals("gysahl")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.GYSAHL_CARROT, 1);
                            } else if (chocoItem.toLowerCase().equals("krakka")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.KRAKKA_ROOT, 1);
                            } else if (chocoItem.toLowerCase().equals("tantal")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.TANTAL_VEGGIE, 1);
                            } else if (chocoItem.toLowerCase().equals("pasana")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.PASANA_FRUIT, 1);
                            } else if (chocoItem.toLowerCase().equals("cree")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.CREE_ROOT, 1);
                            } else if (chocoItem.toLowerCase().equals("reagan")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.REAGAN_VEGGIE, 1);
                            } else if (chocoItem.toLowerCase().equals("mimett")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.MIMETT_FRUIT, 1);
                            } else if (chocoItem.toLowerCase().equals("sylkis")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.SYLKIS_BUD, 1);
                            } else if (chocoItem.toLowerCase().equals("pipio")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.PIPIO_NUT, 1);
                            } else if (chocoItem.toLowerCase().equals("luchile")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.LUCHILE_NUT, 1);
                            } else if (chocoItem.toLowerCase().equals("saraha")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.SARAHA_BEAN, 1);
                            } else if (chocoItem.toLowerCase().equals("lasan")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.LASAN_NUT, 1);
                            } else if (chocoItem.toLowerCase().equals("param")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.PARAM_NUT, 1);
                            } else if (chocoItem.toLowerCase().equals("porov")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.POROV_BEAN, 1);
                            } else if (chocoItem.toLowerCase().equals("carob")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.CAROB_NUT, 1);
                            } else if (chocoItem.toLowerCase().equals("zeio")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.ZEIO_NUT, 1);
                            } else if (chocoItem.toLowerCase().equals("gysalseeds")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.GYSAHL_GARDEN_SEEDS, 1);
                            } else if (chocoItem.toLowerCase().equals("chocopedia")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.CHOCOPEDIA, 1);
                            } else if (chocoItem.toLowerCase().equals("chocosaddle")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.CHOCOBO_SADDLE, 1);
                            } else if (chocoItem.toLowerCase().equals("saddlebags")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.CHOCOBO_SADDLE_BAGS, 1);
                            } else if (chocoItem.toLowerCase().equals("packbags")) {
                                event.getEntityLiving().func_145779_a(ChocoCraftItems.CHOCOBO_PACK_BAGS, 1);
                            }
                        }
                    }
                    chocoItem = (String)chocoItems.get(i);
                    classdropChance = (Integer)classdropChances.get(i);
                }
            }
            catch (Exception e) {
                return;
            }
        }
    }
}

