/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities.spawner;

import chococraftplus.common.ModChocoCraft;
import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChocobo;
import chococraftplus.common.entities.FactoryEntityChocobo;
import chococraftplus.common.helper.ChocoboBiomeHelper;
import chococraftplus.common.utils.ChocoFunctions;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public final class ChocoboSpawner {
    public static void doChocoboSpawning(World world, double posX, double posY, double posZ) {
        if (!world.field_72995_K) {
            int spawnRandZ;
            int maxTries = 20;
            if (world.field_73012_v.nextInt(1000) > GeneralConfig.spawnProbability) {
                ModChocoCraft.spawnDbStatus = "< prob";
                return;
            }
            int outerSpawnRadius = 64;
            int innerSpawnRadius = 32;
            if (ChocoboBiomeHelper.isWorldHell(world)) {
                outerSpawnRadius = 48;
            }
            int randDeltaX = 0;
            int randDeltaZ = 0;
            int randU = world.field_73012_v.nextInt(outerSpawnRadius + innerSpawnRadius + 1);
            int randV = world.field_73012_v.nextInt(outerSpawnRadius - innerSpawnRadius + 1);
            if (world.field_73012_v.nextBoolean()) {
                randDeltaX = randU;
                randDeltaZ = randV;
            } else {
                randDeltaX = randV;
                randDeltaZ = -randU;
            }
            if (world.field_73012_v.nextBoolean()) {
                randDeltaX *= -1;
                randDeltaZ *= -1;
            }
            if (ChocoboSpawner.canChocoboSpawnInBiome(world, posX + (double)randDeltaX, posZ + (double)randDeltaZ)) {
                if (ChocoboSpawner.isOtherPlayerNear(world, posX + (double)randDeltaX, posZ + (double)randDeltaZ, innerSpawnRadius / 2)) {
                    ModChocoCraft.spawnDbStatus = "not found";
                    return;
                }
            } else {
                return;
            }
            int spawnRandX = MathHelper.func_76128_c((double)(posX + (double)randDeltaX));
            int wildInChunks = ChocoboSpawner.countWildsWithinRegion(world, spawnRandX, spawnRandZ = MathHelper.func_76128_c((double)(posZ + (double)randDeltaZ)), GeneralConfig.spawnLimitBlockRadius);
            if (wildInChunks > GeneralConfig.spawnTotalMax) {
                ModChocoCraft.spawnDbStatus = "too many (" + wildInChunks + ")";
                return;
            }
            int distanceNextWild = ChocoboSpawner.distanceToNextWild(world, spawnRandX, spawnRandZ);
            if (distanceNextWild < GeneralConfig.distanceNextWild) {
                ModChocoCraft.spawnDbStatus = "too close (" + distanceNextWild + ")";
                return;
            }
            int spawnedChocobos = 0;
            int groupSizeDelta = GeneralConfig.spawnGroupMax - GeneralConfig.spawnGroupMin;
            int randomGroupSize = GeneralConfig.spawnGroupMin + (groupSizeDelta > 0 ? world.field_73012_v.nextInt(groupSizeDelta + 1) : 0);
            for (int i = 0; i < maxTries; ++i) {
                int chocoPosZ;
                int chocoPosY;
                int chocoPosX = (int)posX + randDeltaX + world.field_73012_v.nextInt(9) - 4;
                BlockPos chocoPos = new BlockPos(chocoPosX, chocoPosY = world.func_175672_r(new BlockPos(chocoPosX, 0, chocoPosZ = (int)posZ + randDeltaZ + world.field_73012_v.nextInt(9) - 4)).func_177956_o(), chocoPosZ);
                if (ChocoboSpawner.canChocoboSpawnAtLocation(world, chocoPos)) {
                    EntityAnimalChocobo.ChocoboColor color = EntityAnimalChocobo.ChocoboColor.YELLOW;
                    EntityChocobo newChocobo = FactoryEntityChocobo.createNewChocobo(world, color);
                    newChocobo.func_70012_b(chocoPosX, chocoPosY, chocoPosZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)newChocobo);
                    if (++spawnedChocobos < randomGroupSize) continue;
                    break;
                }
                ModChocoCraft.spawnDbStatus = "not spawn at loc";
            }
            if (spawnedChocobos > 0) {
                ModChocoCraft.spawnDbStatus = spawnedChocobos + " spawned";
            }
        }
    }

    private static int countWildsWithinRegion(World world, int posX, int posZ, int blockRadius) {
        List chocosInRegion = world.func_72872_a(EntityChocobo.class, new AxisAlignedBB((double)(posX - blockRadius), 0.0, (double)(posZ - blockRadius), (double)(posX + blockRadius), (double)world.func_72800_K(), (double)(posZ + blockRadius)));
        int untamedChocoCount = 0;
        for (int i = 0; i < chocosInRegion.size(); ++i) {
            EntityChocobo testChoco = (EntityChocobo)((Object)chocosInRegion.get(i));
            if (testChoco.func_70909_n()) continue;
            ++untamedChocoCount;
        }
        return untamedChocoCount;
    }

    private static boolean isOtherPlayerNear(World world, double posX, double posZ, int distance) {
        int topblockY = world.func_175672_r(new BlockPos(MathHelper.func_76128_c((double)posX), 0, MathHelper.func_76128_c((double)posZ))).func_177956_o();
        return world.func_184137_a(posX, (double)topblockY, posZ, (double)distance, false) != null;
    }

    private static boolean canChocoboSpawnAtLocation(World world, BlockPos pos) {
        if (!ChocoboSpawner.isNormalCubesAround(world, pos.func_177977_b())) {
            return false;
        }
        if (ChocoboSpawner.isNormalCubesAround(world, pos)) {
            return false;
        }
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return false;
        }
        if (ChocoboSpawner.isNormalCubesAround(world, pos.func_177984_a())) {
            return false;
        }
        return !ChocoboSpawner.isNormalCubesAround(world, pos.func_177981_b(2));
    }

    private static boolean isNormalCubesAround(World world, BlockPos pos) {
        for (int x = pos.func_177958_n() - 1; x <= pos.func_177958_n() + 1; ++x) {
            for (int z = pos.func_177952_p() - 1; z <= pos.func_177952_p() + 1; ++z) {
                if (world.func_180495_p(new BlockPos(x, pos.func_177956_o(), z)).func_185915_l()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canChocoboSpawnInBiome(World world, double posX, double posZ) {
        Biome biome = world.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)posX), 0, MathHelper.func_76128_c((double)posZ)));
        boolean spawnInBiomeFlag = false;
        if (GeneralConfig.spawnBiomesNames != null) {
            int dimension = world.field_73011_w.getDimension();
            for (int i = 0; i < GeneralConfig.spawnBiomesNames.length; ++i) {
                if (GeneralConfig.spawnBiomesNames[i].equals("none." + dimension)) {
                    return false;
                }
                if (!GeneralConfig.spawnBiomesNames[i].equals(ChocoFunctions.getBiomeName(biome)) && !GeneralConfig.spawnBiomesNames[i].equals("all") && !GeneralConfig.spawnBiomesNames[i].equals("all." + dimension)) continue;
                spawnInBiomeFlag = true;
            }
            return spawnInBiomeFlag;
        }
        return false;
    }

    private static int distanceToNextWild(World world, double posX, double posZ) {
        double distance = 3.4028234663852886E38;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            double tmpDistSqrd;
            EntityChocobo chocobo;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityChocobo) || (chocobo = (EntityChocobo)entity).func_70909_n() || !((tmpDistSqrd = (posX - chocobo.field_70165_t) * (posX - chocobo.field_70165_t) + (posZ - chocobo.field_70161_v) * (posZ - chocobo.field_70161_v)) < distance)) continue;
            distance = tmpDistSqrd;
        }
        return MathHelper.func_76128_c((double)Math.sqrt(distance));
    }
}

