/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities.models;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityChocobo;
import chococraftplus.common.entities.colours.EntityChocoboBlack;
import chococraftplus.common.entities.colours.EntityChocoboBlue;
import chococraftplus.common.entities.colours.EntityChocoboGold;
import chococraftplus.common.entities.colours.EntityChocoboGreen;
import chococraftplus.common.entities.colours.EntityChocoboPink;
import chococraftplus.common.entities.colours.EntityChocoboRed;
import chococraftplus.common.entities.colours.EntityChocoboRoyal;
import chococraftplus.common.entities.colours.EntityChocoboWhite;
import chococraftplus.common.entities.models.ModelChocobo;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderChocobo
extends RenderLiving {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final int MAX_NAME_DISTANCE = 20;

    public RenderChocobo(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelChocobo(), 0.5f);
    }

    public void renderChocobo(EntityChocobo entitychocobo, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entitychocobo, x, y, z, entityYaw, partialTicks);
        if (entitychocobo.canRenderName()) {
            super.func_147906_a((Entity)entitychocobo, entitychocobo.func_70005_c_(), x, y + GeneralConfig.renderNameHeight, z, 20);
        }
    }

    protected float getWingRotation(EntityChocobo entitychocobo, float f) {
        return (MathHelper.func_76126_a((float)entitychocobo.wingRotation) + 1.0f) * entitychocobo.destPos;
    }

    protected float handleRotationFloat(EntityLiving entityliving, float f) {
        return this.getWingRotation((EntityChocobo)entityliving, f);
    }

    public void func_76986_a(EntityLiving entityliving, double x, double y, double z, float entityYaw, float partialTicks) {
        this.renderChocobo((EntityChocobo)entityliving, x, y, z, entityYaw, partialTicks);
    }

    protected void preRenderScale(EntityChocobo entitychocobo, float scale) {
        float forcedScale = 0.8f;
        GL11.glScalef((float)forcedScale, (float)forcedScale, (float)forcedScale);
    }

    protected void func_77041_b(EntityLivingBase entityliving, float scale) {
        this.preRenderScale((EntityChocobo)entityliving, scale);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        if (entity instanceof EntityChocobo) {
            String cc;
            EntityChocobo chocobo = (EntityChocobo)entity;
            String[] chocoboLayeredTexture = chocobo.getLayeredTexturePaths();
            if (chocobo instanceof EntityChocoboBlue) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_blue.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_blue_male.png" : null;
                cc = "bu";
            } else if (chocobo instanceof EntityChocoboGreen) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_green.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_green_male.png" : null;
                cc = "gn";
            } else if (chocobo instanceof EntityChocoboRed) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_red.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_red_male.png" : null;
                cc = "re";
            } else if (chocobo instanceof EntityChocoboWhite) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_white.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_white_male.png" : null;
                cc = "wh";
            } else if (chocobo instanceof EntityChocoboBlack) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_black.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_black_male.png" : null;
                cc = "bk";
            } else if (chocobo instanceof EntityChocoboPink) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_pink.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_pink_male.png" : null;
                cc = "pi";
            } else if (chocobo instanceof EntityChocoboRoyal) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_royal.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_royal_male.png" : null;
                cc = "ro";
            } else if (chocobo instanceof EntityChocoboGold) {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_gold.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_gold_male.png" : null;
                cc = "go";
            } else {
                chocoboLayeredTexture[0] = "chococraftplus:textures/entity/chocobo/colors/chocobo_yellow.png";
                chocoboLayeredTexture[1] = chocobo.isMale() ? "chococraftplus:textures/entity/chocobo/colors/chocobo_yellow_male.png" : null;
                cc = "ye";
            }
            String s = "chocobo/co" + cc + chocobo.getChocoboTexturePrefix();
            ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation("chococraftplus", s);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new LayeredTexture(chocoboLayeredTexture));
                LAYERED_LOCATION_CACHE.put(s, resourcelocation);
            }
            return resourcelocation;
        }
        return null;
    }
}

