/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities.models;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityChicobo;
import chococraftplus.common.entities.models.ModelChicobo;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderChicobo
extends RenderLiving {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final int MAX_NAME_DISTANCE = 20;

    public RenderChicobo(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBase)new ModelChicobo(), 0.5f);
    }

    public void renderChicobo(EntityChicobo entitychicobo, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entitychicobo, x, y, z, entityYaw, partialTicks);
        if (entitychicobo.canRenderName() && GeneralConfig.useChocoCraftNameRendering) {
            super.func_147906_a((Entity)entitychicobo, entitychicobo.func_70005_c_(), x, y, z, 20);
        }
    }

    protected void preRenderScale(EntityChicobo entitychicobo, float scale) {
        float forcedScale = 1.32f;
        GL11.glScalef((float)forcedScale, (float)forcedScale, (float)forcedScale);
    }

    protected void preRenderCallback(EntityLiving entityliving, float scale) {
        this.preRenderScale((EntityChicobo)entityliving, scale);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        if (entity instanceof EntityChicobo) {
            EntityChicobo chicobo = (EntityChicobo)entity;
            String s = chicobo.getChicoboTexturePrefix();
            ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation("chococraftplus", s);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new LayeredTexture(chicobo.getLayeredTexturePaths()));
                LAYERED_LOCATION_CACHE.put(s, resourcelocation);
            }
            return resourcelocation;
        }
        return null;
    }
}

