/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities;

import chococraftplus.common.entities.ChocoboNames;
import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChicobo;
import chococraftplus.common.entities.EntityChocobo;
import chococraftplus.common.entities.colours.EntityChocoboBlack;
import chococraftplus.common.entities.colours.EntityChocoboBlue;
import chococraftplus.common.entities.colours.EntityChocoboGold;
import chococraftplus.common.entities.colours.EntityChocoboGreen;
import chococraftplus.common.entities.colours.EntityChocoboPink;
import chococraftplus.common.entities.colours.EntityChocoboRed;
import chococraftplus.common.entities.colours.EntityChocoboRoyal;
import chococraftplus.common.entities.colours.EntityChocoboWhite;
import chococraftplus.common.entities.colours.EntityChocoboYellow;
import chococraftplus.common.utils.Reference;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.World;

public class FactoryEntityChocobo {
    public static EntityChocobo createNewChocobo(World world, EntityAnimalChocobo.ChocoboColor color) {
        EntityChocobo entityChocobo;
        boolean isMale = new Random().nextInt(100) < 50;
        String name = "";
        switch (color) {
            case YELLOW: {
                entityChocobo = new EntityChocoboYellow(world);
                break;
            }
            case GREEN: {
                entityChocobo = new EntityChocoboGreen(world);
                break;
            }
            case BLUE: {
                entityChocobo = new EntityChocoboBlue(world);
                break;
            }
            case WHITE: {
                entityChocobo = new EntityChocoboWhite(world);
                break;
            }
            case BLACK: {
                entityChocobo = new EntityChocoboBlack(world);
                break;
            }
            case GOLD: {
                entityChocobo = new EntityChocoboGold(world);
                break;
            }
            case PINK: {
                entityChocobo = new EntityChocoboPink(world);
                break;
            }
            case RED: {
                entityChocobo = new EntityChocoboRed(world);
                break;
            }
            case ROYAL: {
                entityChocobo = new EntityChocoboRoyal(world);
                break;
            }
            default: {
                entityChocobo = new EntityChocoboYellow(world);
            }
        }
        entityChocobo.setIsMale(isMale);
        entityChocobo.setName(name);
        return entityChocobo;
    }

    public static EntityChocobo createChocobo(World world, EntityAnimalChocobo.ChocoboColor color, String name, UUID owner, boolean hidename, boolean tamed, boolean following, boolean wander, boolean male) {
        EntityChocobo chocobo = FactoryEntityChocobo.createNewChocobo(world, color);
        chocobo.setName(name);
        chocobo.func_184754_b(owner);
        chocobo.setHidename(hidename);
        chocobo.func_70903_f(tamed);
        chocobo.setFollowing(following);
        chocobo.setWander(wander);
        chocobo.setIsMale(male);
        return chocobo;
    }

    public static EntityChocobo createChocoboFromChocobo(World world, EntityAnimalChocobo sourceChocobo) {
        EntityChocobo chocobo = FactoryEntityChocobo.createNewChocobo(world, sourceChocobo.color);
        chocobo.setName(sourceChocobo.func_70005_c_());
        chocobo.func_184754_b(sourceChocobo.func_184753_b());
        chocobo.setHidename(sourceChocobo.isHidename());
        chocobo.func_70903_f(sourceChocobo.func_70909_n());
        chocobo.setFollowing(sourceChocobo.isFollowing());
        chocobo.setWander(sourceChocobo.isWander());
        chocobo.setIsMale(sourceChocobo.isMale());
        return chocobo;
    }

    public static EntityChicobo createNewChicobo(World world, EntityAnimalChocobo.ChocoboColor color) {
        EntityChicobo chicobo = new EntityChicobo(world);
        chicobo.setColor(color);
        chicobo.setName("");
        return chicobo;
    }

    public static EntityChocobo createStableChocobo(World world, Random random) {
        EntityChocoboYellow stableChocobo = new EntityChocoboYellow(world);
        int drawFromTen = random.nextInt(10);
        int dash = (new int[]{3000, 3200, 3700, 4500})[drawFromTen < 4 ? 0 : (drawFromTen < 7 ? 1 : (drawFromTen < 9 ? 2 : 3))];
        drawFromTen = random.nextInt(10);
        int run = (new int[]{2200, 2500, 3000, 3500})[drawFromTen < 4 ? 0 : (drawFromTen < 7 ? 1 : (drawFromTen < 9 ? 2 : 3))];
        int acceleration = 50;
        drawFromTen = random.nextInt(10);
        int cooperation = (new int[]{50, 60, 80, 100})[drawFromTen < 4 ? 0 : (drawFromTen < 7 ? 1 : (drawFromTen < 9 ? 2 : 3))];
        drawFromTen = random.nextInt(10);
        int intelligence = (new int[]{50, 60, 80, 100})[drawFromTen < 4 ? 0 : (drawFromTen < 7 ? 1 : (drawFromTen < 9 ? 2 : 3))];
        drawFromTen = random.nextInt(10);
        int stamina = (new int[]{3200, 3400, 4000, 6000})[drawFromTen < 4 ? 0 : (drawFromTen < 7 ? 1 : (drawFromTen < 9 ? 2 : 3))] + (random.nextBoolean() ? 1 : -1) * random.nextInt(128);
        if (dash == run) {
            dash += 50;
            run -= 50;
        } else if (dash < run) {
            drawFromTen = dash;
            dash = run;
            run = drawFromTen;
        }
        int dashMaxDenominator = random.nextInt(4) + 5;
        int movementVariation = (random.nextBoolean() ? 1 : -1) * random.nextInt(128);
        int dashMax = Math.min(dash * 10 / dashMaxDenominator + movementVariation, 6000);
        int runMax = Math.min(dashMax - 100 * (2 + random.nextInt(3)), 6000);
        run += movementVariation * dashMaxDenominator / 10;
        for (dash = dashMax * dashMaxDenominator / 10; dash >= dashMax; dash -= 100) {
        }
        while (runMax >= dashMax) {
            runMax -= 100;
        }
        while (run >= dash || run >= runMax) {
            run -= 100;
        }
        int rating = 7;
        int personality = random.nextInt(8) == 0 ? random.nextInt(10) : 82;
        stableChocobo.setDashMax(dashMax);
        stableChocobo.setDash(dash);
        stableChocobo.setRunMax(runMax);
        stableChocobo.setRun(run);
        stableChocobo.setStamina(stamina);
        stableChocobo.setAcceleration(acceleration);
        stableChocobo.setCooperation(cooperation);
        stableChocobo.setIntelligence(intelligence);
        stableChocobo.setRating(rating);
        stableChocobo.setPersonality(personality);
        boolean pennedChocIsMale = random.nextBoolean();
        stableChocobo.setIsMale(pennedChocIsMale);
        String randomName = ChocoboNames.getRandomName(pennedChocIsMale);
        stableChocobo.setName(randomName);
        stableChocobo.setChocoID(stableChocobo.func_145782_y());
        stableChocobo.setHidename(false);
        stableChocobo.setFollowing(false);
        stableChocobo.setWander(true);
        stableChocobo.func_70903_f(true);
        stableChocobo.changeOwnership(Reference.STABLEHAND_UUID);
        return stableChocobo;
    }
}

