/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities;

import chococraftplus.common.ModChocoCraft;
import chococraftplus.common.bags.ChocoBagInventory;
import chococraftplus.common.bags.ChocoPackBagInventory;
import chococraftplus.common.bags.ChocoSaddleBagInventory;
import chococraftplus.common.entities.ChocoboRiderList;
import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.RiderActionState;
import chococraftplus.common.network.PacketRegistry;
import chococraftplus.common.network.serverSide.ChocoboDropGear;
import chococraftplus.common.network.serverSide.ChocoboMount;
import chococraftplus.common.registry.ChocoCraftItems;
import chococraftplus.common.utils.Reference;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class EntityChocoboRideable
extends EntityAnimalChocobo {
    protected double prevMotionX;
    protected double prevMotionZ;
    protected boolean shouldSteer;
    protected boolean flying;
    protected boolean isHighJumping;
    public RiderActionState riderActionState;
    protected ChocoBagInventory bagsInventory;
    protected ChocoboRiderList riderList = new ChocoboRiderList();
    public static final DataParameter<Byte> DM_FLAGS = EntityDataManager.func_187226_a(EntityChocoboRideable.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final int DW_VAL_ECR_SADDLED_ON = 1;
    public static final int DW_VAL_ECR_SADDLED_OFF = -2;
    public static final int DW_VAL_ECR_SADDLEBAGGED_ON = 2;
    public static final int DW_VAL_ECR_SADDLEBAGGED_OFF = -3;
    public static final int DW_VAL_ECR_PACKBAGGED_ON = 4;
    public static final int DW_VAL_ECR_PACKBAGGED_OFF = -5;

    public EntityChocoboRideable(World world) {
        super(world);
        this.riderActionState = new RiderActionState();
    }

    public abstract void setStepHeight(boolean var1);

    public abstract void setJumpHigh(boolean var1);

    public abstract void setRiderAbilities(boolean var1);

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DM_FLAGS, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Saddle", this.isSaddled());
        nbttagcompound.func_74757_a("SaddleBag", this.isSaddleBagged().booleanValue());
        nbttagcompound.func_74757_a("PackBag", this.isPackBagged().booleanValue());
        if (null != this.bagsInventory) {
            nbttagcompound.func_74782_a("SaddleBagInventory", this.bagsInventory.writeToNBT(new NBTTagList()));
        }
        if (null != this.riderList) {
            nbttagcompound.func_74782_a("riderList", this.riderList.writeToNBT(new NBTTagList()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setFollowing(false);
        this.setWander(this.getPersonality() < 82 && this.getPersonality() % 2 == 0 || this.func_184753_b() == null || !this.func_70909_n() || this.func_184753_b().equals(Reference.STABLEHAND_UUID.toString()));
        this.setSaddled(nbttagcompound.func_74767_n("Saddle"));
        this.setSaddleBagged(nbttagcompound.func_74767_n("SaddleBag"));
        this.setPackBagged(nbttagcompound.func_74767_n("PackBag"));
        if (nbttagcompound.func_74764_b("SaddleBagInventory") && null != this.bagsInventory) {
            this.bagsInventory.readFromNBT((NBTTagList)nbttagcompound.func_74781_a("SaddleBagInventory"));
        }
        if (nbttagcompound.func_74764_b("riderList") && null != this.riderList) {
            this.riderList.readFromNBT((NBTTagList)nbttagcompound.func_74781_a("riderList"));
        }
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeBoolean(this.isSaddled());
        data.writeBoolean(this.isSaddleBagged().booleanValue());
        data.writeBoolean(this.isPackBagged().booleanValue());
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.setSaddled(data.readBoolean());
        this.setSaddleBagged(data.readBoolean());
        this.setPackBagged(data.readBoolean());
    }

    public void setRiderActionState(RiderActionState ras) {
        this.riderActionState.setMoveStrafe(ras.getMoveStrafe());
        this.riderActionState.setMoveForward(ras.getMoveForward());
        this.riderActionState.setJump(ras.isJump());
        this.riderActionState.setSneak(ras.isSneak());
        this.riderActionState.setSprint(ras.isSprint());
    }

    @Override
    public void func_70636_d() {
        if (this.func_184179_bs() != null) {
            ModChocoCraft.PROXY.updateRiderActionState(this, this.func_184179_bs());
            this.setRotationYawAndPitch();
            this.setStepHeight(true);
            this.setJumpHigh(true);
            this.setRiderAbilities(true);
        } else {
            this.setStepHeight(false);
            this.setJumpHigh(false);
            this.setRiderAbilities(false);
        }
        super.func_70636_d();
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70645_a(DamageSource damageSource) {
        if (this.isServer()) {
            if (this.isSaddled()) {
                this.func_145779_a(ChocoCraftItems.CHOCOBO_SADDLE, 1);
            }
            if (this.isSaddleBagged().booleanValue()) {
                this.func_145779_a(ChocoCraftItems.CHOCOBO_SADDLE_BAGS, 1);
                this.bagsInventory.dropAllItems();
            }
            if (this.isPackBagged().booleanValue()) {
                this.func_145779_a(ChocoCraftItems.CHOCOBO_PACK_BAGS, 1);
                this.bagsInventory.dropAllItems();
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityplayer, EnumHand hand) {
        boolean interacted = super.func_184645_a(entityplayer, hand);
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (!interacted) {
            if (entityplayer.func_70093_af()) {
                if (this.isSaddleBagged().booleanValue() || this.isPackBagged().booleanValue()) {
                    return this.onOpenSaddlePackBagInteraction(entityplayer);
                }
                if (this.isSaddled()) {
                    return true;
                }
            }
            if (itemstack != null) {
                if (itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_SADDLE)) {
                    this.onSaddleUse(entityplayer);
                    return true;
                }
                if (itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_SADDLE_BAGS)) {
                    this.onSaddleBagsUse(entityplayer);
                    return true;
                }
                if (itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_PACK_BAGS)) {
                    this.onPackBagsUse(entityplayer);
                    return true;
                }
            }
        }
        return interacted;
    }

    @Override
    protected boolean onEmptyHandInteraction(EntityPlayer entityplayer) {
        boolean interacted = super.onEmptyHandInteraction(entityplayer);
        if (this.isSaddled() && (this.func_184179_bs() == null || this.func_184179_bs() == entityplayer)) {
            if (this.isClient()) {
                this.sendMountUpdate();
                if (this.func_184179_bs() == null) {
                    this.mountChocobo(entityplayer);
                }
            }
            interacted = true;
        }
        return interacted;
    }

    public void onSaddleUse(EntityPlayer entityplayer) {
        if (this.func_70909_n() && !this.isSaddled() && !this.isSaddleBagged().booleanValue() && !this.isPackBagged().booleanValue() && (entityplayer.field_71075_bZ.field_75098_d || this.isOwner(entityplayer) || this.func_184753_b().equals(Reference.STABLEHAND_UUID.toString()))) {
            this.setSaddled(true);
            this.useItem(entityplayer, 1);
        }
    }

    public void onPackBagsUse(EntityPlayer entityplayer) {
        if (this.func_70909_n() && !this.isSaddled() && !this.isSaddleBagged().booleanValue() && !this.isPackBagged().booleanValue() && (entityplayer.field_71075_bZ.field_75098_d || this.isOwner(entityplayer) || this.func_184753_b().equals(Reference.STABLEHAND_UUID.toString()))) {
            this.setPackBagged(true);
            this.useItem(entityplayer, 1);
        }
    }

    public void onSaddleBagsUse(EntityPlayer entityplayer) {
        if (this.func_70909_n() && this.isSaddled() && !this.isSaddleBagged().booleanValue() && !this.isPackBagged().booleanValue() && (entityplayer.field_71075_bZ.field_75098_d || this.isOwner(entityplayer) || this.func_184753_b().equals(Reference.STABLEHAND_UUID.toString()))) {
            this.setSaddleBagged(true);
            this.useItem(entityplayer, 1);
        }
    }

    protected boolean onOpenSaddlePackBagInteraction(EntityPlayer entityplayer) {
        boolean interacted = false;
        if (entityplayer.func_70093_af() && this.isSaddleBagged().booleanValue()) {
            entityplayer.openGui((Object)ModChocoCraft.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
            interacted = true;
        } else if (entityplayer.func_70093_af() && this.isPackBagged().booleanValue()) {
            entityplayer.openGui((Object)ModChocoCraft.instance, 0, this.field_70170_p, this.func_145782_y(), 1, 0);
            interacted = true;
        }
        return interacted;
    }

    protected void setRotationYawAndPitch() {
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer && this.isServer()) {
            this.field_70125_A = 0.0f;
            EntityPlayer pilot = (EntityPlayer)this.func_184179_bs();
            this.field_70177_z = pilot.field_70177_z;
            this.field_70126_B = pilot.field_70126_B;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70091_d(MoverType movertype, double moveX, double moveY, double moveZ) {
        double speedLimit;
        if (this.func_184179_bs() instanceof EntityPlayer) {
            this.field_70759_as = this.func_184179_bs().field_70177_z;
            if (this.riderActionState.isJump()) {
                if (this.canFly) {
                    this.field_70181_x = 0.08 + 2.0 * (double)((float)this.getRun() / 10000.0f);
                    this.setFlying(true);
                } else if (this.canHighJumpPresently && !this.isHighJumping && !this.anyPartInWater()) {
                    this.field_70181_x += 1.12;
                    this.isHighJumping = true;
                    this.chocoboJumpAddons();
                } else if (this.field_70122_E && !this.isHighJumping) {
                    this.field_70181_x += 0.64;
                    this.chocoboJumpAddons();
                }
            } else if (this.canSoftFall && !this.anyPartInWater()) {
                this.field_70181_x = -0.1;
            }
        }
        if (this.field_70181_x > (speedLimit = Math.max(0.08 + 2.0 * (double)((float)this.getRun() / 10000.0f), Math.max(0.64, 0.16)))) {
            this.field_70181_x = Math.max(this.field_70181_x, speedLimit);
        }
        super.func_70091_d(movertype, moveX, this.field_70181_x, moveZ);
    }

    private void chocoboJumpAddons() {
        if (this.func_70644_a(MobEffects.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public void setFlying(Boolean flying) {
        this.flying = flying;
    }

    public Boolean isFlying() {
        return this.flying;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184179_bs() != null && this.func_184179_bs() == passenger) {
            float radius = 0.4f;
            double deltaPosX = MathHelper.func_76134_b((float)((this.field_70761_aq - 90.0f) * (float)Math.PI / 180.0f)) * radius;
            double deltaPosZ = MathHelper.func_76126_a((float)((this.field_70761_aq - 90.0f) * (float)Math.PI / 180.0f)) * radius;
            passenger.func_70107_b(this.field_70165_t + deltaPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + deltaPosZ);
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityPlayer;
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        return entity instanceof EntityPlayer ? !this.field_70170_p.field_72995_K : false;
    }

    public double func_70042_X() {
        return 1.3;
    }

    public boolean isSaddled() {
        return ((Byte)this.field_70180_af.func_187225_a(DM_FLAGS) & 1) != 0;
    }

    public void setSaddled(boolean saddled) {
        byte ecrFlags = (Byte)this.field_70180_af.func_187225_a(DM_FLAGS);
        if (saddled) {
            this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(ecrFlags | 1)));
        } else {
            this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(ecrFlags & 0xFFFFFFFE)));
        }
    }

    public IInventory getIInventory() {
        return this.bagsInventory;
    }

    public ChocoBagInventory getChocoBagInventory() {
        return this.bagsInventory;
    }

    public void injectInventory(ChocoBagInventory inventory) {
        if (inventory != null) {
            this.bagsInventory = inventory;
        }
    }

    public Boolean isSaddleBagged() {
        return ((Byte)this.field_70180_af.func_187225_a(DM_FLAGS) & 2) != 0;
    }

    public void setSaddleBagged(boolean saddleBags) {
        if (saddleBags != this.isSaddleBagged() || this.bagsInventory == null) {
            byte ecrFlags = (Byte)this.field_70180_af.func_187225_a(DM_FLAGS);
            if (saddleBags) {
                this.bagsInventory = new ChocoSaddleBagInventory(this);
                this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(ecrFlags | 2)));
            } else {
                this.bagsInventory = null;
                this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(ecrFlags & 0xFFFFFFFD)));
            }
        }
    }

    public Boolean isPackBagged() {
        return ((Byte)this.field_70180_af.func_187225_a(DM_FLAGS) & 4) != 0;
    }

    public void setPackBagged(boolean packBagged) {
        if (packBagged != this.isPackBagged() || this.bagsInventory == null) {
            byte ecrFlags = (Byte)this.field_70180_af.func_187225_a(DM_FLAGS);
            if (packBagged) {
                this.bagsInventory = new ChocoPackBagInventory(this);
                this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(ecrFlags | 4)));
            } else {
                this.bagsInventory = null;
                this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(ecrFlags & 0xFFFFFFFB)));
            }
        }
    }

    @Override
    protected boolean func_70692_ba() {
        return super.func_70692_ba() && !this.isSaddled();
    }

    public void mountChocobo(EntityPlayer player) {
        player.func_70031_b(false);
        this.setStepHeight(true);
        this.setJumpHigh(true);
        player.func_184220_m((Entity)this);
    }

    public void dismountChocobo(EntityPlayer player) {
        this.field_70703_bu = false;
        this.field_191988_bg = 0.0f;
        this.field_70702_br = 0.0f;
        this.setStepHeight(false);
        this.setJumpHigh(false);
        player.func_184220_m(null);
    }

    public void sendMountUpdate() {
        if (this.isClient()) {
            ChocoboMount packet = new ChocoboMount(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }

    public void sendDropGearUpdate() {
        if (this.isClient()) {
            ChocoboDropGear packet = new ChocoboDropGear(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
            this.setSaddleBagged(false);
            this.setSaddled(false);
            this.setPackBagged(false);
        }
    }

    public boolean shouldRiderFaceForward(EntityPlayer player) {
        return true;
    }
}

