/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChicobo;
import chococraftplus.common.entities.EntityChocoboRideable;
import chococraftplus.common.entities.ai.ChocoboAIMate;
import chococraftplus.common.helper.ChocoboParticleHelper;
import chococraftplus.common.registry.ChocoCraftItems;
import chococraftplus.common.utils.LogHelper;
import chococraftplus.common.utils.Reference;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityChocobo
extends EntityChocoboRideable {
    public float wingRotation = 0.0f;
    public float destPos = 0.0f;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextFeather;
    private int disobeyYawTicks = 0;
    private float lockedYaw;
    public static final DataParameter<Byte> DM_FLAGS = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final int DW_VAL_CHOC_BREEDING_ON = 1;
    public static final int DW_VAL_CHOC_BREEDING_OFF = -2;
    private String texturePrefix;
    private final String[] chocoboTexturesArray = new String[3];

    public EntityChocobo(World world) {
        super(world);
        this.func_70105_a(1.2f, 1.9f);
        this.timeUntilNextFeather = this.field_70146_Z.nextInt(GeneralConfig.featherDelayRandom + 1) + GeneralConfig.featherDelayStatic;
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIMate(this, 1.0));
    }

    private void resetTexturePrefix() {
        this.texturePrefix = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setChocoboTexturePaths() {
        this.chocoboTexturesArray[2] = this.isPackBagged() != false ? "chococraftplus:textures/entity/chocobo/pieces/packbag.png" : (this.isSaddleBagged() != false ? "chococraftplus:textures/entity/chocobo/pieces/saddlebags.png" : (this.isSaddled() ? "chococraftplus:textures/entity/chocobo/pieces/saddle.png" : (this.func_70909_n() ? "chococraftplus:textures/entity/chocobo/pieces/ribbon.png" : null)));
        this.texturePrefix = "_" + (this.isMale() ? "m" : "f") + "_" + (this.isPackBagged() != false ? "p" : (this.isSaddleBagged() != false ? "b" : (this.isSaddled() ? "s" : (this.func_70909_n() ? "t" : "w"))));
    }

    @SideOnly(value=Side.CLIENT)
    public String getChocoboTexturePrefix() {
        this.setChocoboTexturePaths();
        return this.texturePrefix;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getLayeredTexturePaths() {
        this.setChocoboTexturePaths();
        return this.chocoboTexturesArray;
    }

    public float func_70047_e() {
        return this.field_70131_O * 1.05f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DM_FLAGS, (Object)0);
    }

    protected abstract float getChocoboMaxHealth();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getChocoboMaxHealth());
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
    }

    public abstract String getEntityColourTexture();

    public boolean shouldDismountInWater(Entity rider) {
        return !this.canWaterTread;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.disobeyYawTicks > 0) {
            --this.disobeyYawTicks;
        }
        if (this.isFlying().booleanValue() && this.field_70122_E) {
            this.setFlying(false);
        }
        if (this.isHighJumping && this.field_70122_E) {
            this.isHighJumping = false;
        }
        if (this.anyPartInWater() && this.canWaterTread) {
            this.field_70181_x += 0.065;
            if (this.func_184179_bs() == null) {
                this.field_70181_x *= 0.8;
            }
        }
    }

    public boolean func_70072_I() {
        if (this.canWaterTread) {
            boolean expandbb = (double)Math.abs(this.field_191988_bg) > 0.05;
            if (this.field_70170_p.func_72918_a(this.func_174813_aQ().func_72314_b(0.0, expandbb ? -0.4 : -1.0, 0.0).func_186664_h(0.001), Material.field_151586_h, (Entity)this)) {
                boolean firstUpdate_f = (Boolean)ReflectionHelper.getPrivateValue(Entity.class, (Object)((Object)this), (String[])new String[]{"firstUpdate", "field_70148_d"});
                if (!this.field_70171_ac && !firstUpdate_f) {
                    float f3;
                    float f2;
                    float fsplashvol = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w * (double)0.2f + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y * (double)0.2f)) * 0.2f;
                    if (fsplashvol > 1.0f) {
                        fsplashvol = 1.0f;
                    }
                    fsplashvol *= fsplashvol;
                    this.func_184185_a(this.func_184181_aa(), fsplashvol, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                    float footpos = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
                    int i = 0;
                    while ((float)i < 1.0f + this.field_70130_N * 10.0f) {
                        f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                        f3 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + (double)f2, (double)(footpos + 1.0f), this.field_70161_v + (double)f3, this.field_70159_w, this.field_70181_x - (double)(this.field_70146_Z.nextFloat() * 0.2f), this.field_70179_y, new int[0]);
                        ++i;
                    }
                    i = 0;
                    while ((float)i < 1.0f + this.field_70130_N * 5.0f) {
                        f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                        f3 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f2, (double)(footpos + 1.0f), this.field_70161_v + (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                        ++i;
                    }
                }
                this.field_70143_R = 0.0f;
                this.field_70171_ac = true;
                ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)((Object)this), (Object)0, (String)"field_190534_ay");
            } else {
                this.field_70171_ac = false;
            }
            return this.field_70171_ac;
        }
        return super.func_70072_I();
    }

    public float func_70689_ay() {
        float landspeed = (float)this.getRun() / 10000.0f;
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
            if (this.field_70122_E && this.riderActionState.isSprint()) {
                if (this.func_110143_aJ() * 4.0f > this.func_110138_aP() && this.func_110143_aJ() > 1.0f) {
                    --this.staminaSprintCounter;
                    if (this.staminaSprintCounter <= 0) {
                        this.staminaSprintCounter = 15;
                        this.func_70606_j(this.func_110143_aJ() - 1.0f);
                        this.sendHealthUpdate();
                    }
                    return landspeed * (float)this.getDash() / (float)this.getRun();
                }
                this.riderActionState.setSprint(false);
            }
        } else if (this.isFollowing().booleanValue() && this.getOwner() != null) {
            return (float)Math.min((double)(landspeed * (float)(this.getDash() + this.getRun()) / (float)(2 * this.getRun()) * (float)(this.getPersonality() / 2 >= 41 ? 2 : 1)), Math.max((Math.sqrt(this.func_70068_e((Entity)this.getOwner())) - 2.5) * 0.16, 0.0));
        }
        return landspeed;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184179_bs() != null) {
            strafe = ((EntityLivingBase)this.func_184179_bs()).field_70702_br * (float)this.getAcceleration() / 100.0f;
            forward = ((EntityLivingBase)this.func_184179_bs()).field_191988_bg;
            if (!this.field_70170_p.field_72995_K) {
                if (this.disobeyYawTicks <= 0) {
                    if (this.riderActionState.getMoveForward() != 0.0f || this.riderActionState.getMoveStrafe() != 0.0f) {
                        int jitterint;
                        if (this.field_70173_aa % (this.getIntelligence() * 2 + 1) == 0 || this.field_70173_aa % (this.getCooperation() * 2 + 1) == 0) {
                            this.lockedYaw = (float)((double)this.field_70177_z + this.field_70146_Z.nextGaussian() * (double)(100 - this.getCooperation()) * (double)1.8f);
                            this.disobeyYawTicks += this.field_70146_Z.nextInt(101 - this.getCooperation()) / 10;
                            this.disobeyYawTicks += this.field_70146_Z.nextInt(101 - this.getIntelligence()) / 2;
                        }
                        if ((jitterint = this.field_70146_Z.nextInt(100)) >= this.getCooperation() && (this.field_70122_E || this.field_70146_Z.nextBoolean())) {
                            float chocoSpeed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                            chocoSpeed = (float)((double)chocoSpeed * 0.707);
                            this.func_70024_g(this.field_70146_Z.nextGaussian() * (double)chocoSpeed, 0.0, this.field_70146_Z.nextGaussian() * (double)chocoSpeed);
                        }
                    }
                } else if (this.disobeyYawTicks > 0) {
                    this.field_70177_z = this.lockedYaw;
                }
                if (this.anyPartInWater()) {
                    this.field_70747_aH = (float)this.getRun() / 10000.0f * (this.canWaterTread ? 0.28f : 0.0f);
                } else {
                    if (!this.field_70122_E) {
                        this.field_70160_al = true;
                    }
                    this.field_70747_aH = 0.28f * ((float)this.getRun() / 10000.0f);
                }
                this.func_70659_e(forward);
                super.func_191986_a(strafe, vertical, forward);
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70880_s() && this.entityToAttack != null) {
            EntityAnimalChocobo otherChoco;
            if (this.isClient()) {
                ChocoboParticleHelper.showParticleAroundEntityFx(34, (Entity)this);
            }
            if (this.entityToAttack instanceof EntityAnimalChocobo && !(otherChoco = (EntityAnimalChocobo)this.entityToAttack).func_70880_s()) {
                this.entityToAttack = null;
                this.hasMate = false;
            }
        }
        if (this.isClient()) {
            this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
            this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
                this.wingRotDelta = 1.0f;
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.8;
            }
            this.wingRotation += this.wingRotDelta * 2.0f;
        }
        if (this.isServer() && --this.timeUntilNextFeather <= 0) {
            if (this.field_70146_Z.nextInt(100) < GeneralConfig.featherDropChance) {
                this.dropFeather();
            }
            this.timeUntilNextFeather = this.field_70146_Z.nextInt(GeneralConfig.featherDelayRandom + 1) + GeneralConfig.featherDelayStatic;
        }
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(100) < GeneralConfig.chocoSoundFrequency) {
            if (this.func_70909_n()) {
                return Reference.SE_CHOCO_TAME_IDLE;
            }
            return Reference.SE_CHOCO_WILD_IDLE;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return Reference.SE_CHOCO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return Reference.SE_CHOCO_DEATH;
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityplayer, EnumHand hand) {
        boolean interacted = super.func_184645_a(entityplayer, hand);
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        int foodWeight = 0;
        if (!entityplayer.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && GeneralConfig.debugMessages) {
            LogHelper.info("Sex: " + (this.isMale() ? "Male" : "Female"));
            LogHelper.info("Health: " + this.func_110143_aJ() + "/" + this.func_110138_aP());
            LogHelper.info("Stamina: " + this.getStamina());
            LogHelper.info("Stamina ticker: " + this.staminaSprintCounter);
            LogHelper.info("Dash: " + this.getDash() + "/" + this.getDashMax());
            LogHelper.info("Run: " + this.getRun() + "/" + this.getRunMax());
            LogHelper.info("Acceleration: " + this.getAcceleration());
            LogHelper.info("Intelligence: " + this.getIntelligence());
            LogHelper.info("Cooperation: " + this.getCooperation());
            LogHelper.info("Rating: " + this.getRating());
            LogHelper.info("Personality: " + this.getPersonality());
            LogHelper.info("Time until hungry: " + this.getTimeUntilHunger());
            LogHelper.info("Time until can breed: " + this.getChocoAge());
            LogHelper.info("isInLove: " + this.func_70880_s());
            LogHelper.info("IDs - this: " + this.getChocoID() + "  mom: " + this.getChocoMomID() + "  dad: " + this.getChocoDadID());
        }
        if (!interacted) {
            if (itemstack == null || itemstack.func_190916_E() == 0) {
                interacted = this.onOpenSaddlePackBagInteraction(entityplayer);
            } else {
                if (itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_YELLOW) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_BLUE) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_GREEN) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_RED) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_WHITE) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_BLACK) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_PINK) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_ROYAL) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_GOLD)) {
                    this.onFeatherUse(entityplayer);
                    return true;
                }
                if (itemstack.func_77973_b().equals(Items.field_151057_cb)) {
                    return false;
                }
                if (itemstack.func_77973_b().equals(ChocoCraftItems.PIPIO_NUT)) {
                    foodWeight = 1;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.LUCHILE_NUT)) {
                    foodWeight = 2;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.SARAHA_BEAN)) {
                    foodWeight = 3;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.LASAN_NUT)) {
                    foodWeight = 4;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.POROV_BEAN)) {
                    foodWeight = 5;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.PARAM_NUT)) {
                    foodWeight = 6;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.CAROB_NUT)) {
                    foodWeight = 7;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.ZEIO_NUT)) {
                    foodWeight = 8;
                }
                if (foodWeight > 0) {
                    this.onFeedNut(entityplayer, foodWeight);
                    return true;
                }
            }
        }
        if (!interacted) {
            interacted = this.onOpenSaddlePackBagInteraction(entityplayer);
        }
        if (!interacted) {
            interacted = this.onEmptyHandInteraction(entityplayer);
        }
        if (!interacted && entityplayer.func_70093_af()) {
            return true;
        }
        return interacted;
    }

    @Override
    protected boolean onEmptyHandInteraction(EntityPlayer entityplayer) {
        return super.onEmptyHandInteraction(entityplayer);
    }

    public void onFeedNut(EntityPlayer player, int nutType) {
        if (this.func_70909_n() && (player.field_71075_bZ.field_75098_d || this.getChocoAge() == 0 && this.func_184753_b().toString().equals(player.func_110124_au().toString()))) {
            this.fedNutType = nutType;
            this.useItem(player, 1);
            this.setInLove(true);
            this.entityToAttack = null;
            this.showAmountHeartsOrSmokeFx(true, 7);
            this.func_184185_a(Reference.SE_CHOCO_TAME_IDLE, 1.0f, 1.0f);
            this.feeding(nutType);
            this.sendHungerUpdate();
        } else {
            this.showAmountHeartsOrSmokeFx(false, 7);
            this.func_184185_a(Reference.SE_CHOCO_SMOKE, 1.0f, 1.0f);
        }
    }

    public void onFeatherUse(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || this.func_70909_n() && this.isOwner(player)) {
            this.toggleFollowWanderStay(player, false);
        } else {
            this.showAmountHeartsOrSmokeFx(false, 7);
        }
    }

    public void dropFeather() {
        if (this.isServer()) {
            Item feather = ChocoCraftItems.CHOCOBO_FEATHER_YELLOW;
            switch (this.color) {
                case BLUE: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_BLUE;
                    break;
                }
                case GREEN: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_GREEN;
                    break;
                }
                case RED: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_RED;
                    break;
                }
                case WHITE: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_WHITE;
                    break;
                }
                case BLACK: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_BLACK;
                    break;
                }
                case PINK: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_PINK;
                    break;
                }
                case ROYAL: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_ROYAL;
                    break;
                }
                case GOLD: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_GOLD;
                    break;
                }
                default: {
                    feather = ChocoCraftItems.CHOCOBO_FEATHER_YELLOW;
                }
            }
            this.func_70099_a(new ItemStack(feather), 0.0f);
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (this.isServer()) {
            super.func_70628_a(par1, par2);
        }
    }

    protected Item func_146068_u() {
        if (this.func_70027_ad()) {
            return ChocoCraftItems.COOKED_CHOCOBO_LEG;
        }
        return ChocoCraftItems.RAW_CHOCOBO_LEG;
    }

    @Override
    protected void func_70619_bc() {
        if (!this.field_70170_p.field_73010_i.isEmpty()) {
            if (this.func_184179_bs() != null && this.func_184179_bs() instanceof EntityPlayer) {
                List list;
                EntityPlayer pilot = (EntityPlayer)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = pilot.field_70177_z;
                this.field_70125_A = 0.0f;
                this.field_70127_C = 0.0f;
                this.func_70637_d(this.riderActionState.isJump());
                double d = Math.abs(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                if (d > 0.375) {
                    double d1 = 0.375 / d;
                    this.field_70159_w *= d1;
                    this.field_70179_y *= d1;
                }
                if ((list = this.field_70170_p.func_72839_b((Entity)pilot, this.func_174813_aQ().func_186662_g(1.0))) != null) {
                    for (Object aList : list) {
                        Entity entity = (Entity)aList;
                        if (entity.field_70128_L) continue;
                        entity.func_70100_b_(pilot);
                    }
                }
                return;
            }
            if (!this.hasAttacked && !this.func_70781_l() && this.isFollowing().booleanValue() && this.func_70909_n()) {
                EntityPlayer owner = this.getOwner();
                if (owner != null) {
                    if (owner.field_70128_L) {
                        this.setFollowing(false);
                        int personality = this.getPersonality();
                        this.setWander(personality / 2 < 41 && personality % 2 == 0);
                        this.setStepHeight(false);
                        return;
                    }
                    float distanceToOwner = owner.func_70032_d((Entity)this);
                    if (distanceToOwner > 10.0f) {
                        this.getPathOrWalkableBlock((Entity)owner, distanceToOwner);
                    } else {
                        super.func_70619_bc();
                    }
                }
            } else if (!this.isSaddled() || this.isFollowing().booleanValue() || this.func_70880_s()) {
                super.func_70619_bc();
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        int randFeatherAmount = new Random().nextInt(3);
        for (int i = 0; i <= randFeatherAmount; ++i) {
            this.dropFeather();
        }
        super.func_70645_a(damageSource);
    }

    public boolean func_70878_b(EntityAnimal otherEntity) {
        if (otherEntity != this && otherEntity instanceof EntityAnimalChocobo && !((EntityAnimalChocobo)otherEntity).func_70631_g_()) {
            EntityAnimalChocobo otherChocobo = (EntityAnimalChocobo)otherEntity;
            int thisID = this.getChocoID();
            int thismom = this.getChocoMomID();
            int thisdad = this.getChocoDadID();
            int otherID = otherChocobo.getChocoID();
            int othermom = otherChocobo.getChocoMomID();
            int otherdad = otherChocobo.getChocoDadID();
            if (!GeneralConfig.allowInbreeding) {
                if (thisID != -1 && othermom != -1 && thisID == othermom || thisID != -1 && otherdad != -1 && thisID == otherdad) {
                    return false;
                }
                if (thismom != -1 && thismom == otherID || thisdad != -1 && thisdad == otherID) {
                    return false;
                }
                if (thismom != -1 && othermom != -1 && thismom == othermom || thisdad != -1 && otherdad != -1 && thisdad == otherdad) {
                    return false;
                }
            }
            return this.isMale() != otherChocobo.isMale() && this.func_70880_s() && otherChocobo.func_70880_s();
        }
        return false;
    }

    public abstract EntityAnimalChocobo.ChocoboColor getBabyAnimalColor(EntityAgeable var1);

    @Override
    public void setStepHeight(boolean mounted) {
        this.field_70138_W = mounted && this.canHighStep ? 2.0f : 1.0f;
    }

    public EntityAgeable func_90011_a(EntityAgeable otherAnimalParent) {
        EntityAnimalChocobo.ChocoboColor chicoboColor = this.getBabyAnimalColor(otherAnimalParent);
        EntityChicobo childChicobo = new EntityChicobo(this.field_70170_p);
        childChicobo.setColor(chicoboColor);
        return childChicobo;
    }
}

