/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChocobo;
import chococraftplus.common.entities.FactoryEntityChocobo;
import chococraftplus.common.network.PacketRegistry;
import chococraftplus.common.network.clientSide.ChicoboCanGrowUp;
import chococraftplus.common.registry.ChocoCraftItems;
import chococraftplus.common.utils.LogHelper;
import chococraftplus.common.utils.Reference;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityChicobo
extends EntityAnimalChocobo {
    public boolean growUp;
    public static final DataParameter<Byte> DM_FLAGS = EntityDataManager.func_187226_a(EntityChicobo.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final DataParameter<Integer> DM_TIMEUNTILADULT = EntityDataManager.func_187226_a(EntityChicobo.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DM_COLOUR = EntityDataManager.func_187226_a(EntityChicobo.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final int DW_VAL_CHIC_CANGROWUP_ON = 1;
    public static final int DW_VAL_CHIC_CANGROWUP_OFF = -2;
    private String texturePrefix;
    private final String[] chicoboTexturesArray = new String[2];

    public EntityChicobo(World world) {
        super(world);
        this.field_70180_af.func_187214_a(DM_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(DM_TIMEUNTILADULT, (Object)(this.field_70146_Z.nextInt(GeneralConfig.growUpDelayRandom + 1) + GeneralConfig.growUpDelayStatic));
        this.field_70180_af.func_187214_a(DM_COLOUR, (Object)this.color.ordinal());
        this.setColor(EntityAnimalChocobo.ChocoboColor.YELLOW);
        this.func_70105_a(0.5f, 0.8f);
        this.growUp = false;
        this.canWaterTread = false;
        this.canFly = false;
        this.canHighStep = false;
        this.field_70138_W = 0.5f;
        this.canHighJumpPresently = false;
        this.func_70873_a(this.getTimeUntilAdult());
    }

    private void resetTexturePrefix() {
        this.texturePrefix = null;
    }

    @SideOnly(value=Side.CLIENT)
    private void setChicoboTexturePaths() {
        String cc;
        String cn;
        switch (this.getColour()) {
            default: {
                cn = "yellow";
                cc = "ye";
                break;
            }
            case BLUE: {
                cn = "blue";
                cc = "bu";
                break;
            }
            case GREEN: {
                cn = "green";
                cc = "gn";
                break;
            }
            case RED: {
                cn = "red";
                cc = "re";
                break;
            }
            case WHITE: {
                cn = "white";
                cc = "wh";
                break;
            }
            case BLACK: {
                cn = "black";
                cc = "bk";
                break;
            }
            case PINK: {
                cn = "pink";
                cc = "pi";
                break;
            }
            case ROYAL: {
                cn = "royal";
                cc = "ro";
                break;
            }
            case GOLD: {
                cn = "gold";
                cc = "go";
            }
        }
        this.chicoboTexturesArray[0] = "chococraftplus:textures/entity/chicobo/colors/chicobo_" + cn + ".png";
        this.chicoboTexturesArray[1] = this.func_70909_n() ? "chococraftplus:textures/entity/chicobo/pieces/ribbon.png" : null;
        this.texturePrefix = "chicobo/" + "ci" + cc + "_" + (this.func_70909_n() ? "t" : "w");
    }

    @SideOnly(value=Side.CLIENT)
    public String getChicoboTexturePrefix() {
        this.setChicoboTexturePaths();
        return this.texturePrefix;
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getLayeredTexturePaths() {
        this.setChicoboTexturePaths();
        return this.chicoboTexturesArray;
    }

    public float func_70047_e() {
        return this.field_70131_O * 1.2f;
    }

    public void setColor(EntityAnimalChocobo.ChocoboColor color) {
        this.color = color;
        this.field_70180_af.func_187227_b(DM_COLOUR, (Object)color.ordinal());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getColorMaxHealth());
        this.func_70606_j(this.getColorMaxHealth());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeInt(this.color.ordinal());
        data.writeBoolean(this.growUp);
        data.writeBoolean(this.isCanGrowUp());
        data.writeInt(this.getTimeUntilAdult());
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        try {
            this.setColor(EntityAnimalChocobo.ChocoboColor.values()[data.readInt()]);
            this.growUp = data.readBoolean();
            this.setCanGrowUp(data.readBoolean());
            this.setTimeUntilAdult(data.readInt());
        }
        catch (Exception e) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("TimeToAdult", this.getTimeUntilAdult());
        nbttagcompound.func_74778_a("Color", this.color.toString());
        nbttagcompound.func_74757_a("CanGrow", this.isCanGrowUp());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setTimeUntilAdult(nbttagcompound.func_74762_e("TimeToAdult"));
        this.setColor(EntityAnimalChocobo.ChocoboColor.valueOf(nbttagcompound.func_74779_i("Color")));
        this.setCanGrowUp(nbttagcompound.func_74767_n("CanGrow"));
        this.setWander(this.isFollowing() == false);
    }

    public float getColorMaxHealth() {
        return 80.0f;
    }

    public boolean isCanGrowUp() {
        return ((Byte)this.field_70180_af.func_187225_a(DM_FLAGS) & 4) != 0;
    }

    public void setCanGrowUp(boolean canGrowUp) {
        byte watchedFlags = (Byte)this.field_70180_af.func_187225_a(DM_FLAGS);
        if (canGrowUp) {
            this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(watchedFlags | 4)));
        } else {
            this.field_70180_af.func_187227_b(DM_FLAGS, (Object)((byte)(watchedFlags & 0xFFFFFFFB)));
        }
    }

    public void setTimeUntilAdult(int timeUntilAdult) {
        this.field_70180_af.func_187227_b(DM_TIMEUNTILADULT, (Object)timeUntilAdult);
    }

    public int getTimeUntilAdult() {
        return (Integer)this.field_70180_af.func_187225_a(DM_TIMEUNTILADULT);
    }

    public EntityAnimalChocobo.ChocoboColor getColour() {
        int ordinal = (Integer)this.field_70180_af.func_187225_a(DM_COLOUR);
        return EntityAnimalChocobo.ChocoboColor.values()[ordinal];
    }

    @Override
    public boolean func_70631_g_() {
        return true;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.growUp && this.func_110143_aJ() > 0.0f) {
            this.setTimeUntilAdult(this.func_70874_b());
            this.setTimeUntilAdult(this.getTimeUntilAdult() - 1);
            this.func_70873_a(this.getTimeUntilAdult());
            if (this.getTimeUntilAdult() <= 0) {
                this.growUp = true;
                this.setCanGrowUp(true);
            }
        }
        this.doGrowUp();
    }

    protected void doGrowUp() {
        if (this.isServer() && this.growUp && this.isCanGrowUp()) {
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            EntityChocobo grownUpChocobo = FactoryEntityChocobo.createChocoboFromChocobo(this.field_70170_p, this);
            grownUpChocobo.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            grownUpChocobo.func_70873_a(this.isMale() ? GeneralConfig.breedingDelayMale : GeneralConfig.breedingDelayFemale);
            grownUpChocobo.setName(this.func_70005_c_());
            grownUpChocobo.setStamina(this.getStamina());
            grownUpChocobo.staminaSprintCounter = this.staminaSprintCounter;
            grownUpChocobo.setDashMax(this.getDashMax());
            grownUpChocobo.setDash(this.getDash());
            grownUpChocobo.setRunMax(this.getRunMax());
            grownUpChocobo.setRun(this.getRun());
            grownUpChocobo.setAcceleration(this.getAcceleration());
            grownUpChocobo.setIntelligence(this.getIntelligence());
            grownUpChocobo.setCooperation(this.getCooperation());
            grownUpChocobo.setRating(this.getRating());
            grownUpChocobo.setPersonality(this.getPersonality());
            grownUpChocobo.setChocoID(this.getChocoID());
            grownUpChocobo.setChocoMomID(this.getChocoMomID());
            grownUpChocobo.setChocoDadID(this.getChocoDadID());
            this.field_70170_p.func_72838_d((Entity)grownUpChocobo);
            this.sendParticleUpdate(0, grownUpChocobo, 7);
            this.func_70606_j(0.0f);
            this.func_70106_y();
            this.growUp = false;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(100) < GeneralConfig.chicoSoundFrequency) {
            return Reference.SE_CHICO_IDLE;
        }
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return Reference.SE_CHICO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return Reference.SE_CHICO_DEATH;
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityplayer, EnumHand hand) {
        if (!entityplayer.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && GeneralConfig.debugMessages) {
            LogHelper.info("Sex: " + (this.isMale() ? "Male" : "Female"));
            LogHelper.info("Health: " + this.func_110143_aJ() + "/" + this.func_110138_aP());
            LogHelper.info("Stamina: " + this.getStamina());
            LogHelper.info("Stamina ticker: " + this.staminaSprintCounter);
            LogHelper.info("Dash: " + this.getDash() + "/" + this.getDashMax());
            LogHelper.info("Run: " + this.getRun() + "/" + this.getRunMax());
            LogHelper.info("Acceleration: " + this.getAcceleration());
            LogHelper.info("Intelligence: " + this.getIntelligence());
            LogHelper.info("Cooperation: " + this.getCooperation());
            LogHelper.info("Rating: " + this.getRating());
            LogHelper.info("Personality: " + this.getPersonality());
            LogHelper.info("Time until hungry: " + this.getTimeUntilHunger());
            LogHelper.info("Time until will grow up: " + this.getChocoAge());
            LogHelper.info("IDs - this: " + this.getChocoID() + "  mom: " + this.getChocoMomID() + "  dad: " + this.getChocoDadID());
        }
        boolean interacted = super.func_184645_a(entityplayer, hand);
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (!interacted && itemstack != null && itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_YELLOW) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_BLUE) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_GREEN) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_RED) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_WHITE) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_BLACK) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_PINK) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_ROYAL) | itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOBO_FEATHER_GOLD)) {
            this.onFeatherUse(entityplayer);
            interacted = true;
        }
        return interacted;
    }

    public void onFeatherUse(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || this.func_70909_n() && this.isOwner(player)) {
            this.toggleFollowWanderStay(player, false);
        } else {
            this.showAmountHeartsOrSmokeFx(false, 7);
        }
    }

    @Override
    protected void func_70619_bc() {
        if (!this.func_70781_l() && this.isFollowing().booleanValue() && this.func_70909_n()) {
            EntityPlayer owner = this.getOwner();
            if (owner != null) {
                if (owner.field_70128_L) {
                    this.setFollowing(false);
                    int personality = this.getPersonality();
                    this.setWander(personality / 2 < 41 && personality % 2 == 0);
                    return;
                }
                float distanceToOwner = owner.func_70032_d((Entity)this);
                if (distanceToOwner > 10.0f) {
                    this.getPathOrWalkableBlock((Entity)owner, distanceToOwner);
                } else {
                    super.func_70619_bc();
                    if (this.func_70090_H()) {
                        this.field_70181_x = 0.1;
                        this.func_70637_d(true);
                    }
                }
            }
        } else {
            super.func_70619_bc();
            if (this.func_70090_H()) {
                this.field_70181_x = 0.1;
                this.func_70637_d(true);
            }
        }
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public boolean canRenderName() {
        return super.canRenderName() && !this.func_70005_c_().equals("");
    }

    public EntityAgeable func_90011_a(EntityAgeable var1) {
        return null;
    }

    public boolean func_70878_b(EntityAnimal entityAnimal) {
        return false;
    }

    protected void sendCanGrowUpUpdate() {
        if (this.isClient()) {
            ChicoboCanGrowUp packet = new ChicoboCanGrowUp(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }
}

