/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.entities;

import chococraftplus.common.advancements.Advancements;
import chococraftplus.common.advancements.CustomTrigger;
import chococraftplus.common.advancements.ModTriggers;
import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityChicobo;
import chococraftplus.common.entities.ai.ChocoboAIFollowOwner;
import chococraftplus.common.entities.ai.ChocoboAILookIdle;
import chococraftplus.common.entities.ai.ChocoboAISwimming;
import chococraftplus.common.entities.ai.ChocoboAIWander;
import chococraftplus.common.entities.ai.ChocoboAIWatchClosest;
import chococraftplus.common.entities.colours.EntityChocoboBlack;
import chococraftplus.common.entities.colours.EntityChocoboBlue;
import chococraftplus.common.entities.colours.EntityChocoboGold;
import chococraftplus.common.entities.colours.EntityChocoboGreen;
import chococraftplus.common.entities.colours.EntityChocoboPink;
import chococraftplus.common.entities.colours.EntityChocoboRed;
import chococraftplus.common.entities.colours.EntityChocoboRoyal;
import chococraftplus.common.entities.colours.EntityChocoboWhite;
import chococraftplus.common.entities.colours.EntityChocoboYellow;
import chococraftplus.common.gui.GuiStarter;
import chococraftplus.common.helper.ChocoboEntityHelper;
import chococraftplus.common.helper.ChocoboParticleHelper;
import chococraftplus.common.network.PacketRegistry;
import chococraftplus.common.network.clientSide.ChocoboHealth;
import chococraftplus.common.network.clientSide.ChocoboHunger;
import chococraftplus.common.network.clientSide.ChocoboParticles;
import chococraftplus.common.network.clientSide.ChocoboTamed;
import chococraftplus.common.network.serverSide.ChocoboAttribute;
import chococraftplus.common.network.serverSide.ChocoboChangeOwnership;
import chococraftplus.common.registry.ChocoCraftBlocks;
import chococraftplus.common.registry.ChocoCraftItems;
import chococraftplus.common.utils.ChocoFunctions;
import chococraftplus.common.utils.Reference;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityAnimalChocobo
extends EntityTameable
implements IEntityAdditionalSpawnData {
    public ChocoboColor color = ChocoboColor.YELLOW;
    protected boolean hasMate;
    public int breeding = 0;
    protected Path pathToEntity;
    public Entity entityToAttack;
    protected boolean hasAttacked = false;
    protected int fleeingTick = 0;
    protected int taskNumber = 0;
    public float flyingMovementFactor;
    public boolean canHighStep;
    public boolean canWaterTread;
    public boolean canSoftFall;
    public boolean canHighJump;
    public boolean canHighJumpPresently;
    public boolean canFly;
    public int staminaSprintCounter;
    public int fedNutType;
    private static final String KEY_NAME = "Name";
    private static final String KEY_AGE = "Age";
    private static final String KEY_ISMALE = "isMale";
    private static final String KEY_FOLLOW = "Follow";
    private static final String KEY_WANDER = "wander";
    private static final String KEY_HIDENAME = "hidename";
    private static final String KEY_TAMED = "tamed";
    private static final String KEY_TIMEUNTILHUNGER = "timeUntilHunger";
    private static final String KEY_STAMINA = "Stamina";
    private static final String KEY_DASHMAX = "DashMax";
    private static final String KEY_DASH = "Dash";
    private static final String KEY_RUNMAX = "RunMax";
    private static final String KEY_RUN = "Run";
    private static final String KEY_ACCELERATION = "Acceleration";
    private static final String KEY_INTELLIGENCE = "Intelligence";
    private static final String KEY_COOPERATION = "Cooperation";
    private static final String KEY_PERSONALITY = "Personality";
    private static final String KEY_CHOCOID = "ChocoID";
    private static final String KEY_CHOCOMOMID = "ChocoMomID";
    private static final String KEY_CHOCODADID = "ChocoDadID";
    private static final DataParameter<Integer> DP_STAMINA = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_DASHMAX = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_DASH = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_RUNMAX = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_RUN = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_ACCELERATION = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_INTELLIGENCE = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_COOPERATION = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_RATING = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_PERSONALITY = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> DP_CHOCONAME = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> DP_FLAGS = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> DP_TIME_UNTIL_HUNGRY = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DP_CHOCO_AGE = EntityDataManager.func_187226_a(EntityAnimalChocobo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int DW_VAL_EAC_ISMALE_ON = 1;
    private static final int DW_VAL_EAC_ISMALE_OFF = -2;
    private static final int DW_VAL_EAC_INLOVE_ON = 2;
    private static final int DW_VAL_EAC_INLOVE_OFF = -3;
    private static final int DW_VAL_EAC_HIDENAME_ON = 4;
    private static final int DW_VAL_EAC_HIDENAME_OFF = -5;
    private static final int DW_VAL_EAC_WANDER_ON = 8;
    private static final int DW_VAL_EAC_WANDER_OFF = -9;
    private static final int DW_VAL_EAC_FOLLOWING_ON = 16;
    private static final int DW_VAL_EAC_FOLLOWING_OFF = -17;
    protected static final int DEFAULT_ID = -1;
    private int chocoID = -1;
    private int chocoMomID = -1;
    private int chocoDadID = -1;

    public EntityAnimalChocobo(World world) {
        super(world);
        this.setHidename(false);
        this.setWander(true);
        this.func_70903_f(false);
        this.setFollowing(false);
        this.setIsMale(this.getRandomIsMale());
        if (this.func_70661_as() instanceof PathNavigateGround) {
            this.func_184644_a(PathNodeType.WATER, -1.0f);
        }
        this.hasMate = false;
        this.field_70138_W = 1.0f;
        this.staminaSprintCounter = -12345;
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAISwimming(this));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)0.38f));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIWander(this, 0.25f));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIFollowOwner(this, 40.0f));
    }

    protected boolean isClient() {
        return this.field_70170_p.field_72995_K;
    }

    protected boolean isServer() {
        return !this.field_70170_p.field_72995_K;
    }

    public int func_70646_bf() {
        return 60;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DP_CHOCONAME, (Object)"");
        this.field_70180_af.func_187214_a(DP_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(DP_TIME_UNTIL_HUNGRY, (Object)0);
        this.field_70180_af.func_187214_a(DP_CHOCO_AGE, (Object)(this.func_70631_g_() ? -24000 : 24000));
        this.field_70180_af.func_187214_a(DP_STAMINA, (Object)0);
        this.field_70180_af.func_187214_a(DP_DASHMAX, (Object)0);
        this.field_70180_af.func_187214_a(DP_DASH, (Object)0);
        this.field_70180_af.func_187214_a(DP_RUNMAX, (Object)0);
        this.field_70180_af.func_187214_a(DP_RUN, (Object)0);
        this.field_70180_af.func_187214_a(DP_ACCELERATION, (Object)0);
        this.field_70180_af.func_187214_a(DP_INTELLIGENCE, (Object)0);
        this.field_70180_af.func_187214_a(DP_COOPERATION, (Object)0);
        this.field_70180_af.func_187214_a(DP_RATING, (Object)0);
        this.field_70180_af.func_187214_a(DP_PERSONALITY, (Object)0);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74778_a(KEY_NAME, this.func_70005_c_());
        nbttagcompound.func_74768_a(KEY_AGE, this.func_70874_b());
        nbttagcompound.func_74757_a(KEY_ISMALE, this.isMale());
        nbttagcompound.func_74757_a(KEY_FOLLOW, this.isFollowing().booleanValue());
        nbttagcompound.func_74757_a(KEY_WANDER, this.isWander());
        nbttagcompound.func_74757_a(KEY_HIDENAME, this.isHidename());
        nbttagcompound.func_74757_a(KEY_TAMED, this.func_70909_n());
        nbttagcompound.func_74768_a(KEY_TIMEUNTILHUNGER, this.getTimeUntilHunger());
        nbttagcompound.func_74768_a(KEY_STAMINA, this.getStamina());
        nbttagcompound.func_74768_a(KEY_DASHMAX, this.getDashMax());
        nbttagcompound.func_74768_a(KEY_DASH, this.getDash());
        nbttagcompound.func_74768_a(KEY_RUNMAX, this.getRunMax());
        nbttagcompound.func_74768_a(KEY_RUN, this.getRun());
        nbttagcompound.func_74768_a(KEY_ACCELERATION, this.getAcceleration());
        nbttagcompound.func_74768_a(KEY_INTELLIGENCE, this.getIntelligence());
        nbttagcompound.func_74768_a(KEY_COOPERATION, this.getCooperation());
        nbttagcompound.func_74768_a(KEY_PERSONALITY, this.getPersonality());
        nbttagcompound.func_74768_a(KEY_CHOCOID, this.getChocoID());
        nbttagcompound.func_74768_a(KEY_CHOCODADID, this.getChocoDadID());
        nbttagcompound.func_74768_a(KEY_CHOCOMOMID, this.getChocoMomID());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setName(nbttagcompound.func_74779_i(KEY_NAME));
        this.func_70873_a(nbttagcompound.func_74762_e(KEY_AGE));
        this.setHidename(nbttagcompound.func_74767_n(KEY_HIDENAME));
        this.setFollowing(nbttagcompound.func_74767_n(KEY_FOLLOW));
        this.setWander(nbttagcompound.func_74767_n(KEY_WANDER));
        this.setIsMale(nbttagcompound.func_74767_n(KEY_ISMALE));
        this.func_70903_f(nbttagcompound.func_74767_n(KEY_TAMED));
        this.setTimeUntilHunger(nbttagcompound.func_74762_e(KEY_TIMEUNTILHUNGER));
        this.setStamina(nbttagcompound.func_74762_e(KEY_STAMINA));
        this.setDashMax(nbttagcompound.func_74762_e(KEY_DASHMAX));
        this.setDash(nbttagcompound.func_74762_e(KEY_DASH));
        this.setRunMax(nbttagcompound.func_74762_e(KEY_RUNMAX));
        this.setRun(nbttagcompound.func_74762_e(KEY_RUN));
        this.setAcceleration(nbttagcompound.func_74762_e(KEY_ACCELERATION));
        this.setIntelligence(nbttagcompound.func_74762_e(KEY_INTELLIGENCE));
        this.setCooperation(nbttagcompound.func_74762_e(KEY_COOPERATION));
        this.setPersonality(nbttagcompound.func_74762_e(KEY_PERSONALITY));
        this.setChocoID(nbttagcompound.func_74762_e(KEY_CHOCOID));
        this.setChocoDadID(nbttagcompound.func_74762_e(KEY_CHOCODADID));
        this.setChocoMomID(nbttagcompound.func_74762_e(KEY_CHOCOMOMID));
    }

    public void writeSpawnData(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.func_70005_c_());
        buf.writeBoolean(this.isMale());
        buf.writeBoolean(this.isHidename());
        buf.writeBoolean(this.isWander());
        buf.writeBoolean(this.isFollowing().booleanValue());
    }

    public void readSpawnData(ByteBuf buf) {
        this.setName(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.setIsMale(buf.readBoolean());
        this.setHidename(buf.readBoolean());
        this.setWander(buf.readBoolean());
        this.setFollowing(buf.readBoolean());
    }

    public void setStamina(int v) {
        this.field_70180_af.func_187227_b(DP_STAMINA, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getStamina() {
        return (Integer)this.field_70180_af.func_187225_a(DP_STAMINA);
    }

    public void setDashMax(int v) {
        this.field_70180_af.func_187227_b(DP_DASHMAX, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getDashMax() {
        return (Integer)this.field_70180_af.func_187225_a(DP_DASHMAX);
    }

    public void setDash(int v) {
        this.field_70180_af.func_187227_b(DP_DASH, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getDash() {
        return (Integer)this.field_70180_af.func_187225_a(DP_DASH);
    }

    public void setRunMax(int v) {
        this.field_70180_af.func_187227_b(DP_RUNMAX, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getRunMax() {
        return (Integer)this.field_70180_af.func_187225_a(DP_RUNMAX);
    }

    public void setRun(int v) {
        this.field_70180_af.func_187227_b(DP_RUN, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getRun() {
        return (Integer)this.field_70180_af.func_187225_a(DP_RUN);
    }

    public void setAcceleration(int v) {
        this.field_70180_af.func_187227_b(DP_ACCELERATION, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getAcceleration() {
        return (Integer)this.field_70180_af.func_187225_a(DP_ACCELERATION);
    }

    public void setIntelligence(int v) {
        this.field_70180_af.func_187227_b(DP_INTELLIGENCE, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getIntelligence() {
        return (Integer)this.field_70180_af.func_187225_a(DP_INTELLIGENCE);
    }

    public void setCooperation(int v) {
        this.field_70180_af.func_187227_b(DP_COOPERATION, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getCooperation() {
        return (Integer)this.field_70180_af.func_187225_a(DP_COOPERATION);
    }

    public void setRating(int v) {
        this.field_70180_af.func_187227_b(DP_RATING, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getRating() {
        return (Integer)this.field_70180_af.func_187225_a(DP_RATING);
    }

    public void setPersonality(int v) {
        this.field_70180_af.func_187227_b(DP_PERSONALITY, (Object)v);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public int getPersonality() {
        return (Integer)this.field_70180_af.func_187225_a(DP_PERSONALITY);
    }

    public void setChocoID(int v) {
        this.chocoID = v;
    }

    public int getChocoID() {
        return this.chocoID;
    }

    public void setChocoDadID(int v) {
        this.chocoDadID = v;
    }

    public int getChocoDadID() {
        return this.chocoDadID;
    }

    public void setChocoMomID(int v) {
        this.chocoMomID = v;
    }

    public int getChocoMomID() {
        return this.chocoMomID;
    }

    public void setName(String name) {
        this.field_70180_af.func_187227_b(DP_CHOCONAME, (Object)name);
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public String func_70005_c_() {
        String name = (String)this.field_70180_af.func_187225_a(DP_CHOCONAME);
        return name;
    }

    public int getTimeUntilHunger() {
        return (Integer)this.field_70180_af.func_187225_a(DP_TIME_UNTIL_HUNGRY);
    }

    public void setTimeUntilHunger(int timeUntilHunger) {
        if (timeUntilHunger > 0) {
            this.field_70180_af.func_187227_b(DP_TIME_UNTIL_HUNGRY, (Object)timeUntilHunger);
        } else {
            this.field_70180_af.func_187227_b(DP_TIME_UNTIL_HUNGRY, (Object)0);
        }
    }

    public boolean isHungry() {
        boolean hungry = this.getTimeUntilHunger() <= (this.func_70631_g_() ? GeneralConfig.appetiteChicobo : GeneralConfig.appetiteChocobo);
        return hungry;
    }

    public void feeding(int foodWeight) {
        int timeUntilHunger = foodWeight * GeneralConfig.foodBaseCooldown;
        this.setTimeUntilHunger(this.getTimeUntilHunger() + timeUntilHunger);
    }

    public int getChocoAge() {
        return (Integer)this.field_70180_af.func_187225_a(DP_CHOCO_AGE);
    }

    public void setChocoAge(int chocoAge) {
        this.field_70180_af.func_187227_b(DP_CHOCO_AGE, (Object)chocoAge);
    }

    public void func_70873_a(int growingAge) {
        super.func_70873_a(growingAge);
    }

    public boolean func_70880_s() {
        return ((Byte)this.field_70180_af.func_187225_a(DP_FLAGS) & 2) != 0;
    }

    public void setInLove(boolean inLove) {
        byte eacFlags = (Byte)this.field_70180_af.func_187225_a(DP_FLAGS);
        if (inLove) {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags | 2)));
        } else {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags & 0xFFFFFFFD)));
        }
        this.sendSetInLoveUpdate();
    }

    public boolean isMale() {
        return ((Byte)this.field_70180_af.func_187225_a(DP_FLAGS) & 1) != 0;
    }

    public void setIsMale(boolean isMale) {
        byte eacFlags = (Byte)this.field_70180_af.func_187225_a(DP_FLAGS);
        if (isMale) {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags | 1)));
        } else {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags & 0xFFFFFFFE)));
        }
    }

    public boolean getRandomIsMale() {
        return new Random().nextInt(100) < 50;
    }

    public boolean isHidename() {
        return ((Byte)this.field_70180_af.func_187225_a(DP_FLAGS) & 4) != 0;
    }

    public void setHidename(boolean hidename) {
        byte eacFlags = (Byte)this.field_70180_af.func_187225_a(DP_FLAGS);
        if (hidename) {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags | 4)));
        } else {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags & 0xFFFFFFFB)));
        }
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public boolean isWander() {
        return ((Byte)this.field_70180_af.func_187225_a(DP_FLAGS) & 8) != 0;
    }

    public void setWander(boolean wander) {
        byte eacFlags = (Byte)this.field_70180_af.func_187225_a(DP_FLAGS);
        if (wander) {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags | 8)));
        } else {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags & 0xFFFFFFF7)));
        }
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public Boolean isFollowing() {
        return ((Byte)this.field_70180_af.func_187225_a(DP_FLAGS) & 0x10) != 0;
    }

    public void setFollowing(Boolean following) {
        byte eacFlags = (Byte)this.field_70180_af.func_187225_a(DP_FLAGS);
        if (following.booleanValue()) {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DP_FLAGS, (Object)((byte)(eacFlags & 0xFFFFFFEF)));
        }
        if (this.isClient()) {
            this.sendAttributeUpdate();
        }
    }

    public String getGender() {
        return this.isMale() ? "Male" : "Female";
    }

    protected boolean isMovementCeased() {
        return false;
    }

    public void toggleFollowWanderStay(EntityPlayer player, boolean fromChocopedia) {
        String choconame;
        if (!fromChocopedia && this.field_70170_p.field_72995_K) {
            return;
        }
        int personality = this.getPersonality();
        String string = this.func_70005_c_() == null || this.func_70005_c_().equals("") ? (this instanceof EntityChicobo ? "Chicobo" : "Chocobo") : (choconame = this.func_70005_c_());
        if (this.isFollowing().booleanValue() && !this.isWander()) {
            this.setFollowing(false);
            boolean discriminant = personality / 2 < 41 && personality % 2 == 0;
            this.setWander(discriminant);
            if (fromChocopedia) {
                this.showParticles(discriminant ? 14 : 9, 7);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(choconame + " set to " + (discriminant ? "Wander" : "Stay")));
                this.sendParticleUpdate(discriminant ? 14 : 9, this, 7);
            }
        } else if (!this.isFollowing().booleanValue() && !this.isWander()) {
            boolean discriminant;
            boolean bl = discriminant = personality / 2 < 41 && personality % 2 == 1;
            if (discriminant) {
                this.setFollowing(true);
            } else {
                this.setWander(true);
            }
            if (fromChocopedia) {
                this.showParticles(discriminant ? 34 : 14, 7);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(choconame + " set to " + (discriminant ? KEY_FOLLOW : "Wander")));
                this.sendParticleUpdate(discriminant ? 34 : 14, this, 7);
            }
        } else {
            boolean discriminant = personality / 2 < 41 && personality % 2 == 0;
            this.setWander(discriminant);
            this.setFollowing(!discriminant);
            if (fromChocopedia) {
                this.showParticles(discriminant ? 14 : 34, 7);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(choconame + " set to " + (discriminant ? "Wander" : KEY_FOLLOW)));
                this.sendParticleUpdate(discriminant ? 14 : 34, this, 7);
            }
        }
    }

    public EntityPlayer getOwner() {
        EntityPlayer owner = null;
        try {
            UUID ownerUUID = this.func_184753_b();
            if (ownerUUID != null) {
                owner = this.field_70170_p.func_152378_a(this.func_184753_b());
            }
        }
        catch (IllegalArgumentException ownerUUID) {
            // empty catch block
        }
        if (null == owner && this.field_70170_p.field_73010_i.size() == 1) {
            Object playerObj;
            if (this.func_184753_b() != null && this.field_70170_p.func_152378_a(this.func_184753_b()) != null && this.field_70170_p.func_152378_a(this.func_184753_b()).func_70005_c_().equals("Player")) {
                playerObj = this.field_70170_p.field_73010_i.get(0);
                if (playerObj instanceof EntityPlayer) {
                    EntityPlayer updatedOwner = (EntityPlayer)playerObj;
                    this.func_184754_b(updatedOwner.func_110124_au());
                    owner = updatedOwner;
                }
            } else {
                EntityPlayer offlinePlayer;
                playerObj = this.field_70170_p.field_73010_i.get(0);
                if (playerObj instanceof EntityPlayer && (offlinePlayer = (EntityPlayer)playerObj).func_145748_c_().equals("Player")) {
                    owner = offlinePlayer;
                }
            }
        }
        return owner;
    }

    public boolean isOwner(EntityPlayer player) {
        return player.equals((Object)this.getOwner());
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (GeneralConfig.useChocoCraftNameRendering && this.func_145818_k_() && !this.func_95999_t().equals("") || this.isHidename() || !GeneralConfig.showChocoboNames) {
            this.func_96094_a("");
        } else if (!(GeneralConfig.useChocoCraftNameRendering || this.func_70005_c_().equals("") || this.func_145818_k_() && !this.func_95999_t().isEmpty() || this.isHidename())) {
            this.func_96094_a(this.func_70005_c_());
        }
        this.setTimeUntilHunger(this.getTimeUntilHunger() - 1);
        if (!this.field_70170_p.field_72995_K) {
            this.setChocoAge(this.func_70874_b());
        }
        this.doStrawHealing();
        int chocoID = this.getChocoID();
        if (chocoID < 0 && !this.field_70170_p.field_72995_K) {
            this.setRandomStats();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.max((this.getStamina() + 1) / 125, 1));
            if (this.func_110143_aJ() > this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP());
            }
            if (this.field_70173_aa % 10 == 0) {
                this.sendAttributeUpdate();
            }
            if (this.staminaSprintCounter == -12345) {
                this.staminaSprintCounter = this.field_70146_Z.nextInt(15);
            }
        }
    }

    private void doStrawHealing() {
        int range;
        BlockPos posBelow;
        Block blockBelow;
        int d100;
        if (this.isServer() && this.func_70909_n() && this.func_110143_aJ() < this.func_110138_aP() && this.field_70170_p.func_72820_D() % 40L == 0L && (d100 = this.field_70146_Z.nextInt(100)) < GeneralConfig.penHealProbability && (blockBelow = this.field_70170_p.func_180495_p(posBelow = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c()).equals(ChocoCraftBlocks.STRAW_BEDDING) && this.isFilledCauldronNear(this.field_70165_t, this.field_70163_u, this.field_70161_v, range = GeneralConfig.penHealCauldronRange, 2, range)) {
            this.func_70691_i(this.field_70146_Z.nextInt(3) + 1);
            this.sendHealthUpdate();
            this.sendParticleUpdate(34, this, 1);
        }
    }

    private boolean isFilledCauldronNear(double posX, double posY, double posZ, int rangeX, int rangeY, int rangeZ) {
        int y;
        int iPosX = (int)posX;
        int iPosY = (int)posY;
        int iPosZ = (int)posZ;
        if (this.isFilledCauldronNearAtYLevel(iPosX, iPosY + 1, iPosZ, rangeX, rangeZ)) {
            return true;
        }
        for (y = iPosY + 2; y <= iPosY + rangeY; ++y) {
            if (!this.isFilledCauldronNearAtYLevel(iPosX, y, iPosZ, rangeX, rangeZ)) continue;
            return true;
        }
        for (y = iPosY; y >= iPosY - rangeY; --y) {
            if (!this.isFilledCauldronNearAtYLevel(iPosX, y, iPosZ, rangeX, rangeZ)) continue;
            return true;
        }
        return false;
    }

    private boolean isFilledCauldronNearAtYLevel(int posX, int posY, int posZ, int rangeX, int rangeZ) {
        for (int x = posX - rangeX; x <= posX + rangeX; ++x) {
            for (int z = posZ - rangeZ; z <= posZ + rangeZ; ++z) {
                int fillStatus;
                IBlockState blockstate = this.field_70170_p.func_180495_p(new BlockPos(x, posY, z));
                if (!blockstate.func_177230_c().equals(Blocks.field_150383_bp) || (fillStatus = blockstate.func_177230_c().func_176201_c(blockstate)) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer entityplayer, EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        int foodWeight = 0;
        if (itemstack != null) {
            if (itemstack.func_77973_b().equals(Items.field_151057_cb) && itemstack.func_82837_s()) {
                if (GeneralConfig.useChocoCraftNameRendering) {
                    this.func_184185_a(this.func_184601_bQ(DamageSource.field_76377_j), this.func_70599_aP(), this.func_70647_i());
                    if (this.field_70170_p.field_72995_K) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString("Can't name a chocobo this way!"));
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString("Set \"Use Chococraft Name Rendering\" to \u00a7lfalse"));
                    }
                } else {
                    this.setName(itemstack.func_82833_r());
                }
                return true;
            }
            if (itemstack.func_77973_b().equals(Items.field_151099_bA)) {
                this.onWritableBookUse(entityplayer);
                return true;
            }
            if (itemstack != null && itemstack.func_77973_b().equals(ChocoCraftItems.CHOCOPEDIA)) {
                this.onChocopediaUse(hand);
                return true;
            }
            if (itemstack.func_77973_b().equals(ChocoCraftItems.GYSAHL_CARROT)) {
                foodWeight = 1;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.KRAKKA_ROOT)) {
                foodWeight = 2;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.TANTAL_VEGGIE)) {
                foodWeight = 3;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.PASANA_FRUIT)) {
                foodWeight = 4;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.CREE_ROOT)) {
                foodWeight = 5;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.MIMETT_FRUIT)) {
                foodWeight = 6;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.REAGAN_VEGGIE)) {
                foodWeight = 7;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.SYLKIS_BUD)) {
                foodWeight = 8;
            }
            if (foodWeight > 0) {
                this.onFeedVeggie(entityplayer, foodWeight, itemstack.func_190916_E(), entityplayer.func_70093_af());
                return true;
            }
        }
        return false;
    }

    protected boolean onEmptyHandInteraction(EntityPlayer entityplayer) {
        return false;
    }

    protected void onChocopediaUse(EnumHand hand) {
        if (this.isClient()) {
            if (this.func_70909_n()) {
                GuiStarter.startChocopediaGui(this, hand);
            } else {
                this.showAmountHeartsOrSmokeFx(false, 7);
            }
        }
    }

    protected void onWritableBookUse(EntityPlayer player) {
        int selectedSlot = player.field_71071_by.field_70461_c;
        this.func_184185_a(Reference.SE_FEED_CONFIRM, 0.5f, 1.0f);
        player.field_71071_by.field_70462_a.set(selectedSlot, (Object)new ItemStack(ChocoCraftItems.CHOCOPEDIA, 1));
    }

    protected void onFeedVeggie(EntityPlayer entityplayer, int foodWeight, int stackSize, boolean isPlayerSneaking) {
        boolean fed = false;
        if (!this.func_70909_n()) {
            this.useItem(entityplayer, 1);
            if (this.isServer()) {
                int succeedOneIn = 4;
                if (entityplayer.field_71075_bZ.field_75098_d || this.field_70146_Z.nextInt((int)Math.pow(succeedOneIn, foodWeight)) >= (int)Math.pow(succeedOneIn - 1, foodWeight)) {
                    int personality;
                    EntityPlayerMP entityplayermp;
                    this.func_70903_f(true);
                    this.setName("Chocobo");
                    if (entityplayer instanceof EntityPlayerMP && !(entityplayermp = (EntityPlayerMP)entityplayer).func_184102_h().func_184103_al().func_192054_h(entityplayermp).func_192747_a(entityplayermp.func_184102_h().func_191949_aK().func_192778_a(Advancements.RL_CHOCO_YELLOW)).func_192105_a()) {
                        ModTriggers.CHOCO_YELLOW.trigger(entityplayermp);
                    }
                    if ((personality = this.getPersonality()) / 2 >= 41) {
                        this.setWander(false);
                        this.setFollowing(true);
                    } else if (personality % 2 == 1) {
                        this.setWander(false);
                        this.setFollowing(false);
                    } else {
                        this.setWander(true);
                        this.setFollowing(false);
                    }
                    this.setHidename(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    this.func_184754_b(entityplayer.func_110124_au());
                    this.sendTamedUpdate();
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
                this.feeding(foodWeight);
                this.sendHungerUpdate();
            }
            this.showAmountHeartsOrSmokeFx(this.func_70909_n(), 7);
            if (this instanceof EntityChicobo) {
                this.func_184185_a(this.func_70909_n() ? Reference.SE_CHICO_IDLE : Reference.SE_CHICO_SMOKE, 1.0f, 1.0f);
            } else {
                this.func_184185_a(this.func_70909_n() ? Reference.SE_CHOCO_TAME_IDLE : Reference.SE_CHOCO_SMOKE, 1.0f, 1.0f);
            }
        } else {
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            int veggiesHave = itemstack.func_190916_E();
            int numberVeggiesFed = 0;
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                int veggiesNeededToHeal = MathHelper.func_76123_f((float)((this.func_110138_aP() - this.func_110143_aJ()) / (float)(foodWeight * 2)));
                numberVeggiesFed = Math.min(entityplayer.func_70093_af() ? veggiesHave : 1, entityplayer.field_71075_bZ.field_75098_d ? veggiesHave : veggiesNeededToHeal);
                this.useItem(entityplayer, numberVeggiesFed);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70691_i(2 * foodWeight * numberVeggiesFed);
                    this.sendHealthUpdate();
                    this.feeding(foodWeight * numberVeggiesFed);
                    this.sendHungerUpdate();
                }
                this.showAmountHeartsOrSmokeFx(true, 2 * foodWeight);
                if (this instanceof EntityChicobo) {
                    this.func_184185_a(Reference.SE_CHICO_IDLE, 1.0f, 1.0f);
                } else {
                    this.func_184185_a(Reference.SE_CHOCO_TAME_IDLE, 1.0f, 1.0f);
                }
            }
            veggiesHave = itemstack.func_190916_E();
            if (entityplayer.field_71075_bZ.field_75098_d || this.isHungry() && this.func_184753_b().toString().equals(entityplayer.func_110124_au().toString())) {
                int hungerGap = Math.max((this.func_70631_g_() ? GeneralConfig.appetiteChicobo : GeneralConfig.appetiteChocobo) - this.getTimeUntilHunger(), 0);
                int veggiesCanFit = MathHelper.func_76143_f((double)((double)hungerGap / (double)(foodWeight * GeneralConfig.foodBaseCooldown)));
                if (numberVeggiesFed == 0) {
                    numberVeggiesFed = Math.min(entityplayer.func_70093_af() ? veggiesHave : 1, entityplayer.field_71075_bZ.field_75098_d ? veggiesHave : veggiesCanFit);
                    this.useItem(entityplayer, numberVeggiesFed);
                    if (!this.field_70170_p.field_72995_K) {
                        this.feeding(foodWeight * numberVeggiesFed);
                        this.sendHungerUpdate();
                    }
                } else {
                    int n = numberVeggiesFed = entityplayer.field_71075_bZ.field_75098_d ? veggiesHave : Math.min(numberVeggiesFed, veggiesCanFit);
                }
                if (!this.field_70170_p.field_72995_K) {
                    EntityPlayerMP entityplayermp;
                    int inc_dash = 0;
                    int inc_run = 0;
                    int inc_stamina = 0;
                    int inc_cooperation = 0;
                    int inc_intelligence = 0;
                    int inc_personality = 0;
                    int inc_acceleration = 0;
                    String chocoName = this.func_70005_c_();
                    int cur_dash = this.getDash();
                    int cur_run = this.getRun();
                    int cur_stamina = this.getStamina();
                    block10: for (int i = 0; i < numberVeggiesFed; ++i) {
                        switch (foodWeight) {
                            case 1: {
                                inc_dash += this.field_70146_Z.nextInt(4);
                                inc_run += this.field_70146_Z.nextInt(3);
                                inc_stamina += this.field_70146_Z.nextInt(4);
                                ++inc_cooperation;
                                continue block10;
                            }
                            case 2: {
                                inc_intelligence += 1 + this.field_70146_Z.nextInt(2);
                                ++inc_cooperation;
                                continue block10;
                            }
                            case 3: {
                                inc_dash += 1 + this.field_70146_Z.nextInt(4);
                                inc_run += 1 + this.field_70146_Z.nextInt(4);
                                inc_stamina += 1 + this.field_70146_Z.nextInt(2);
                                ++inc_intelligence;
                                ++inc_cooperation;
                                continue block10;
                            }
                            case 4: {
                                inc_intelligence += 1 + this.field_70146_Z.nextInt(8);
                                inc_cooperation += this.field_70146_Z.nextInt(4) == 0 ? 1 : 2;
                                inc_personality += this.field_70146_Z.nextInt(64) == 0 ? 0 : 2;
                                continue block10;
                            }
                            case 5: {
                                inc_dash += this.field_70146_Z.nextInt(4);
                                inc_run += this.field_70146_Z.nextInt(4);
                                inc_stamina += 3 + this.field_70146_Z.nextInt(8);
                                inc_cooperation += 2;
                                continue block10;
                            }
                            case 6: {
                                inc_dash += 1 + this.field_70146_Z.nextInt(16);
                                inc_run += this.field_70146_Z.nextInt(4);
                                inc_stamina += 3 + this.field_70146_Z.nextInt(8);
                                inc_acceleration += this.field_70146_Z.nextInt(4) == 0 ? 1 : 0;
                                inc_cooperation += 2;
                                continue block10;
                            }
                            case 7: {
                                cur_dash += (inc_dash += cur_dash / 20 + (this.field_70146_Z.nextBoolean() ? -1 : 1) * this.field_70146_Z.nextInt(11));
                                cur_run += (inc_run += cur_run / 20 + (this.field_70146_Z.nextBoolean() ? -1 : 1) * this.field_70146_Z.nextInt(11));
                                inc_stamina += cur_stamina / 100 + (this.field_70146_Z.nextBoolean() ? -1 : 1) * this.field_70146_Z.nextInt(11);
                                inc_cooperation += 3;
                                continue block10;
                            }
                            case 8: {
                                cur_dash += (inc_dash += cur_dash / 20 + (this.field_70146_Z.nextBoolean() ? -1 : 1) * this.field_70146_Z.nextInt(11));
                                cur_run += (inc_run += cur_run / 20 + (this.field_70146_Z.nextBoolean() ? -1 : 1) * this.field_70146_Z.nextInt(11));
                                inc_stamina += cur_stamina / 100 + (this.field_70146_Z.nextBoolean() ? -1 : 1) * this.field_70146_Z.nextInt(11);
                                inc_intelligence += 1 + this.field_70146_Z.nextInt(4);
                                inc_cooperation += 4;
                            }
                        }
                    }
                    int max_dash = this.getDashMax();
                    int min_dash = 300;
                    cur_dash = this.getDash();
                    int max_run = this.getRunMax();
                    int min_run = 300;
                    cur_run = this.getRun();
                    int max_stamina = 9999;
                    int min_stamina = 300;
                    cur_stamina = this.getStamina();
                    int max_cooperation = 100;
                    int min_cooperation = 0;
                    int cur_cooperation = this.getCooperation();
                    int max_intelligence = 100;
                    int min_intelligence = 0;
                    int cur_intelligence = this.getIntelligence();
                    int max_personality = 83;
                    int min_personality = 0;
                    int cur_personality = this.getPersonality();
                    int max_acceleration = 100;
                    int min_acceleration = 0;
                    int cur_acceleration = this.getAcceleration();
                    if (cur_dash > max_dash) {
                        cur_dash = max_dash;
                        this.setDash(cur_dash);
                        inc_dash = 0;
                    } else if (cur_dash < min_dash) {
                        cur_dash = min_dash;
                        this.setDash(cur_dash);
                    }
                    if (cur_run > max_run) {
                        cur_run = max_run;
                        this.setRun(cur_run);
                        inc_run = 0;
                    } else if (cur_run < min_run) {
                        cur_run = min_run;
                        this.setRun(cur_run);
                    }
                    if (cur_stamina > max_stamina) {
                        cur_stamina = max_stamina;
                        this.setStamina(cur_stamina);
                        inc_stamina = 0;
                    } else if (cur_stamina < min_stamina) {
                        cur_stamina = min_stamina;
                        this.setStamina(cur_stamina);
                    }
                    if (cur_cooperation > max_cooperation) {
                        cur_cooperation = max_cooperation;
                        this.setCooperation(cur_cooperation);
                        inc_cooperation = 0;
                    } else if (cur_cooperation < min_cooperation) {
                        cur_cooperation = min_cooperation;
                        this.setCooperation(cur_cooperation);
                    }
                    if (cur_intelligence > max_intelligence) {
                        cur_intelligence = max_intelligence;
                        this.setIntelligence(cur_intelligence);
                        inc_intelligence = 0;
                    } else if (cur_intelligence < min_intelligence) {
                        cur_intelligence = min_intelligence;
                        this.setIntelligence(cur_intelligence);
                    }
                    if (cur_personality > max_personality) {
                        cur_personality = max_personality;
                        this.setPersonality(cur_personality);
                        inc_personality = 0;
                    } else if (cur_personality < min_personality) {
                        cur_personality = min_personality;
                        this.setPersonality(cur_personality);
                    }
                    if (cur_acceleration > max_acceleration) {
                        cur_acceleration = max_acceleration;
                        this.setAcceleration(cur_acceleration);
                        inc_acceleration = 0;
                    } else if (cur_acceleration < min_acceleration) {
                        cur_acceleration = min_acceleration;
                        this.setAcceleration(cur_acceleration);
                    }
                    inc_dash = Math.max(Math.min(inc_dash, max_dash - cur_dash), min_dash - cur_dash);
                    inc_run = Math.max(Math.min(inc_run, max_run - cur_run), min_run - cur_run);
                    inc_stamina = Math.max(Math.min(inc_stamina, max_stamina - cur_stamina), min_stamina - cur_stamina);
                    inc_cooperation = Math.max(Math.min(inc_cooperation, max_cooperation - cur_cooperation), min_cooperation - cur_cooperation);
                    inc_intelligence = Math.max(Math.min(inc_intelligence, max_intelligence - cur_intelligence), min_intelligence - cur_intelligence);
                    inc_personality = Math.max(Math.min(inc_personality, max_personality - cur_personality), min_personality - cur_personality);
                    inc_acceleration = Math.max(Math.min(inc_acceleration, max_acceleration - cur_acceleration), min_acceleration - cur_acceleration);
                    boolean improvementFlag = false;
                    if (chocoName.equals(null) || chocoName.equals("")) {
                        String string = chocoName = this.func_70631_g_() ? "Chicobo" : "Chocobo";
                    }
                    if (inc_stamina != 0) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + "'s " + TextFormatting.RED + "[Stamina]" + TextFormatting.RESET + (inc_stamina > 0 ? " increased!" : TextFormatting.DARK_RED + " decreased..." + TextFormatting.RESET)));
                        this.setStamina(this.getStamina() + inc_stamina);
                        improvementFlag = true;
                    }
                    if (inc_run != 0) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + "'s " + TextFormatting.GREEN + "[Running speed]" + TextFormatting.RESET + (inc_run > 0 ? " increased!" : TextFormatting.DARK_RED + " decreased..." + TextFormatting.RESET)));
                        this.setRun(this.getRun() + inc_run);
                        improvementFlag = true;
                    }
                    if (inc_dash != 0) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + "'s " + TextFormatting.YELLOW + "[Sprint speed]" + TextFormatting.RESET + (inc_dash > 0 ? " increased!" : TextFormatting.DARK_RED + " decreased..." + TextFormatting.RESET)));
                        this.setDash(this.getDash() + inc_dash);
                        improvementFlag = true;
                    }
                    if (inc_acceleration > 0) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + "'s " + TextFormatting.GOLD + "[Strafe speed]" + TextFormatting.RESET + " increased!"));
                        this.setAcceleration(this.getAcceleration() + inc_acceleration);
                        improvementFlag = true;
                        if (entityplayer instanceof EntityPlayerMP && !(entityplayermp = (EntityPlayerMP)entityplayer).func_184102_h().func_184103_al().func_192054_h(entityplayermp).func_192747_a(entityplayermp.func_184102_h().func_191949_aK().func_192778_a(Advancements.RL_SIDEWINDER)).func_192105_a()) {
                            ModTriggers.SIDEWINDER.trigger(entityplayermp);
                        }
                    }
                    if (inc_intelligence > 0) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + "'s " + TextFormatting.BLUE + "[Intelligence]" + TextFormatting.RESET + " increased!"));
                        this.setIntelligence(this.getIntelligence() + inc_intelligence);
                        improvementFlag = true;
                    }
                    if (inc_cooperation > 0) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + " is " + TextFormatting.AQUA + "[Co-operating]" + TextFormatting.RESET + " more!"));
                        this.setCooperation(this.getCooperation() + inc_cooperation);
                        improvementFlag = true;
                    }
                    if (cur_personality < 82 && cur_personality + inc_personality >= 82) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + "'s " + TextFormatting.LIGHT_PURPLE + "[Temperament]" + TextFormatting.RESET + " improved!"));
                        if (entityplayer instanceof EntityPlayerMP && !(entityplayermp = (EntityPlayerMP)entityplayer).func_184102_h().func_184103_al().func_192054_h(entityplayermp).func_192747_a(entityplayermp.func_184102_h().func_191949_aK().func_192778_a(Advancements.RL_ATTITUDE_ADJUSTMENT)).func_192105_a()) {
                            ModTriggers.ATTITUDE_ADJUSTMENT.trigger(entityplayermp);
                        }
                        improvementFlag = true;
                    }
                    if (inc_personality != 0) {
                        this.setPersonality(this.getPersonality() + inc_personality);
                    }
                    if (!improvementFlag) {
                        entityplayer.func_145747_a((ITextComponent)new TextComponentString(chocoName + " showed no improvement..."));
                    }
                }
                this.sendParticleUpdate(21, this, 2 * foodWeight);
                this.func_184185_a(Reference.SE_FEED_CONFIRM, 0.5f, 1.0f);
            }
        }
    }

    public void procreate(EntityAnimalChocobo otherParent) {
        EntityChicobo babyChicobo;
        if (this.isServer() && (babyChicobo = (EntityChicobo)this.func_90011_a((EntityAgeable)otherParent)) != null) {
            int dieRoll;
            babyChicobo.setTimeUntilAdult(this.field_70146_Z.nextInt(GeneralConfig.growUpDelayRandom + 1) + GeneralConfig.growUpDelayStatic);
            babyChicobo.func_70873_a(babyChicobo.getTimeUntilAdult());
            babyChicobo.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            EntityAnimalChocobo extendedMom = this.isMale() ? otherParent : this;
            EntityAnimalChocobo extendedDad = this.isMale() ? this : otherParent;
            ChocoboColor dadColor = ChocoboColor.YELLOW;
            ChocoboColor momColor = ChocoboColor.YELLOW;
            if (this instanceof EntityChocoboYellow) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.YELLOW;
                } else {
                    momColor = ChocoboColor.YELLOW;
                }
            }
            if (this instanceof EntityChocoboBlue) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.BLUE;
                } else {
                    momColor = ChocoboColor.BLUE;
                }
            }
            if (this instanceof EntityChocoboGreen) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.GREEN;
                } else {
                    momColor = ChocoboColor.GREEN;
                }
            }
            if (this instanceof EntityChocoboWhite) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.WHITE;
                } else {
                    momColor = ChocoboColor.WHITE;
                }
            }
            if (this instanceof EntityChocoboRed) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.RED;
                } else {
                    momColor = ChocoboColor.RED;
                }
            }
            if (this instanceof EntityChocoboBlack) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.BLACK;
                } else {
                    momColor = ChocoboColor.BLACK;
                }
            }
            if (this instanceof EntityChocoboPink) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.PINK;
                } else {
                    momColor = ChocoboColor.PINK;
                }
            }
            if (this instanceof EntityChocoboRoyal) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.ROYAL;
                } else {
                    momColor = ChocoboColor.ROYAL;
                }
            }
            if (this instanceof EntityChocoboGold) {
                if (this.isMale()) {
                    dadColor = ChocoboColor.GOLD;
                } else {
                    momColor = ChocoboColor.GOLD;
                }
            }
            if (otherParent instanceof EntityChocoboYellow) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.YELLOW;
                } else {
                    momColor = ChocoboColor.YELLOW;
                }
            }
            if (otherParent instanceof EntityChocoboBlue) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.BLUE;
                } else {
                    momColor = ChocoboColor.BLUE;
                }
            }
            if (otherParent instanceof EntityChocoboGreen) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.GREEN;
                } else {
                    momColor = ChocoboColor.GREEN;
                }
            }
            if (otherParent instanceof EntityChocoboWhite) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.WHITE;
                } else {
                    momColor = ChocoboColor.WHITE;
                }
            }
            if (otherParent instanceof EntityChocoboRed) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.RED;
                } else {
                    momColor = ChocoboColor.RED;
                }
            }
            if (otherParent instanceof EntityChocoboBlack) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.BLACK;
                } else {
                    momColor = ChocoboColor.BLACK;
                }
            }
            if (otherParent instanceof EntityChocoboPink) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.PINK;
                } else {
                    momColor = ChocoboColor.PINK;
                }
            }
            if (otherParent instanceof EntityChocoboRoyal) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.ROYAL;
                } else {
                    momColor = ChocoboColor.ROYAL;
                }
            }
            if (otherParent instanceof EntityChocoboGold) {
                if (otherParent.isMale()) {
                    dadColor = ChocoboColor.GOLD;
                } else {
                    momColor = ChocoboColor.GOLD;
                }
            }
            int[] parentNuts = new int[]{this.fedNutType, otherParent.fedNutType};
            int babyDashMax = 300;
            int babyDash = 200;
            int babyRunMax = 200;
            int babyRun = 100;
            int babyStamina = 100;
            int babyAcceleration = (extendedMom.getAcceleration() + extendedDad.getAcceleration()) / 2;
            int babyCooperation = 0;
            int babyIntelligence = (extendedMom.getIntelligence() + extendedDad.getIntelligence()) / 2;
            int babyRating = this.field_70146_Z.nextBoolean() ? extendedMom.getRating() : extendedDad.getRating();
            int babyPersonality = 0;
            switch (babyRating / 2) {
                case 3: {
                    babyPersonality = this.field_70146_Z.nextInt(8) == 0 ? this.field_70146_Z.nextInt(10) : 82;
                    break;
                }
                case 2: {
                    babyPersonality = this.field_70146_Z.nextInt(4) == 0 ? this.field_70146_Z.nextInt(10) : 82;
                    break;
                }
                case 1: {
                    babyPersonality = this.field_70146_Z.nextInt(2) == 0 ? this.field_70146_Z.nextInt(10) : 82;
                    break;
                }
                case 0: {
                    babyPersonality = this.field_70146_Z.nextInt(2) == 0 ? this.field_70146_Z.nextInt(10) : 82;
                }
            }
            ChocoboColor babyColor = this.field_70146_Z.nextBoolean() ? momColor : dadColor;
            switch (parentNuts[this.field_70146_Z.nextInt(2)]) {
                case 1: {
                    babyRun = Math.max((extendedMom.getRun() + extendedDad.getRun()) / 2 - (1 + this.field_70146_Z.nextInt(2)) * 100, 300);
                    break;
                }
                case 2: {
                    babyRun = Math.max((extendedMom.getRun() + extendedDad.getRun()) / 2 - this.field_70146_Z.nextInt(2) * this.field_70146_Z.nextInt(256) * 2, 300);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    babyRun = (extendedMom.getRun() + extendedDad.getRun()) / 2;
                }
            }
            switch (parentNuts[this.field_70146_Z.nextInt(2)]) {
                case 1: {
                    babyRunMax = Math.max((extendedMom.getRunMax() + extendedDad.getRunMax()) / 2 - (1 + this.field_70146_Z.nextInt(4)) * 100, 300);
                    break;
                }
                case 2: {
                    babyRunMax = Math.max((extendedMom.getRunMax() + extendedDad.getRunMax()) / 2 - this.field_70146_Z.nextInt(2) * this.field_70146_Z.nextInt(256) * 2, 300);
                    break;
                }
                case 3: {
                    dieRoll = this.field_70146_Z.nextInt(32);
                    if (dieRoll < 3) {
                        babyRunMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getRunMax() : extendedDad.getRunMax()) * 34 / 33, 6000);
                        break;
                    }
                    if (dieRoll < 6) {
                        babyRunMax = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getRunMax() : extendedDad.getRunMax()) * 32 / 33, 1);
                        break;
                    }
                    babyRunMax = (extendedMom.getRunMax() + extendedDad.getRunMax()) / 2;
                    break;
                }
                case 4: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyRunMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getRunMax() : extendedDad.getRunMax()) * 21 / 20, 6000);
                        break;
                    }
                    if (dieRoll < 75) {
                        babyRunMax = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getRunMax() : extendedDad.getRunMax()) * 19 / 20, 1);
                        break;
                    }
                    babyRunMax = (extendedMom.getRunMax() + extendedDad.getRunMax()) / 2;
                    break;
                }
                case 5: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyRunMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getRunMax() : extendedDad.getRunMax()) * 16 / 15, 6000);
                        break;
                    }
                    if (dieRoll < 75) {
                        babyRunMax = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getRunMax() : extendedDad.getRunMax()) * 19 / 20, 1);
                        break;
                    }
                    babyRunMax = (extendedMom.getRunMax() + extendedDad.getRunMax()) / 2;
                    break;
                }
                case 6: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyRunMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getRunMax() : extendedDad.getRunMax()) * 19 / 18, 6000);
                        break;
                    }
                    babyRunMax = (extendedMom.getRunMax() + extendedDad.getRunMax()) / 2;
                    break;
                }
                case 7: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 30) {
                        babyRunMax = Math.min(Math.max(extendedMom.getRunMax(), extendedDad.getRunMax()) * 11 / 10, 6000);
                        break;
                    }
                    if (dieRoll < 85) {
                        babyRunMax = Math.max(Math.max(extendedMom.getRunMax(), extendedDad.getRunMax()) * 19 / 20, 1);
                        break;
                    }
                    babyRunMax = (extendedMom.getRunMax() + extendedDad.getRunMax()) / 2;
                    break;
                }
                case 8: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    babyRunMax = dieRoll < 80 ? Math.min(Math.max(extendedMom.getRunMax(), extendedDad.getRunMax()) * 9 / 8, 6000) : (dieRoll < 95 ? Math.max(Math.max(extendedMom.getRunMax(), extendedDad.getRunMax()) * 19 / 20, 1) : (extendedMom.getRunMax() + extendedDad.getRunMax()) / 2);
                }
            }
            switch (parentNuts[this.field_70146_Z.nextInt(2)]) {
                case 1: 
                case 2: 
                case 5: {
                    if (this.field_70146_Z.nextBoolean()) break;
                }
                case 3: 
                case 4: 
                case 6: {
                    if (this.field_70146_Z.nextBoolean()) break;
                    if (dadColor == ChocoboColor.BLUE && momColor == ChocoboColor.GREEN || dadColor == ChocoboColor.GREEN && momColor == ChocoboColor.BLUE) {
                        babyColor = ChocoboColor.BLACK;
                        break;
                    }
                    if (dadColor == ChocoboColor.WHITE && momColor == ChocoboColor.RED || dadColor == ChocoboColor.RED && momColor == ChocoboColor.WHITE) {
                        babyColor = ChocoboColor.PINK;
                        break;
                    }
                    if ((dadColor != ChocoboColor.BLACK || momColor != ChocoboColor.PINK) && (dadColor != ChocoboColor.PINK || momColor != ChocoboColor.BLACK)) break;
                    babyColor = ChocoboColor.ROYAL;
                    break;
                }
                case 7: {
                    if (dadColor == ChocoboColor.BLUE && momColor == ChocoboColor.GREEN || dadColor == ChocoboColor.GREEN && momColor == ChocoboColor.BLUE || dadColor == ChocoboColor.WHITE && momColor == ChocoboColor.RED || dadColor == ChocoboColor.RED && momColor == ChocoboColor.WHITE || dadColor == ChocoboColor.BLACK && momColor == ChocoboColor.PINK || dadColor == ChocoboColor.PINK && momColor == ChocoboColor.BLACK) {
                        if (extendedMom.getStamina() + extendedDad.getStamina() >= 8400 && extendedMom.getRun() + extendedDad.getRun() >= 4600 && extendedMom.getDash() + extendedDad.getDash() >= 5100) {
                            if (dadColor == ChocoboColor.BLUE && momColor == ChocoboColor.GREEN || dadColor == ChocoboColor.GREEN && momColor == ChocoboColor.BLUE) {
                                babyColor = ChocoboColor.BLACK;
                            } else if (dadColor == ChocoboColor.WHITE && momColor == ChocoboColor.RED || dadColor == ChocoboColor.RED && momColor == ChocoboColor.WHITE) {
                                babyColor = ChocoboColor.PINK;
                            } else if (dadColor == ChocoboColor.BLACK && momColor == ChocoboColor.PINK || dadColor == ChocoboColor.PINK && momColor == ChocoboColor.BLACK) {
                                babyColor = ChocoboColor.ROYAL;
                            }
                            babyRating = this.field_70146_Z.nextBoolean() ? 6 : 5;
                            break;
                        }
                        dieRoll = this.field_70146_Z.nextInt(256);
                        if (dieRoll < 10) {
                            if (dadColor == ChocoboColor.BLUE && momColor == ChocoboColor.GREEN || dadColor == ChocoboColor.GREEN && momColor == ChocoboColor.BLUE) {
                                babyColor = ChocoboColor.BLACK;
                            } else if (dadColor == ChocoboColor.WHITE && momColor == ChocoboColor.RED || dadColor == ChocoboColor.RED && momColor == ChocoboColor.WHITE) {
                                babyColor = ChocoboColor.PINK;
                            } else if (dadColor == ChocoboColor.BLACK && momColor == ChocoboColor.PINK || dadColor == ChocoboColor.PINK && momColor == ChocoboColor.BLACK) {
                                babyColor = ChocoboColor.ROYAL;
                            }
                        } else if (dieRoll < 138) {
                            if (dadColor == ChocoboColor.BLUE && momColor == ChocoboColor.GREEN || dadColor == ChocoboColor.GREEN && momColor == ChocoboColor.BLUE) {
                                babyColor = ChocoboColor.BLUE;
                            } else if (dadColor == ChocoboColor.WHITE && momColor == ChocoboColor.RED || dadColor == ChocoboColor.RED && momColor == ChocoboColor.WHITE) {
                                babyColor = ChocoboColor.WHITE;
                            }
                        } else if (dadColor == ChocoboColor.BLUE && momColor == ChocoboColor.GREEN || dadColor == ChocoboColor.GREEN && momColor == ChocoboColor.BLUE) {
                            babyColor = ChocoboColor.GREEN;
                        } else if (dadColor == ChocoboColor.WHITE && momColor == ChocoboColor.RED || dadColor == ChocoboColor.RED && momColor == ChocoboColor.WHITE) {
                            babyColor = ChocoboColor.RED;
                        }
                        babyRating = this.field_70146_Z.nextBoolean() ? 6 : 5;
                        break;
                    }
                    if (dadColor == ChocoboColor.YELLOW && momColor == ChocoboColor.YELLOW && ((extendedMom.getRating() == 5 || extendedMom.getRating() == 6) && (extendedDad.getRating() == 5 || extendedDad.getRating() == 6) || extendedMom.getStamina() + extendedDad.getStamina() >= 8000 && extendedMom.getRun() + extendedDad.getRun() >= 4400 && extendedMom.getDash() + extendedDad.getDash() >= 4900)) {
                        dieRoll = this.field_70146_Z.nextInt(4);
                        if (dieRoll == 0) {
                            babyColor = ChocoboColor.BLUE;
                        } else if (dieRoll == 1) {
                            babyColor = ChocoboColor.GREEN;
                        } else if (dieRoll == 2) {
                            babyColor = ChocoboColor.WHITE;
                        } else if (dieRoll == 3) {
                            babyColor = ChocoboColor.RED;
                        }
                        if (extendedMom.getRating() == extendedDad.getRating()) {
                            babyRating = 6;
                            break;
                        }
                        babyRating = this.field_70146_Z.nextBoolean() ? 6 : 5;
                        break;
                    }
                    if (dadColor != ChocoboColor.YELLOW || momColor != ChocoboColor.YELLOW) break;
                    dieRoll = this.field_70146_Z.nextInt(256);
                    babyColor = dieRoll < 46 ? (this.field_70146_Z.nextBoolean() ? ChocoboColor.BLUE : ChocoboColor.WHITE) : (dieRoll < 90 ? (this.field_70146_Z.nextBoolean() ? ChocoboColor.GREEN : ChocoboColor.RED) : ChocoboColor.YELLOW);
                    if (extendedMom.getRating() == extendedDad.getRating()) {
                        babyRating = 6;
                        break;
                    }
                    babyRating = this.field_70146_Z.nextBoolean() ? 6 : 5;
                    break;
                }
                case 8: {
                    if ((dadColor == ChocoboColor.BLACK && momColor == ChocoboColor.PINK || dadColor == ChocoboColor.PINK && momColor == ChocoboColor.BLACK) && (this.field_70146_Z.nextInt(32) == 0 || extendedMom.getStamina() + extendedDad.getStamina() >= 8800 && extendedMom.getRun() + extendedDad.getRun() >= 4800 && extendedMom.getDash() + extendedDad.getDash() >= 5300)) {
                        babyColor = ChocoboColor.GOLD;
                        babyRating = 6;
                    }
                    if (babyColor != ChocoboColor.GOLD || babyRunMax >= 4000) break;
                    babyRunMax += 1000;
                }
            }
            switch (parentNuts[this.field_70146_Z.nextInt(2)]) {
                case 1: {
                    babyDash = Math.max((extendedMom.getDash() + extendedDad.getDash()) / 2 - (1 + this.field_70146_Z.nextInt(2)) * 100, 300);
                    break;
                }
                case 2: {
                    babyDash = Math.max((extendedMom.getDash() + extendedDad.getDash()) / 2 - this.field_70146_Z.nextInt(2) * this.field_70146_Z.nextInt(256), 300);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    babyDash = (extendedMom.getDash() + extendedDad.getDash()) / 2;
                }
            }
            switch (parentNuts[this.field_70146_Z.nextInt(2)]) {
                case 1: {
                    babyDashMax = Math.max((extendedMom.getDashMax() + extendedDad.getDashMax()) / 2 - (1 + this.field_70146_Z.nextInt(2)) * 100, 300);
                    if (babyDashMax >= 4000 || this.field_70146_Z.nextInt(512) != 0) break;
                    dieRoll = this.field_70146_Z.nextInt(128);
                    if (dieRoll <= 0) {
                        babyDashMax = 4000;
                    } else if (dieRoll <= 1) {
                        babyDashMax = 4100;
                    } else if (dieRoll <= 3) {
                        babyDashMax = 4200;
                    } else if (dieRoll <= 6) {
                        babyDashMax = 4300;
                    } else if (dieRoll <= 7) {
                        babyDashMax = 4500;
                    }
                    babyDash = babyDashMax;
                    for (int i = 0; i < 6; ++i) {
                        babyDash -= this.field_70146_Z.nextInt(256);
                    }
                    break;
                }
                case 2: {
                    babyDashMax = Math.max((extendedMom.getDashMax() + extendedDad.getDashMax()) / 2 - this.field_70146_Z.nextInt(2) * this.field_70146_Z.nextInt(256), 300);
                    break;
                }
                case 3: {
                    dieRoll = this.field_70146_Z.nextInt(32);
                    if (dieRoll < 3) {
                        babyDashMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getDashMax() : extendedDad.getDashMax()) * 34 / 33, 6000);
                        break;
                    }
                    if (dieRoll < 6) {
                        babyDashMax = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getDashMax() : extendedDad.getDashMax()) * 32 / 33, 1);
                        break;
                    }
                    babyDashMax = (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2;
                    break;
                }
                case 4: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyDashMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getDashMax() : extendedDad.getDashMax()) * 21 / 20, 6000);
                        break;
                    }
                    if (dieRoll < 75) {
                        babyDashMax = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getDashMax() : extendedDad.getDashMax()) * 19 / 20, 1);
                        break;
                    }
                    babyDashMax = (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2;
                    break;
                }
                case 5: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 70) {
                        babyDashMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getDashMax() : extendedDad.getDashMax()) * 16 / 15, 6000);
                        break;
                    }
                    babyDashMax = (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2;
                    break;
                }
                case 6: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyDashMax = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getDashMax() : extendedDad.getDashMax()) * 19 / 18, 6000);
                        break;
                    }
                    if (dieRoll < 75) {
                        babyDashMax = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getDashMax() : extendedDad.getDashMax()) * 32 / 33, 1);
                        break;
                    }
                    babyDashMax = (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2;
                    break;
                }
                case 7: {
                    if ((babyColor == ChocoboColor.BLACK || babyColor == ChocoboColor.PINK || babyColor == ChocoboColor.ROYAL) && (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2 < 4000) {
                        dieRoll = this.field_70146_Z.nextInt(16);
                        babyDashMax = dieRoll < 7 ? 4000 : (dieRoll < 11 ? 4200 : (dieRoll < 12 ? 4300 : (dieRoll < 13 ? 4400 : (dieRoll < 15 ? 4500 : 4800))));
                        babyDashMax += (this.field_70146_Z.nextBoolean() ? 1 : -1) * (this.field_70146_Z.nextInt(256) / 5);
                        break;
                    }
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 60) {
                        babyDashMax = Math.min(Math.max(extendedMom.getDashMax(), extendedDad.getDashMax()) * 11 / 10, 6000);
                        break;
                    }
                    babyDashMax = (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2;
                    break;
                }
                case 8: {
                    if (babyColor == ChocoboColor.GOLD && (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2 < 5000) {
                        dieRoll = this.field_70146_Z.nextInt(16);
                        babyDashMax = dieRoll < 7 ? 5000 : (dieRoll < 9 ? 5100 : (dieRoll < 11 ? 5200 : (dieRoll < 12 ? 5300 : (dieRoll < 13 ? 5400 : (dieRoll < 15 ? 5500 : 5950)))));
                        babyDashMax += (this.field_70146_Z.nextBoolean() ? -1 : 1) * (this.field_70146_Z.nextInt(256) / 10);
                        break;
                    }
                    dieRoll = this.field_70146_Z.nextInt(256);
                    babyDashMax = dieRoll < 55 ? Math.min(Math.max(extendedMom.getDashMax(), extendedDad.getDashMax()) * 11 / 10, 6000) : (extendedMom.getDashMax() + extendedDad.getDashMax()) / 2;
                }
            }
            switch (parentNuts[this.field_70146_Z.nextInt(2)]) {
                case 1: {
                    babyStamina = Math.max((extendedMom.getStamina() + extendedDad.getStamina()) / 2 - this.field_70146_Z.nextInt(256), 1);
                    break;
                }
                case 2: {
                    babyStamina = Math.max((extendedMom.getStamina() + extendedDad.getStamina()) / 2, 1);
                    break;
                }
                case 3: {
                    dieRoll = this.field_70146_Z.nextInt(32);
                    if (dieRoll < 3) {
                        babyStamina = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getStamina() : extendedDad.getStamina()) * 34 / 33, 9999);
                        break;
                    }
                    if (dieRoll < 6) {
                        babyStamina = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getStamina() : extendedDad.getStamina()) * 32 / 33, 100);
                        break;
                    }
                    babyStamina = (extendedMom.getStamina() + extendedDad.getStamina()) / 2;
                    break;
                }
                case 4: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyStamina = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getStamina() : extendedDad.getStamina()) * 21 / 20, 9999);
                        break;
                    }
                    if (dieRoll < 75) {
                        babyStamina = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getStamina() : extendedDad.getStamina()) * 19 / 20, 100);
                        break;
                    }
                    babyStamina = (extendedMom.getStamina() + extendedDad.getStamina()) / 2;
                    break;
                }
                case 5: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyStamina = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getStamina() : extendedDad.getStamina()) * 21 / 20, 9999);
                        break;
                    }
                    babyStamina = (extendedMom.getStamina() + extendedDad.getStamina()) / 2;
                    break;
                }
                case 6: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyStamina = Math.min((this.field_70146_Z.nextBoolean() ? extendedMom.getStamina() : extendedDad.getStamina()) * 19 / 18, 9999);
                        break;
                    }
                    if (dieRoll < 85) {
                        babyStamina = Math.max((this.field_70146_Z.nextBoolean() ? extendedMom.getStamina() : extendedDad.getStamina()) * 9 / 10, 100);
                        break;
                    }
                    babyStamina = (extendedMom.getStamina() + extendedDad.getStamina()) / 2;
                    break;
                }
                case 7: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    if (dieRoll < 50) {
                        babyStamina = Math.min(Math.max(extendedMom.getStamina(), extendedDad.getStamina()) * 21 / 20, 9999);
                        break;
                    }
                    babyStamina = (extendedMom.getStamina() + extendedDad.getStamina()) / 2;
                    break;
                }
                case 8: {
                    dieRoll = this.field_70146_Z.nextInt(256);
                    babyStamina = dieRoll < 175 ? Math.min(Math.max(extendedMom.getStamina(), extendedDad.getStamina()) * 21 / 20, 9999) : (extendedMom.getStamina() + extendedDad.getStamina()) / 2;
                }
            }
            babyDashMax = MathHelper.func_76125_a((int)babyDashMax, (int)300, (int)6000);
            babyRunMax = MathHelper.func_76125_a((int)babyRunMax, (int)300, (int)6000);
            babyRun = MathHelper.func_76125_a((int)babyRun, (int)300, (int)6000);
            babyStamina = MathHelper.func_76125_a((int)babyStamina, (int)100, (int)6000);
            for (babyDash = MathHelper.func_76125_a((int)babyDash, (int)300, (int)6000); babyDash >= babyDashMax; babyDash -= 100) {
            }
            while (babyRunMax >= babyDashMax) {
                babyRunMax -= 100;
            }
            while (babyRun >= babyDash || babyRun >= babyRunMax) {
                babyRun -= 100;
            }
            babyChicobo.setChocoDadID(extendedDad.getChocoID());
            babyChicobo.setChocoMomID(extendedMom.getChocoID());
            babyChicobo.setDashMax(babyDashMax);
            babyChicobo.setDash(babyDash);
            babyChicobo.setRunMax(babyRunMax);
            babyChicobo.setRun(babyRun);
            babyChicobo.setStamina(babyStamina);
            babyChicobo.setAcceleration(babyAcceleration);
            babyChicobo.setCooperation(babyCooperation);
            babyChicobo.setIntelligence(babyIntelligence);
            babyChicobo.setRating(babyRating);
            babyChicobo.setPersonality(babyPersonality);
            babyChicobo.setColor(babyColor);
            babyChicobo.setIsMale(this.field_70146_Z.nextBoolean());
            babyChicobo.setChocoID(babyChicobo.func_145782_y());
            this.field_70170_p.func_72838_d((Entity)babyChicobo);
            if (this.getOwner() instanceof EntityPlayerMP) {
                EntityPlayerMP entityplayermp = (EntityPlayerMP)this.getOwner();
                ChocoboColor[] color_a = new ChocoboColor[]{ChocoboColor.BLUE, ChocoboColor.GREEN, ChocoboColor.RED, ChocoboColor.WHITE, ChocoboColor.BLACK, ChocoboColor.PINK, ChocoboColor.ROYAL, ChocoboColor.GOLD};
                ResourceLocation[] resourcelocation_a = new ResourceLocation[]{Advancements.RL_CHOCO_BLUE, Advancements.RL_CHOCO_GREEN, Advancements.RL_CHOCO_RED, Advancements.RL_CHOCO_WHITE, Advancements.RL_CHOCO_BLACK, Advancements.RL_CHOCO_PINK, Advancements.RL_CHOCO_ROYAL, Advancements.RL_CHOCO_GOLD};
                CustomTrigger[] achievement_a = new CustomTrigger[]{ModTriggers.CHOCO_BLUE, ModTriggers.CHOCO_GREEN, ModTriggers.CHOCO_RED, ModTriggers.CHOCO_WHITE, ModTriggers.CHOCO_BLACK, ModTriggers.CHOCO_PINK, ModTriggers.CHOCO_ROYAL, ModTriggers.CHOCO_GOLD};
                for (int i = 0; i < color_a.length; ++i) {
                    if (!babyColor.equals((Object)color_a[i]) || entityplayermp.func_184102_h().func_184103_al().func_192054_h(entityplayermp).func_192747_a(entityplayermp.func_184102_h().func_191949_aK().func_192778_a(resourcelocation_a[i])).func_192105_a()) continue;
                    achievement_a[i].trigger(entityplayermp);
                    break;
                }
            }
            this.func_70873_a(this.isMale() ? GeneralConfig.breedingDelayMale : GeneralConfig.breedingDelayFemale);
            otherParent.func_70873_a(otherParent.isMale() ? GeneralConfig.breedingDelayMale : GeneralConfig.breedingDelayFemale);
            this.entityToAttack = null;
            otherParent.entityToAttack = null;
            this.breeding = 0;
            otherParent.breeding = 0;
            this.setInLove(false);
            otherParent.setInLove(false);
            this.sendParticleUpdate(34, this, 7);
        }
    }

    public void damageHandling() {
        this.fleeingTick = 60;
        this.entityToAttack = null;
        this.setInLove(false);
    }

    public int func_70641_bl() {
        return GeneralConfig.spawnTotalMax;
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Boolean isPosPathWeight = this.func_180484_a(new BlockPos(x, y, z)) >= 0.0f;
        return isPosPathWeight != false && super.func_70601_bi();
    }

    public boolean canSpawnAtLoc(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)this.field_70170_p, pos.func_177977_b(), EnumFacing.UP) && ChocoboEntityHelper.isSpaceAroundLocationFree(this.field_70170_p, pos, 1, 3, 1);
    }

    public boolean teleportToOwner() {
        if (this.getOwner() != null) {
            int ownerPosX = MathHelper.func_76128_c((double)this.getOwner().field_70165_t) - 2;
            int ownerPosZ = MathHelper.func_76128_c((double)this.getOwner().field_70161_v) - 2;
            int ownerPosY = MathHelper.func_76128_c((double)this.getOwner().func_174813_aQ().field_72338_b);
            for (int xOffset = 0; xOffset <= 4; ++xOffset) {
                for (int yOffset = 0; yOffset <= 4; ++yOffset) {
                    int zTele;
                    int yTele;
                    int xTele;
                    BlockPos posTele;
                    if (xOffset >= 1 && yOffset >= 1 && xOffset <= 3 && yOffset <= 3 || !this.canSpawnAtLoc(posTele = new BlockPos(xTele = ownerPosX + xOffset, yTele = ownerPosY, zTele = ownerPosZ + yOffset))) continue;
                    double finXTele = (double)xTele + 0.5;
                    double finYTele = yTele;
                    double finZTele = (double)zTele + 0.5;
                    this.func_70012_b(finXTele, finYTele, finZTele, this.field_70177_z, this.field_70125_A);
                    this.func_70661_as().func_75499_g();
                    return true;
                }
            }
        }
        return false;
    }

    public void changeOwnership(UUID newOwnerUUID, boolean setTamed) {
        this.func_70903_f(setTamed);
        if (setTamed) {
            this.func_184754_b(newOwnerUUID);
        } else {
            this.func_184754_b(null);
        }
        this.sendChangeOwnerUpdate();
    }

    public void changeOwnership(UUID newOwnerUUID) {
        this.func_184754_b(newOwnerUUID);
        this.sendChangeOwnerUpdate();
    }

    public int func_70627_aG() {
        return 150;
    }

    protected boolean func_70692_ba() {
        return GeneralConfig.wildCanDespawn && !this.func_70909_n();
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public boolean playerInRange(double range) {
        double dZ;
        double dY;
        double dX;
        double delta;
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, -1.0);
        return null != player && (delta = (dX = player.field_70165_t - this.field_70165_t) * dX + (dY = player.field_70163_u - this.field_70163_u) * dY + (dZ = player.field_70161_v - this.field_70161_v) * dZ) < range;
    }

    protected void useItem(EntityPlayer entityplayer, int numberToUse) {
        if (entityplayer.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        itemstack.func_190918_g(numberToUse);
    }

    public boolean func_70631_g_() {
        return this instanceof EntityChicobo;
    }

    public void func_180430_e(float fallHeight, float multiplier) {
        int i;
        if (!this.canSoftFall && (i = MathHelper.func_76123_f((float)(fallHeight - (this.canHighJump ? 10.0f : 6.0f)))) > 0) {
            if (i > 4) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187736_dY, this.func_184176_by(), 1.0f, 1.0f);
            } else {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187804_ed, this.func_184176_by(), 1.0f, 1.0f);
            }
            this.func_70097_a(DamageSource.field_76379_h, i);
            int blockPosX = MathHelper.func_76128_c((double)this.field_70165_t);
            int blockPosY = MathHelper.func_76128_c((double)(this.field_70163_u - 0.2 - this.func_70033_W()));
            int blockPosZ = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_180495_p(new BlockPos(blockPosX, blockPosY, blockPosZ)).func_177230_c();
            if (block != null) {
                SoundType soundtype = block.func_185467_w();
                this.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    protected void getPathOrWalkableBlock(Entity entity, float distance) {
        boolean canDrown = true;
        Path Path2 = this.field_70699_by.func_75494_a(entity);
        if (Path2 != null || distance > 12.0f) {
            this.field_70699_by.func_75484_a(Path2, (double)this.field_110154_aX);
        }
    }

    protected void func_70619_bc() {
        if (this.fleeingTick > 0) {
            --this.fleeingTick;
        }
        this.hasAttacked = this.isMovementCeased();
        int i = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72338_b + 0.5));
        this.field_70125_A = 0.0f;
        if (this.pathToEntity == null || this.field_70146_Z.nextInt(100) == 0) {
            super.func_70619_bc();
            this.pathToEntity = null;
            return;
        }
        Vec3d vector = this.pathToEntity.func_75878_a((Entity)this);
        double d = this.field_70130_N * 2.0f;
        while (vector != null) {
            Vec3d vec3d = new Vec3d(this.field_70165_t, vector.field_72448_b, this.field_70161_v);
            if (!(vector.func_72436_e(vec3d) < d * d)) break;
            this.pathToEntity.func_75875_a();
            if (this.pathToEntity.func_75879_b()) {
                vector = null;
                this.pathToEntity = null;
                continue;
            }
            vector = this.pathToEntity.func_75878_a((Entity)this);
        }
        this.field_70703_bu = false;
        if (vector != null) {
            float f3;
            double d1 = vector.field_72450_a - this.field_70165_t;
            double d2 = vector.field_72449_c - this.field_70161_v;
            double d3 = vector.field_72448_b - (double)i;
            float f2 = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f;
            for (f3 = f2 - this.field_70177_z; f3 < -180.0f; f3 += 360.0f) {
            }
            while (f3 >= 180.0f) {
                f3 -= 360.0f;
            }
            f3 = MathHelper.func_76131_a((float)f3, (float)-30.0f, (float)30.0f);
            this.field_70177_z += f3;
            if (this.hasAttacked && this.entityToAttack != null) {
                double distToAttackX = this.entityToAttack.field_70165_t - this.field_70165_t;
                double distToAttackZ = this.entityToAttack.field_70161_v - this.field_70161_v;
                float tmpRotYaw = this.field_70177_z;
                this.field_70177_z = (float)(Math.atan2(distToAttackZ, distToAttackX) * 180.0 / Math.PI) - 90.0f;
                float f5 = (tmpRotYaw - this.field_70177_z + 90.0f) * (float)Math.PI / 180.0f;
                this.field_70702_br = -MathHelper.func_76126_a((float)f5) * this.field_191988_bg * 1.0f;
                this.field_191988_bg = MathHelper.func_76134_b((float)f5) * this.field_191988_bg * 1.0f;
            }
            if (d3 > 0.0) {
                this.field_70703_bu = true;
            }
        }
        if (this.entityToAttack != null) {
            this.func_70625_a(this.entityToAttack, 30.0f, 30.0f);
        }
        if (this.field_70123_F && !this.func_70781_l()) {
            this.field_70703_bu = true;
        }
        if ((this.anyPartInWater() || this.func_180799_ab()) && this.field_70146_Z.nextFloat() < 0.8f) {
            this.field_70703_bu = true;
        } else if (this.field_70122_E) {
            this.field_70703_bu = false;
        }
    }

    public boolean anyPartInWater() {
        return this.func_70090_H() || this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.1f)), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a() == Material.field_151586_h;
    }

    protected void showAmountHeartsOrSmokeFx(boolean showHeart, int amount) {
        if (this.isClient()) {
            for (int i = 0; i < amount; ++i) {
                ChocoboParticleHelper.showParticleAroundEntityFx(showHeart ? 34 : 11, (Entity)this);
            }
        }
    }

    protected void showParticles(int particleID, int amount) {
        if (this.isClient()) {
            for (int i = 0; i < amount; ++i) {
                ChocoboParticleHelper.showParticleAroundEntityFx(particleID, (Entity)this);
            }
        }
    }

    protected EntityPlayer getNearestPlayer() {
        EntityPlayer nearestPlayer = null;
        double distance = 9999.0;
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
        for (EntityPlayer player : players) {
            double tmpDistance = this.func_70032_d((Entity)player);
            if (!(tmpDistance < distance)) continue;
            distance = tmpDistance;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    public boolean canRenderName() {
        return this.isClient() && GeneralConfig.showChocoboNames && this.func_70909_n() && this.func_184179_bs() == null && !this.isHidename() && !this.func_70005_c_().isEmpty();
    }

    protected void sendChangeOwnerUpdate() {
        if (this.isClient()) {
            ChocoboChangeOwnership packet = new ChocoboChangeOwnership(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }

    protected void sendTamedUpdate() {
        if (this.isServer()) {
            ChocoboTamed packet = new ChocoboTamed(this);
            int dimension = this.field_70170_p.field_73011_w.getDimension();
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    public void sendAttributeUpdate() {
        if (this.isClient()) {
            ChocoboAttribute packet = new ChocoboAttribute(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }

    protected void sendHungerUpdate() {
        if (this.isServer()) {
            ChocoboHunger packet = new ChocoboHunger(this);
            int dimension = this.field_70170_p.field_73011_w.getDimension();
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    protected void sendHealthUpdate() {
        if (this.isServer()) {
            ChocoboHealth packet = new ChocoboHealth(this);
            int dimension = this.field_70170_p.field_73011_w.getDimension();
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    public void sendParticleUpdate(int particleID, EntityAnimalChocobo chocobo, int amount) {
        if (this.isServer()) {
            ChocoboParticles packet = new ChocoboParticles(chocobo, particleID, amount);
            int dimension = chocobo.field_70170_p.field_73011_w.getDimension();
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(dimension, this.field_70142_S, this.field_70137_T, this.field_70136_U, 80.0);
            PacketRegistry.INSTANCE.sendToAllAround((IMessage)packet, targetPoint);
        }
    }

    protected void sendSetInLoveUpdate() {
    }

    public void setRandomStats() {
        if (!this.func_95999_t().equals(null) && !this.func_95999_t().equals("")) {
            this.setName(this.func_95999_t());
        } else {
            this.setName("");
        }
        Random random = new Random();
        int[] weights = new int[]{21, 16, 23, 19, 11, 5, 14, 3};
        int rank = ChocoFunctions.weightedRandom(weights, random);
        this.setRating(rank);
        int Stam = 0;
        int MDash = 0;
        int Dash = 0;
        int MRun = 0;
        int Run = 0;
        int Accel = 0;
        int Int = 0;
        int Pers = 0;
        switch (rank) {
            case 7: {
                Stam = (new int[]{45, 43, 42, 40, 40, 40, 38, 35})[random.nextInt(8)];
                MDash = (new int[]{35, 36, 37, 38, 38, 39, 40, 40})[random.nextInt(8)];
                break;
            }
            case 6: {
                Stam = (new int[]{38, 36, 35, 34, 33, 32, 32, 30})[random.nextInt(8)];
                MDash = (new int[]{30, 30, 31, 32, 33, 34, 35, 36})[random.nextInt(8)];
                break;
            }
            case 5: {
                Stam = (new int[]{35, 33, 32, 31, 30, 29, 28, 26})[random.nextInt(8)];
                MDash = (new int[]{28, 28, 30, 30, 31, 31, 32, 33})[random.nextInt(8)];
                break;
            }
            case 4: {
                Stam = (new int[]{33, 31, 30, 30, 28, 27, 26, 30})[random.nextInt(8)];
                MDash = (new int[]{24, 25, 26, 27, 28, 30, 30, 30})[random.nextInt(8)];
                break;
            }
            case 3: {
                Stam = (new int[]{25, 23, 22, 21, 19, 18, 20, 20})[random.nextInt(8)];
                MDash = (new int[]{20, 22, 23, 24, 26, 28, 25, 25})[random.nextInt(8)];
                break;
            }
            case 2: {
                Stam = (new int[]{20, 17, 15, 13, 10, 16, 16, 16})[random.nextInt(8)];
                MDash = (new int[]{18, 19, 21, 22, 23, 20, 20, 20})[random.nextInt(8)];
                break;
            }
            case 1: {
                Stam = (new int[]{13, 12, 11, 9, 8, 10, 10, 10})[random.nextInt(8)];
                MDash = (new int[]{15, 16, 17, 19, 20, 18, 18, 18})[random.nextInt(8)];
                break;
            }
            case 0: {
                Stam = (new int[]{10, 9, 7, 6, 5, 8, 8, 8})[random.nextInt(8)];
                MDash = (new int[]{13, 14, 16, 17, 18, 15, 15, 15})[random.nextInt(8)];
            }
        }
        Stam *= 100;
        MDash *= 100;
        Stam += random.nextInt(128) * (random.nextBoolean() ? 1 : -1);
        Dash = rank > 3 ? MDash / 10 * (5 + random.nextInt(4)) : (MDash += random.nextInt(128) * (random.nextBoolean() ? 1 : -1)) / 10 * (random.nextInt(256) / 50 + 3);
        int runbelowdash = 0;
        runbelowdash = rank > 3 ? 100 * (2 + random.nextInt(3)) : 100 * (2 + random.nextInt(4));
        MRun = Math.max(MDash - runbelowdash, 0);
        Run = Math.max(Dash - runbelowdash, 0);
        switch (rank / 2) {
            case 3: {
                Accel = 6 + random.nextInt(2);
                Int = 5 + random.nextInt(2);
                Pers = random.nextInt(8) == 0 ? random.nextInt(10) : 82;
                break;
            }
            case 2: {
                Accel = 5 + random.nextInt(2);
                Int = 3 + random.nextInt(2);
                Pers = random.nextInt(4) == 0 ? random.nextInt(10) : 82;
                break;
            }
            case 1: {
                Accel = 3 + random.nextInt(3);
                Int = 0 + random.nextInt(3);
                Pers = random.nextInt(2) == 0 ? random.nextInt(10) : 82;
                break;
            }
            case 0: {
                Accel = 2 + random.nextInt(4);
                Int = 0 + random.nextInt(3);
                Pers = random.nextInt(2) == 0 ? random.nextInt(10) : 82;
            }
        }
        Accel *= 10;
        Int *= 10;
        if (rank == 0 || rank == 7) {
            this.setIsMale(random.nextInt(256) < (rank == 0 ? 134 : 122));
        }
        this.staminaSprintCounter = 15;
        this.setStamina(Stam);
        this.setDashMax(MDash);
        this.setDash(Dash);
        this.setRunMax(MRun);
        this.setRun(Run);
        this.setAcceleration(Accel);
        this.setIntelligence(Int);
        this.setCooperation(0);
        this.setRating(rank);
        this.setPersonality(Pers);
        this.setChocoID(this.func_145782_y());
        this.sendAttributeUpdate();
    }

    public static enum ChocoboColor {
        YELLOW,
        GREEN,
        BLUE,
        WHITE,
        BLACK,
        GOLD,
        PINK,
        RED,
        ROYAL;

    }
}

