/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.config;

import chococraftplus.common.utils.ChocoFunctions;
import chococraftplus.common.utils.LogHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GeneralConfig {
    public static Configuration config;
    public static boolean debugMessages;
    public static boolean showChocoboNames;
    public static boolean wingFlap;
    public static final boolean HUNGER_ENABLED = true;
    public static final boolean RIDER_BUFFS_ENABLED = true;
    public static double renderNameHeight;
    public static boolean useChocoCraftNameRendering;
    public static int chocoSoundFrequency;
    public static int chicoSoundFrequency;
    public static int wildPlantDropNut;
    public static String[] gardenNutWeights;
    public static String[] gardenVeggieWeights;
    public static int[] arrayNutWeights;
    public static int[] arrayVeggieWeights;
    public static String[] gysahlGardenDimensionWhitelist;
    public static List<Integer> gysahlGardenDimensionWhitelist_a;
    public static int gysahlGardenWorldGenRate;
    public static int breedingDelayFemale;
    public static int breedingDelayMale;
    public static int growUpDelayStatic;
    public static int growUpDelayRandom;
    public static int appetiteChicobo;
    public static int appetiteChocobo;
    public static int penHealProbability;
    public static int penHealCauldronRange;
    public static boolean wildCanDespawn;
    public static boolean chocopediaChestLoot;
    public static String[] spawnBiomesNames;
    public static int spawnTimeDelay;
    public static int spawnProbability;
    public static int spawnGroupMin;
    public static int spawnGroupMax;
    public static int spawnTotalMax;
    public static int spawnLimitBlockRadius;
    public static int distanceNextWild;
    public static int featherDelayRandom;
    public static int featherDelayStatic;
    public static int featherDropChance;
    public static int grassSeedWeight;
    public static int foodBaseCooldown;
    public static boolean carobAsLoot;
    public static boolean zeioAsLoot;
    public static boolean allowInbreeding;
    public static String[] mobDrops;
    public static boolean versionChecker;
    public static boolean antiqueAtlasStableMarkersVillage;
    public static boolean antiqueAtlasStableMarkersWorld;
    public static boolean villageStables;
    public static boolean villageStableSign;
    public static int villageStableWeight;
    public static int villageStableRarity;
    public static boolean worldStables;
    public static float villageStableChestChance;
    public static int worldStableSpacing;
    public static int worldStableSpread;
    public static String[] stableBiomesNames;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            GeneralConfig.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        int i;
        useChocoCraftNameRendering = config.getBoolean("Use Chococraft Name Rendering", "miscellaneous", true, "Use ChocoCraft Plus's name tag rendering system. Set to false for vanilla.");
        showChocoboNames = config.getBoolean("Show Chocobo Names", "miscellaneous", true, "Set to false to disable ChocoCraft Plus names from rendering, even if a Chocobo's \"Show Name\" is active");
        wingFlap = config.getBoolean("Wing Flap", "miscellaneous", true, "Chocobo wings flap when flying or during soft-fall.");
        renderNameHeight = config.getFloat("Render Name Height", "miscellaneous", 0.0f, -2.0f, 10.0f, "The default name height is 2.3 blocks from the ground. You can add height up to 10 blocks.");
        versionChecker = config.getBoolean("Version Checker", "miscellaneous", true, "Displays a client-side chat message on login if there's an update available.");
        debugMessages = config.getBoolean("Debug Messages", "miscellaneous", false, "Print additional debug messages to the console");
        antiqueAtlasStableMarkersVillage = config.getBoolean("Antique Atlas: Chocobo Stable markers (Village)", "mod integration", true, "Add a marker in Antique Atlases for chocobo stables found in villages");
        antiqueAtlasStableMarkersWorld = config.getBoolean("Antique Atlas: Chocobo Stable markers (World)", "mod integration", true, "Add a marker in Antique Atlases for chocobo stables found in the wilderness");
        villageStables = config.getBoolean("Village Chocobo Stables", "world generation", true, "Generate chocobo stables in some villages");
        villageStableSign = config.getBoolean("Village Stables Sign", "world generation", true, "Whether stables have a pictograph sign out front");
        worldStables = config.getBoolean("World Chocobo Stables", "world generation", true, "Generate chocobo stables in the world");
        villageStableChestChance = config.getFloat("Village Stables Chest Chance", "world generation", 0.5f, 0.0f, 1.0f, "Chances a stable has a hidden chest.");
        villageStableWeight = config.getInt("Village Stables Weight", "world generation", 25, 1, 100, "Chances a stable is selected for village generation. Farms and wood hut are 3, Church is 20.");
        villageStableRarity = config.getInt("Village Stables Rarity", "world generation", 4, 1, 1000000, "1-in-N chance for a stable to be generated in a village, IF it's called from the piece index");
        worldStableSpacing = config.getInt("World Stables Spacing", "world generation", 40, 10, 1000000, "Median spacing, in chunks, between stables spawning in allowed biomes. Vanilla villages are 20.");
        worldStableSpread = config.getInt("World Stables Spread", "world generation", 48, 0, 1000000, "Range of spacings, in chunks, between stables spawning in allowed biomes. Vanilla villages are 24. This value can't be more than twice the value of World Stables Spacing.");
        stableBiomesNames = config.getStringList("Stable Biome Names", "world generation", new String[]{"Forest", "Taiga", "Jungle", "Birch Forest", "Roofed Forest", "Cold Taiga", "Mega Taiga", "Mega Spruce Taiga", "Bamboo Forest", "Boreal Forest", "Cherry Blossom Grove", "Coniferous Forest", "Snowy Coniferous Forest", "Deciduous Forest", "Dense Forest", "Eucalyptus Forest", "Frost Forest", "Fungi Forest", "Maple Woods", "Rainforest", "Redwood Forest", "Seasonal Forest", "Shield", "Temperate Rainforest", "Tropical Rainforest", "Woodland", "Meadow Forest", "Seasonal Forest Clearing", "Spruce Woods", "Autumn Woods", "Mini Jungle", "Pine Forest", "Redwood Lush", "Snowy Forest", "Snowy Rainforest", "Woodlands", "Autumn Forest", "Pinelands", "Tall Pine Forest", "Tropics"}, "Names of biomes which can spawn chocobo stables. Only applies to Overworld. Note that this list is EXCLUSIVE: other mod configs won't override this. You have to paste all biome names here.");
        grassSeedWeight = config.getInt("Grass Seed Rate", "world generation", 2, 0, 100, "Drop weight of Gysahl Garden seeds. For reference, wheat seeds are 10");
        wildPlantDropNut = config.getInt("Garden Nut Rate", "world generation", 100, 0, 1000, "Permille chance a gysahl garden will drop a nut instead of a veggie");
        gardenNutWeights = config.getStringList("Garden Nut Weights", "world generation", new String[]{"300", "150", "75", "50", "15", "12", "0", "0"}, "Drop weights of the eight breeding nuts when one is dropped from a gysahl garden. Values are in this order:\nPipio Nut (default 300)\nLuchile Nut (default 150)\nSaraha Bean (default 75)\nLasan Nut (default 50)\nPorov Bean (default 15)\nParam Nut (default 12)\nCarob Nut (default 0)\nZeio Nut (default 0)\nEntries must be non-negative integers, and at least one must not be zero.");
        gardenVeggieWeights = config.getStringList("Garden Veggie Weights", "world generation", new String[]{"600", "240", "150", "75", "60", "40", "20", "12"}, "Drop weights of the eight veggies when one is dropped from a gysahl garden. Values are in this order:\nGysahl Carrot (default 600)\nKrakka Root (default 240)\nTantal Veggie (default 150)\nPasana Fruit (default 75)\nCree Root (default 60)\nMimett Fruit (default 40)\nReagan Veggie (default 20)\nSylkis Bud (default 12)\nEntries must be non-negative integers, and at least one must not be zero.");
        int[] arrayNutWeightDefaults = new int[]{300, 150, 75, 50, 15, 12, 0, 0};
        int discriminant = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            try {
                int weight_int = Integer.parseInt(gardenNutWeights[i2]);
                GeneralConfig.arrayNutWeights[i2] = Math.max(weight_int, 0);
                discriminant += Math.max(weight_int, 0);
                continue;
            }
            catch (Exception e) {
                GeneralConfig.arrayNutWeights[i2] = arrayNutWeightDefaults[i2];
                discriminant += arrayNutWeightDefaults[i2];
                LogHelper.error("Garden Nut Weights parsing error! Check your config values. Substituting with default.");
            }
        }
        if (discriminant <= 0) {
            LogHelper.error("Garden Nut Weights do not sum above zero! Check your config values. Now using defaults.");
            arrayNutWeights = arrayNutWeightDefaults;
        }
        int[] arrayVeggieWeightDefaults = new int[]{600, 240, 150, 75, 60, 40, 20, 12};
        discriminant = 0;
        for (i = 0; i < 8; ++i) {
            try {
                int weight_int = Integer.parseInt(gardenVeggieWeights[i]);
                GeneralConfig.arrayVeggieWeights[i] = Math.max(weight_int, 0);
                discriminant += Math.max(weight_int, 0);
                continue;
            }
            catch (Exception e) {
                GeneralConfig.arrayVeggieWeights[i] = arrayVeggieWeightDefaults[i];
                discriminant += arrayVeggieWeightDefaults[i];
                LogHelper.error("Garden Veggie Weights parsing error! Check your config values. Substituting with default.");
            }
        }
        if (discriminant <= 0) {
            LogHelper.error("Garden Veggie Weights do not sum above zero! Check your config values. Now using defaults.");
            arrayVeggieWeights = arrayVeggieWeightDefaults;
        }
        gysahlGardenWorldGenRate = config.getInt("Gysahl Garden World Generation Rate", "world generation", 20, 0, 1000, "Value representing wild Gysahl generation. 0 results in no generation, and 1000 is very many.");
        gysahlGardenDimensionWhitelist = config.getStringList("Gysahl Garden Dimension Whitelist", "world generation", new String[]{"0"}, "Dimension IDs where Gysahl Gardens can generate");
        gysahlGardenDimensionWhitelist_a.clear();
        for (i = 0; i < gysahlGardenDimensionWhitelist.length; ++i) {
            String dimID_st = gysahlGardenDimensionWhitelist[i];
            try {
                int dimID_int = Integer.parseInt(dimID_st.trim());
                gysahlGardenDimensionWhitelist_a.add(dimID_int);
                continue;
            }
            catch (Exception e) {
                LogHelper.warn("Couldn't interpret dimension ID " + dimID_st.trim() + " as an integer. Check your formatting.");
            }
        }
        chocopediaChestLoot = config.getBoolean("Chest Loot - Chocopedia", "world generation", true, "Whether or not the Chocopedia can be found as chest loot");
        carobAsLoot = config.getBoolean("Chest Loot - Carob Nut", "world generation", true, "Whether Carob Nuts can be found as chest loot");
        zeioAsLoot = config.getBoolean("Chest Loot - Zeio Nut", "world generation", true, "Whether Zeio Nuts can be found as chest loot");
        mobDrops = config.getStringList("Mob Drops", "world generation", new String[]{"net.minecraft.entity.passive.EntityVillager|Chocopedia|8", "net.minecraft.entity.passive.EntityWitch|Chocopedia|4", "net.minecraft.entity.passive.EntityZombie|Chocopedia|2", "net.minecraft.entity.passive.EntitySkeleton|Chocopedia|1", "com.lycanitesmobs.core.entity.creature.EntityYale|Pipio|36", "twilightforest.entity.EntityTFMistWolf|Luchile|36", "com.lycanitesmobs.core.entity.creature.EntityRemobra|Saraha|36", "com.lycanitesmobs.core.entity.creature.EntityShambler|Lasan|18", "net.minecraft.entity.monster.EntityCreeper|Carob|18", "com.lycanitesmobs.core.entity.creature.EntityZoataur|Carob|132", "net.minecraft.entity.monster.EntityPigZombie|Zeio|9", "twilightforest.entity.EntityTFKobold|Zeio|27"}, "List of mobs that drop ChocoCraft Plus items when killed. This does not overwrite their native drops.\n Format is: classPath|chocoItem|dropChance\nclassPath is the mod's address to the entity class.\nchocoItem is the item that is dropped. Allowed values are: Gysahl, Krakka, Tantal, Pasana, Cree, Reagan, Mimett, Sylkis, Pipio, Luchile, Saraha, Lasan, Porov, Param, Carob, Zeio, GysalSeeds, Chocopedia, ChocoSaddle, SaddleBags, PackBags\ndropChance is the chance out of 256 that the mob drops the item. The chance increases with increased looting level.\nYou can enter the same mob multiple times to trigger multiple drops.");
        featherDelayRandom = config.getInt("Molting Delay Random", "domestication", 600, 0, 10000, "The number of ticks between which a tamed chocobo attempts to drop a feather is increased by a random integer from 0 to this value.");
        featherDelayStatic = config.getInt("Molting Delay Static", "domestication", 600, 20, 10000, "Minimum number of ticks between which a tamed chocobo attempts to drop a feather");
        featherDropChance = config.getInt("Feather Drop Chance", "domestication", 5, 0, 100, "Percent of attemps where a tamed chocobo successfully drops a feather");
        penHealProbability = config.getInt("Pen Heal Probability", "domestication", 20, 0, 100, "When in a valid pen: the percent probability, every two seconds, that a chocobo will recover one health.");
        penHealCauldronRange = config.getInt("Pen Cauldron Range", "domestication", 6, 0, 12, "Maximum number of blocks away a filled cauldron can be for a chocobo to heal (while it is standing on straw)");
        chocoSoundFrequency = config.getInt("Choco Idle Sound Frequency", "domestication", 25, 0, 100, "Determines the frequency of occurrence of the idle sounds that the adult chocobo makes as a percentage of typical Minecraft mob sound frequency. Set this to 50 for 50 percent, etc.");
        chicoSoundFrequency = config.getInt("Chico Idle Sound Frequency", "domestication", 50, 0, 100, "Determines the frequency of occurrence of the idle sounds that the chicobo makes as a percentage of typical Minecraft mob sound frequency. Set this to 50 for 50 percent, etc.");
        breedingDelayFemale = config.getInt("Breeding Delay Female", "feeding and breeding", 20000, 0, 100000, "Cool down ticks between when female adults are able to breed");
        breedingDelayMale = config.getInt("Breeding Delay Male", "feeding and breeding", 6000, 0, 100000, "Cool down ticks between when male adults are able to breed");
        growUpDelayStatic = config.getInt("Grow Up Delay Static", "feeding and breeding", 6000, 0, 100000, "Minimum number of ticks until a chicobo grows into an adult chocobo");
        growUpDelayRandom = config.getInt("Grow Up Delay Random", "feeding and breeding", 30000, 0, 100000, "The number of ticks until a chicobo grows into an adult is increased by a random integer from 0 to this value.");
        appetiteChicobo = config.getInt("Chicobo Appetite", "feeding and breeding", 1200, 0, 100000, "How much food a chicobo can eat until it is not hungry");
        appetiteChocobo = config.getInt("Chocobo Appetite", "feeding and breeding", 12000, 0, 100000, "How much food a chocobo can eat until it is not hungry");
        foodBaseCooldown = config.getInt("Food Filling Factor", "feeding and breeding", 120, 0, 1000, "Cooldown associated with feeding a Gysahl Carrot to a chocobo. Higher-tier veggies induce proportionally higher cooldown. Set this to a lower number to be able to feed more to a chocobo in one sitting.");
        allowInbreeding = config.getBoolean("Inbreeding Allowed", "feeding and breeding", false, "If this is false, chocobos will not reproduce with their parents, children, or full- or half-siblings. This makes obtaining higher-tier colors MUCH more involved. There is no drawback to setting this to true, except it's gross.");
        wildCanDespawn = config.getBoolean("Wild Despawn", "wild spawning", false, "Whether wild chocobos will be able to despawn if no player is around.");
        spawnBiomesNames = config.getStringList("Spawn Biome Names", "wild spawning", new String[]{"none.-1", "none.1", "Plains", "Extreme Hills", "Forest", "Taiga", "Swampland", "Ice Plains", "Ice Mountains", "ForestHills", "TaigaHills", "Extreme Hills Edge", "Jungle", "JungleHills", "JungleEdge", "Birch Forest", "Birch Forest Hills", "Roofed Forest", "Cold Taiga", "Cold Taiga Hills", "Mega Taiga", "Mega Taiga Hills", "Extreme Hills+", "Savanna", "Savanna Plateau", "Alps", "Arctic", "Bamboo Forest", "Bayou", "Bog", "Boreal Forest", "Cherry Blossom Grove", "Coniferous Forest", "Snowy Coniferous Forest", "Crag", "Deciduous Forest", "Dense Forest", "Eucalyptus Forest", "Fen", "Flower Field", "Frost Forest", "Fungi Forest", "Garden", "Grassland", "Grove", "Highland", "Jade Cliffs", "Land of Lakes", "Lavender Fields", "Lush Swamp", "Maple Woods", "Marsh", "Meadow", "Moor", "Mountain", "Mystic Grove", "Ominous Woods", "Orchard", "Prairie", "Rainforest", "Redwood Forest", "Sacred Springs", "Seasonal Forest", "Shield", "Steppe", "Temperate Rainforest", "Thicket", "Tropical Rainforest", "Tundra", "Wetland", "Woodland", "Tropics", "Alps Forest", "Land of Lakes Marsh", "Meadow Forest", "Quagmire", "Seasonal Forest Clearing", "Silkglades", "Spruce Woods", "Alpine", "Autumn Woods", "Birch Forest", "Extreme Jungle", "Forested Hills", "Sunflower Plains", "Extreme Hills M", "Flower Forest", "Taiga M", "Swampland M", "Forested Island", "Green Hills", "Green Swamplands", "Ice Plains Spikes", "Rocky Steppe", "Tropical Tundra", "Woodland", "Jungle M", "Meadow", "JungleEdge M", "Mini Jungle", "Birch Forest M", "Birch Forest Hills M", "Roofed Forest M", "Cold Taiga M", "Mountain Taiga", "Mega Spruce Taiga", "Mega Spruce Taiga", "Extreme Hills+ M", "Savanna M", "Savanna Plateau M", "Pine Forest", "Rainforest", "Redwood Forest", "Lush Redwoods", "Savanna", "Snow Forest", "Snowy Rainforest", "Temperate Rainforest", "Tundra", "Woodlands", "Twilight Lake", "Twilight Forest", "Dense Twilight Forest", "Twilight Highlands", "Twilight Swamp", "Snowy Forest", "Twilight Clearing", "Oak Savanna", "Firefly Forest", "Dark Forest Center", "Highlands Center", "Dark Forest", "Enchanted Forest"}, "Comma-separated names of biomes in which Chocobos can spawn. Add the value \"all\" (no quotes) to have Chocobos spawn in all biomes, or \"all.N\" to have them spawn in all biomes in dimension N (use -1, 0, 1 for Nether, Overworld, End; or even a number for a custom dimension). \nPossible Biome names--this list generates only the first time you load ChocoCraft Plus. :\n" + GeneralConfig.getAllBiomeNames() + "\n\n");
        spawnTimeDelay = config.getInt("Spawn Time Delay", "wild spawning", 200, 20, 20000, "Number of ticks between attempted wild chocobo group spawn");
        spawnProbability = config.getInt("Spawn Probability", "wild spawning", 10, 0, 1000, "Frequency of chocobo groups spawning near each player");
        spawnGroupMin = config.getInt("Spawn Group Mininum", "wild spawning", 1, 0, 10, "Minimum number of chocobos that will spawn in a group");
        spawnGroupMax = config.getInt("Spawn Group Maximum", "wild spawning", 3, 0, 10, "Maximum number of chocobos that will spawn in a group");
        spawnTotalMax = config.getInt("Spawn Total Maximum", "wild spawning", 3, 0, 20, "No new chocobos will spawn if there are this many in a specified area (A square with Spawn Limit Block Radius)");
        spawnLimitBlockRadius = config.getInt("Spawn Limit Block Radius", "wild spawning", 300, 1, 1000, "Radius, in blocks, of the area checked to limit new chocobo spawns");
        distanceNextWild = config.getInt("Wild Spawn Distance", "wild spawning", 300, 1, 10000, "Wild chocobo groups are spaced at least this far apart, in blocks");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("chococraftplus")) {
            this.loadConfiguration();
        }
    }

    private static String getAllBiomeNames() {
        String bgbNameList = "";
        Boolean firstName = true;
        for (Biome bgb : ForgeRegistries.BIOMES.getValues()) {
            if (null == bgb) continue;
            if (!firstName.booleanValue()) {
                bgbNameList = bgbNameList + ", ";
            } else {
                firstName = false;
            }
            bgbNameList = bgbNameList + ChocoFunctions.getBiomeName(bgb);
        }
        return bgbNameList;
    }

    public static Object[] unpackMobDrops(String[] inputList) {
        ArrayList<String> entityClassPaths = new ArrayList<String>();
        ArrayList<String> chocoItems = new ArrayList<String>();
        ArrayList<Integer> dropChances = new ArrayList<Integer>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String entityClassPath = "";
            String chocoItem = "";
            int dropChance = -1;
            try {
                entityClassPath = splitEntry[0].trim();
            }
            catch (Exception e) {
                entityClassPath = "";
            }
            try {
                chocoItem = splitEntry[1].trim();
            }
            catch (Exception e) {
                chocoItem = "";
            }
            try {
                dropChance = Integer.parseInt(splitEntry[2].trim());
            }
            catch (Exception e) {
                dropChance = -1;
            }
            if (entityClassPath.equals("") || chocoItem.equals("") || dropChance == -1) continue;
            entityClassPaths.add(entityClassPath);
            chocoItems.add(chocoItem);
            dropChances.add(dropChance);
        }
        return new Object[]{entityClassPaths, chocoItems, dropChances};
    }

    static {
        arrayNutWeights = new int[8];
        arrayVeggieWeights = new int[8];
        gysahlGardenDimensionWhitelist_a = new ArrayList<Integer>();
    }
}

