/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.blocks;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.registry.ChocoCraftItems;
import chococraftplus.common.utils.ChocoFunctions;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGysahlCrop
extends BlockBush {
    static final int MAX_STAGE = 4;
    public PropertyInteger AGE;
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)};

    public BlockGysahlCrop() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        float f = 0.5f;
        this.func_149649_H();
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149663_c("gysahlstemblock");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float cropsize = (float)((Integer)state.func_177229_b((IProperty)this.AGE) + 1) / 8.0f;
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)cropsize, 1.0);
    }

    protected PropertyInteger getAgeProperty() {
        return this.AGE;
    }

    protected BlockStateContainer func_180661_e() {
        if (this.AGE == null) {
            this.AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);
        }
        return new BlockStateContainer((Block)this, new IProperty[]{this.AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.AGE, (Comparable)Integer.valueOf(Math.min(4, meta)));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.AGE);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int i;
        super.func_180650_b(worldIn, pos, state, rand);
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = ((Integer)state.func_177229_b((IProperty)this.AGE)).intValue()) < 4 && rand.nextInt((int)(25.0f / (f = this.getGrowthRate(worldIn, pos))) + 1) == 0) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    private float getGrowthRate(World theWorld, BlockPos pos) {
        float growRate = 1.0f;
        IBlockState stateNorth = theWorld.func_180495_p(pos.func_177978_c());
        IBlockState stateSouth = theWorld.func_180495_p(pos.func_177968_d());
        IBlockState stateWest = theWorld.func_180495_p(pos.func_177976_e());
        IBlockState stateEast = theWorld.func_180495_p(pos.func_177974_f());
        IBlockState stateNW = theWorld.func_180495_p(pos.func_177978_c().func_177976_e());
        IBlockState stateNE = theWorld.func_180495_p(pos.func_177978_c().func_177974_f());
        IBlockState stateSE = theWorld.func_180495_p(pos.func_177968_d().func_177974_f());
        IBlockState stateSW = theWorld.func_180495_p(pos.func_177968_d().func_177976_e());
        boolean samePlantLeftOrRight = stateWest.equals((Object)this) || stateEast.equals((Object)this);
        boolean samePlantFrontOrBack = stateNorth.equals((Object)this) || stateSouth.equals((Object)this);
        boolean samePlantAnyCorner = stateNW.equals((Object)this) || stateNE.equals((Object)this) || stateSE.equals((Object)this) || stateSW.equals((Object)this);
        for (int xTmp = pos.func_177958_n() - 1; xTmp <= pos.func_177958_n() + 1; ++xTmp) {
            for (int zTmp = pos.func_177952_p() - 1; zTmp <= pos.func_177952_p() + 1; ++zTmp) {
                BlockPos nearbyGroundPos = new BlockPos(xTmp, pos.func_177977_b().func_177956_o(), zTmp);
                IBlockState baseBlockState = theWorld.func_180495_p(nearbyGroundPos);
                Block baseBlockId = baseBlockState.func_177230_c();
                float tmpGrowRate = 0.0f;
                if (this.canThisPlantGrowOnThisBlock(baseBlockId)) {
                    tmpGrowRate = 1.0f;
                    if (baseBlockState.func_177230_c().func_176201_c(baseBlockState) > 0) {
                        tmpGrowRate = 3.0f;
                    }
                }
                if (xTmp != pos.func_177958_n() || zTmp != pos.func_177952_p()) {
                    tmpGrowRate /= 4.0f;
                }
                growRate += tmpGrowRate;
            }
        }
        if (samePlantAnyCorner || samePlantLeftOrRight && samePlantFrontOrBack) {
            growRate /= 2.0f;
        }
        return growRate;
    }

    protected boolean canThisPlantGrowOnThisBlock(Block block) {
        return block.equals(Blocks.field_150458_ak);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(world, pos, state, chance, 0);
        if (!world.field_72995_K) {
            int j1 = 3 + fortune;
            for (int k1 = 0; k1 < j1; ++k1) {
                if (world.field_73012_v.nextInt(15) > state.func_177230_c().func_176201_c(state)) continue;
                float f1 = 0.7f;
                float xOffset = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                float yOffset = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                float zOffset = world.field_73012_v.nextFloat() * f1 + (1.0f - f1) * 0.5f;
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(ChocoCraftItems.GYSAHL_GARDEN_SEEDS));
                entityitem.func_174869_p();
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public Item func_180660_a(IBlockState blockstate, Random random, int fortune) {
        return BlockGysahlCrop.randomVeggieOrNut(blockstate.func_177230_c().func_176201_c(blockstate), random, fortune);
    }

    public boolean onBonemealUse(World theWorld, BlockPos pos) {
        IBlockState blockstate = theWorld.func_180495_p(pos);
        if (blockstate.func_177230_c().func_176201_c(blockstate) < 4) {
            theWorld.func_180501_a(pos, blockstate.func_177226_a((IProperty)this.AGE, (Comparable)Integer.valueOf(4)), 2);
            return true;
        }
        return false;
    }

    public static Item randomVeggieOrNut(int meta, Random random, int j) {
        if (meta >= 4) {
            if (random.nextInt(1000) < GeneralConfig.wildPlantDropNut) {
                int[] weights = GeneralConfig.arrayNutWeights;
                int rank = ChocoFunctions.weightedRandom(weights, random);
                if (rank == 0) {
                    return ChocoCraftItems.PIPIO_NUT;
                }
                if (rank == 1) {
                    return ChocoCraftItems.LUCHILE_NUT;
                }
                if (rank == 2) {
                    return ChocoCraftItems.SARAHA_BEAN;
                }
                if (rank == 3) {
                    return ChocoCraftItems.LASAN_NUT;
                }
                if (rank == 4) {
                    return ChocoCraftItems.POROV_BEAN;
                }
                if (rank == 5) {
                    return ChocoCraftItems.PARAM_NUT;
                }
                if (rank == 6) {
                    return ChocoCraftItems.CAROB_NUT;
                }
                if (rank == 7) {
                    return ChocoCraftItems.ZEIO_NUT;
                }
            } else {
                int[] weights = GeneralConfig.arrayVeggieWeights;
                int rank = ChocoFunctions.weightedRandom(weights, random);
                if (rank == 0) {
                    return ChocoCraftItems.GYSAHL_CARROT;
                }
                if (rank == 1) {
                    return ChocoCraftItems.KRAKKA_ROOT;
                }
                if (rank == 2) {
                    return ChocoCraftItems.TANTAL_VEGGIE;
                }
                if (rank == 3) {
                    return ChocoCraftItems.PASANA_FRUIT;
                }
                if (rank == 4) {
                    return ChocoCraftItems.CREE_ROOT;
                }
                if (rank == 5) {
                    return ChocoCraftItems.MIMETT_FRUIT;
                }
                if (rank == 6) {
                    return ChocoCraftItems.REAGAN_VEGGIE;
                }
                if (rank == 7) {
                    return ChocoCraftItems.SYLKIS_BUD;
                }
            }
            return ChocoCraftItems.GYSAHL_GARDEN_SEEDS;
        }
        return null;
    }
}

