/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.letsleepingdogslie.common.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import me.ichun.letsleepingdogslie.common.LetSleepingDogsLie;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class TickHandlerClient {
    public Random rand = new Random();
    public int worldLoadCooldown = 0;
    public WeakHashMap<EntityWolf, WolfInfo> wolfInfo = new WeakHashMap();

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityWolf wolf;
        if (event.getWorld().field_72995_K && event.getEntity() instanceof EntityWolf && !this.wolfInfo.containsKey(wolf = (EntityWolf)event.getEntity())) {
            this.wolfInfo.put(wolf, new WolfInfo(LetSleepingDogsLie.dogsSpawnLying && this.worldLoadCooldown > 0));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            --this.worldLoadCooldown;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                this.wolfInfo.entrySet().removeIf(e -> !((WolfInfo)e.getValue()).tick((EntityWolf)e.getKey()));
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        Minecraft.func_71410_x().func_152344_a(this::clean);
    }

    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Minecraft.func_71410_x().func_152344_a(this::clean);
    }

    public void clean() {
        this.wolfInfo.clear();
        this.worldLoadCooldown = 20;
    }

    public WolfInfo getWolfInfo(EntityWolf wolf) {
        if (this.wolfInfo.containsKey(wolf)) {
            return this.wolfInfo.get(wolf);
        }
        WolfInfo info = new WolfInfo(LetSleepingDogsLie.dogsSpawnLying && this.worldLoadCooldown > 0);
        this.wolfInfo.put(wolf, info);
        return info;
    }

    public class WolfInfo {
        public int sitTime;
        public String[] setPoses = null;

        public WolfInfo(boolean lying) {
            this.sitTime = lying ? LetSleepingDogsLie.timeBeforeLie : 0;
        }

        public boolean tick(EntityWolf parent) {
            if (parent.field_70128_L) {
                return false;
            }
            if (parent.func_70906_o()) {
                List ents;
                boolean isLying = this.isLying();
                ++this.sitTime;
                if (!isLying && this.isLying() && TickHandlerClient.this.worldLoadCooldown < 0) {
                    parent.func_130014_f_().func_184134_a(parent.field_70165_t, parent.field_70163_u + (double)parent.func_70047_e(), parent.field_70161_v, SoundEvents.field_187871_gL, parent.func_184176_by(), 0.4f, parent.func_70631_g_() ? (parent.func_70681_au().nextFloat() - parent.func_70681_au().nextFloat()) * 0.2f + 1.5f : (parent.func_70681_au().nextFloat() - parent.func_70681_au().nextFloat()) * 0.2f + 1.0f, false);
                }
                if (parent.field_70173_aa % 10 == 0 && LetSleepingDogsLie.getsUpTo > 0 && LetSleepingDogsLie.rangeBeforeGettingUp > 0.1f && (ents = parent.func_130014_f_().func_72839_b((Entity)parent, parent.func_174813_aQ().func_186662_g((double)LetSleepingDogsLie.rangeBeforeGettingUp))).stream().anyMatch(entity -> (LetSleepingDogsLie.getsUpTo == 1 && entity instanceof EntityLivingBase && parent.func_152114_e((EntityLivingBase)entity) || LetSleepingDogsLie.getsUpTo == 2 && entity instanceof EntityPlayer && !((EntityPlayer)entity).func_175149_v() || LetSleepingDogsLie.getsUpTo == 3 && entity instanceof EntityLivingBase && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175149_v())) && parent.func_70685_l(entity))) {
                    if (isLying) {
                        parent.func_130014_f_().func_184134_a(parent.field_70165_t, parent.field_70163_u + (double)parent.func_70047_e(), parent.field_70161_v, SoundEvents.field_187857_gE, parent.func_184176_by(), 0.4f, parent.func_70631_g_() ? (parent.func_70681_au().nextFloat() - parent.func_70681_au().nextFloat()) * 0.2f + 1.5f : (parent.func_70681_au().nextFloat() - parent.func_70681_au().nextFloat()) * 0.2f + 1.0f, false);
                    }
                    this.sitTime = 0;
                    this.setPoses = null;
                }
            } else {
                this.sitTime = 0;
                this.setPoses = null;
            }
            return true;
        }

        public boolean isLying() {
            return this.sitTime > LetSleepingDogsLie.timeBeforeLie;
        }

        public String[] getCompatiblePoses(EntityWolf parent) {
            if (this.setPoses == null) {
                String[] poses = new String[2];
                ArrayList<String> front = new ArrayList<String>();
                ArrayList<String> rear = new ArrayList<String>();
                for (String s : LetSleepingDogsLie.enabledPoses) {
                    if (s.startsWith("foreleg") && (!parent.func_70631_g_() || s.equalsIgnoreCase("forelegSprawledBack") || s.equalsIgnoreCase("forelegSide"))) {
                        front.add(s);
                    }
                    if (!s.startsWith("hindleg")) continue;
                    rear.add(s);
                }
                if (front.isEmpty()) {
                    if (!parent.func_70631_g_()) {
                        front.add("forelegStraight");
                        front.add("forelegSprawled");
                        front.add("forelegSkewed");
                    }
                    front.add("forelegSprawledBack");
                    front.add("forelegSide");
                }
                if (rear.isEmpty()) {
                    rear.add("hindlegStraight");
                    rear.add("hindlegStraightBack");
                    rear.add("hindlegSprawled");
                    rear.add("hindlegSprawledBack");
                    rear.add("hindlegSide");
                }
                if (TickHandlerClient.this.rand.nextBoolean()) {
                    poses[0] = (String)front.get(TickHandlerClient.this.rand.nextInt(front.size()));
                    poses[1] = (String)rear.get(TickHandlerClient.this.rand.nextInt(rear.size()));
                } else {
                    poses[1] = (String)rear.get(TickHandlerClient.this.rand.nextInt(rear.size()));
                    poses[0] = (String)front.get(TickHandlerClient.this.rand.nextInt(front.size()));
                }
                if (poses[0].endsWith("Side") && poses[1].endsWith("Side")) {
                    String side = TickHandlerClient.this.rand.nextBoolean() ? "L" : "R";
                    poses[0] = poses[0] + side;
                    poses[1] = poses[1] + side;
                } else {
                    if (poses[0].endsWith("Side") || poses[0].endsWith("Skewed")) {
                        poses[0] = poses[0] + (TickHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                    if (poses[1].endsWith("Side")) {
                        poses[1] = poses[1] + (TickHandlerClient.this.rand.nextBoolean() ? "L" : "R");
                    }
                }
                this.setPoses = poses;
            }
            return this.setPoses;
        }
    }
}

