/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.rifts.targets.IEntityTarget;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;

public class PocketEntranceMarker
extends VirtualTarget
implements IEntityTarget {
    protected float weight;
    protected VirtualTarget ifDestination;
    protected VirtualTarget otherwiseDestination;

    public PocketEntranceMarker() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.ifDestination = nbt.func_74764_b("ifDestination") ? VirtualTarget.readVirtualTargetNBT(nbt.func_74775_l("ifDestination")) : null;
        this.otherwiseDestination = nbt.func_74764_b("otherwiseDestination") ? VirtualTarget.readVirtualTargetNBT(nbt.func_74775_l("otherwiseDestination")) : null;
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        if (this.ifDestination != null) {
            nbt.func_74782_a("ifDestination", (NBTBase)this.ifDestination.writeToNBT(new NBTTagCompound()));
        }
        if (this.otherwiseDestination != null) {
            nbt.func_74782_a("otherwiseDestination", (NBTBase)this.otherwiseDestination.writeToNBT(new NBTTagCompound()));
        }
        return NBTUtils.writeToNBT(this, nbt);
    }

    @Override
    public boolean receiveEntity(Entity entity, float relativeYaw, float relativePitch) {
        DimDoors.chat(entity, "The entrance of this dungeon has not been converted. If this is a normally generated pocket, please report this bug.", new Object[0]);
        return false;
    }

    private static float $default$weight() {
        return 1.0f;
    }

    public static PocketEntranceMarkerBuilder builder() {
        return new PocketEntranceMarkerBuilder();
    }

    public PocketEntranceMarkerBuilder toBuilder() {
        return new PocketEntranceMarkerBuilder().weight(this.weight).ifDestination(this.ifDestination).otherwiseDestination(this.otherwiseDestination);
    }

    public float getWeight() {
        return this.weight;
    }

    public VirtualTarget getIfDestination() {
        return this.ifDestination;
    }

    public VirtualTarget getOtherwiseDestination() {
        return this.otherwiseDestination;
    }

    public PocketEntranceMarker(float weight, VirtualTarget ifDestination, VirtualTarget otherwiseDestination) {
        this.weight = weight;
        this.ifDestination = ifDestination;
        this.otherwiseDestination = otherwiseDestination;
    }

    @Override
    public String toString() {
        return "PocketEntranceMarker(weight=" + this.getWeight() + ", ifDestination=" + this.getIfDestination() + ", otherwiseDestination=" + this.getOtherwiseDestination() + ")";
    }

    public static class PocketEntranceMarkerBuilder {
        private boolean weight$set;
        private float weight;
        private VirtualTarget ifDestination;
        private VirtualTarget otherwiseDestination;

        PocketEntranceMarkerBuilder() {
        }

        public PocketEntranceMarkerBuilder weight(float weight) {
            this.weight = weight;
            this.weight$set = true;
            return this;
        }

        public PocketEntranceMarkerBuilder ifDestination(VirtualTarget ifDestination) {
            this.ifDestination = ifDestination;
            return this;
        }

        public PocketEntranceMarkerBuilder otherwiseDestination(VirtualTarget otherwiseDestination) {
            this.otherwiseDestination = otherwiseDestination;
            return this;
        }

        public PocketEntranceMarker build() {
            float weight = this.weight;
            if (!this.weight$set) {
                weight = PocketEntranceMarker.$default$weight();
            }
            return new PocketEntranceMarker(weight, this.ifDestination, this.otherwiseDestination);
        }

        public String toString() {
            return "PocketEntranceMarker.PocketEntranceMarkerBuilder(weight=" + this.weight + ", ifDestination=" + this.ifDestination + ", otherwiseDestination=" + this.otherwiseDestination + ")";
        }
    }
}

