/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.client.ModelMonolith;
import org.dimdev.dimdoors.shared.entities.EntityMonolith;

@SideOnly(value=Side.CLIENT)
public class RenderMonolith
extends RenderLiving<EntityMonolith> {
    protected static final List<ResourceLocation> MONOLITH_TEXTURES = Arrays.asList(new ResourceLocation("dimdoors:textures/mobs/monolith/monolith0.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith1.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith2.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith3.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith4.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith5.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith6.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith7.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith8.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith9.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith10.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith11.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith12.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith13.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith14.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith15.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith16.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith17.png"), new ResourceLocation("dimdoors:textures/mobs/monolith/monolith18.png"));

    public RenderMonolith(RenderManager manager, float f) {
        super(manager, (ModelBase)new ModelMonolith(), f);
    }

    public void doRender(EntityMonolith monolith, double x, double y, double z, float entityYaw, float partialTicks) {
        float minScaling = 0.0f;
        float maxScaling = 0.1f;
        float jitterScale = 0.0f;
        if (monolith.isDangerous()) {
            jitterScale = 0.0f + 0.1f * monolith.getAggroProgress();
        }
        float time = (float)((Minecraft.func_71386_F() + (long)(-249346712 * monolith.func_145782_y())) % 200000L) / 50.0f;
        double xJitter = (double)jitterScale * Math.sin(1.1f * time) * Math.sin(0.8f * time);
        double yJitter = (double)jitterScale * Math.sin(1.2f * time) * Math.sin(0.9f * time);
        double zJitter = (double)jitterScale * Math.sin(1.3f * time) * Math.sin(0.7f * time);
        this.render(monolith, x + xJitter, y + yJitter, z + zJitter, entityYaw, partialTicks);
    }

    public void render(EntityMonolith monolith, double x, double y, double z, float entityYaw, float partialTicks) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((EntityLivingBase)monolith, (RenderLivingBase)this, 1.0f, x, y, z))) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.field_77045_g.field_78095_p = this.func_77040_d((EntityLivingBase)monolith, partialTicks);
        try {
            float interpolatedYaw = this.func_77034_a(monolith.field_70760_ar, monolith.field_70761_aq, partialTicks);
            float pitch = monolith.field_70127_C + (monolith.field_70125_A - monolith.field_70127_C) * partialTicks;
            this.func_77039_a((EntityLivingBase)monolith, x, y, z);
            float rotation = this.func_77044_a((EntityLivingBase)monolith, partialTicks);
            this.func_77043_a((EntityLivingBase)monolith, rotation, interpolatedYaw, partialTicks);
            float scaleFactor = 0.0625f;
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.func_77041_b((EntityLivingBase)monolith, partialTicks);
            GlStateManager.func_179114_b((float)monolith.pitchLevel, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scaleFactor - 0.0078125f), (float)0.0f);
            this.func_77036_a((EntityLivingBase)monolith, 0.0f, 0.0f, rotation, interpolatedYaw, pitch, scaleFactor);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179101_C();
        }
        catch (Exception e) {
            DimDoors.log.error("Couldn't render entity", (Throwable)e);
        }
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((EntityLivingBase)monolith, (RenderLivingBase)this, 1.0f, x, y, z));
    }

    protected ResourceLocation getEntityTexture(EntityMonolith monolith) {
        return MONOLITH_TEXTURES.get(monolith.getTextureState());
    }
}

