/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.tileentity;

import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TrapHelper {
    public static final int NBT_TYPE_PRIMITIVE = 99;
    public static final int NBT_TYPE_STRING = new NBTTagString().func_74732_a();
    private static final String TAG_POTION_COLOR = "CustomPotionColor";

    public static boolean isValidPlayerInRange(World world, BlockPos pos, double range, boolean checkSight, boolean requireVulnerable) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        double rangeSq = range * range;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            if (!TrapHelper.isValidTarget((Entity)player, requireVulnerable) || !(player.func_70092_e(x, y, z) <= rangeSq) || checkSight && !TrapHelper.canEntitySeeBlock(world, pos, (Entity)player)) continue;
            return true;
        }
        return false;
    }

    public static EntityPlayer getNearestValidPlayerInRange(World world, BlockPos pos, double range, boolean checkSight, boolean requireVulnerable) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        double rangeSq = range * range;
        EntityPlayer closestPlayer = null;
        double closestDistSq = Double.POSITIVE_INFINITY;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            double distSq = player.func_70092_e(x, y, z);
            if (!TrapHelper.isValidTarget((Entity)player, requireVulnerable) || !(distSq <= rangeSq) || !(distSq < closestDistSq) || checkSight && !TrapHelper.canEntitySeeBlock(world, pos, (Entity)player)) continue;
            closestPlayer = player;
            closestDistSq = distSq;
        }
        return closestPlayer;
    }

    public static boolean isValidTarget(Entity entity, boolean requireVulnerable) {
        return requireVulnerable ? EntitySelectors.field_188444_d.apply((Object)entity) : EntitySelectors.field_180132_d.apply((Object)entity);
    }

    public static boolean canEntitySeeBlock(World world, BlockPos pos, Entity entity) {
        RayTraceResult result = world.func_147447_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), false, true, false);
        return result == null || result.func_178782_a() != null && (result.func_178782_a().equals((Object)pos) || result.func_178782_a().equals((Object)pos.func_177982_a(0, 1, 0)));
    }

    public static boolean isAnySideOpen(World world, BlockPos position) {
        return world.func_175623_d(position.func_177982_a(-1, 0, 0)) || world.func_175623_d(position.func_177982_a(1, 0, 0)) || world.func_175623_d(position.func_177982_a(0, 0, -1)) || world.func_175623_d(position.func_177982_a(0, 0, 1));
    }

    public static void setPotionColorFromEffects(ItemStack potionStack) {
        NBTTagCompound tag = potionStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            potionStack.func_77982_d(tag);
        }
        tag.func_74768_a(TAG_POTION_COLOR, PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)potionStack)));
    }

    private TrapHelper() {
    }
}

