/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.tileentity;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class TileEntityTowerDispenser
extends TileEntity
implements ITickable {
    private static final String TAG_ACTIVATION_RANGE = "ActivationRange";
    private static final String TAG_CHECK_SIGHT = "CheckSight";
    private static final String TAG_DAMAGE = "Damage";
    private static final String TAG_DELAY_MIN = "DelayMin";
    private static final String TAG_DELAY_MAX = "DelayMax";
    private static final String TAG_TYPE_DATA = "TypeData";
    private static final String TAG_DELAY = "Delay";
    private float activationRange;
    private boolean checkSight;
    private NBTTagCompound typeData;
    private float attackDamage;
    private int minAttackDelay;
    private int maxAttackDelay;
    private boolean activated;
    private int activationDelay;
    private int attackDelay = 10;

    public NBTTagCompound getOrCreateTypeData() {
        if (this.typeData == null) {
            this.typeData = new NBTTagCompound();
        }
        return this.typeData;
    }

    public void initializeTowerTrap(EnumTowerType towerType, Config dimConfig, Random random) {
        Config.FeatureTower towerConfig = towerType.getFeatureConfig(dimConfig);
        this.activationRange = towerConfig.ACTIVATION_RANGE;
        this.checkSight = towerConfig.CHECK_SIGHT;
        this.attackDamage = towerConfig.ATTACK_DAMAGE;
        this.minAttackDelay = towerConfig.DELAY_MIN;
        this.maxAttackDelay = towerConfig.DELAY_MAX;
    }

    private EnumTowerType getTowerType() {
        IBlockState block;
        if (this.field_174879_c != null && this.field_145850_b != null && (block = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == ModObjects.TOWER_DISPENSER) {
            return (EnumTowerType)((Object)block.func_177229_b(EnumTowerType.PROPERTY));
        }
        return EnumTowerType.DEFAULT;
    }

    public void func_73660_a() {
        if (this.activationDelay > 0) {
            --this.activationDelay;
        } else {
            this.activationDelay = 4;
            this.activated = TrapHelper.isValidPlayerInRange(this.field_145850_b, this.field_174879_c, this.activationRange, false, false);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.activated) {
                double zPos;
                double xPos;
                double yPos = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
                float faceOffset = 1.0625f;
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    faceOffset = 1.0f - faceOffset;
                }
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    xPos = (float)this.field_174879_c.func_177958_n() + faceOffset;
                    zPos = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
                } else {
                    xPos = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
                    zPos = (float)this.field_174879_c.func_177952_p() + faceOffset;
                }
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, xPos, yPos, zPos, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (this.activated) {
            if (this.attackDelay < 0) {
                this.resetTimer();
            }
            if (this.attackDelay > 0) {
                --this.attackDelay;
            } else {
                EntityPlayer target = TrapHelper.getNearestValidPlayerInRange(this.field_145850_b, this.field_174879_c, this.activationRange, this.checkSight, false);
                if (target == null) {
                    this.attackDelay = 6 + this.field_145850_b.field_73012_v.nextInt(8);
                } else {
                    this.attack(target);
                }
            }
        }
    }

    private void attack(EntityPlayer target) {
        this.resetTimer();
        Config dimConfig = Config.getOrDefault(this.field_145850_b);
        EnumTowerType towerType = this.getTowerType();
        Vec3d centerPos = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
        Vec3d targetPos = new Vec3d(target.field_70165_t, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f), target.field_70161_v);
        Vec3d vecToTarget = targetPos.func_178788_d(centerPos);
        if (Math.abs(vecToTarget.field_72450_a) < 0.5 && Math.abs(vecToTarget.field_72449_c) < 0.5) {
            return;
        }
        double distanceH = Math.sqrt(vecToTarget.field_72450_a * vecToTarget.field_72450_a + vecToTarget.field_72449_c * vecToTarget.field_72449_c);
        Vec3d offset = Math.abs(vecToTarget.field_72450_a) < Math.abs(vecToTarget.field_72449_c) ? new Vec3d(vecToTarget.field_72450_a / distanceH, 0.0, vecToTarget.field_72449_c < 0.0 ? -1.0 : 1.0) : (Math.abs(vecToTarget.field_72450_a) > Math.abs(vecToTarget.field_72449_c) ? new Vec3d(vecToTarget.field_72450_a < 0.0 ? -1.0 : 1.0, 0.0, vecToTarget.field_72449_c / distanceH) : new Vec3d(vecToTarget.field_72450_a < 0.0 ? -1.0 : 1.0, 0.0, vecToTarget.field_72449_c < 0.0 ? -1.0 : 1.0));
        towerType.triggerAttack(dimConfig, this, target, centerPos, offset, vecToTarget, distanceH);
        this.field_145850_b.func_184148_a(null, centerPos.field_72450_a, centerPos.field_72448_b, centerPos.field_72449_c, SoundEvents.field_187578_au, SoundCategory.BLOCKS, 1.0f, 1.0f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
    }

    public void shootArrow(Vec3d center, Vec3d offset, Vec3d vecToTarget, double distanceH, float velocity, float variance, EntityArrow arrow) {
        double spawnOffset = 0.6;
        arrow.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
        arrow.func_70239_b((double)(this.attackDamage / velocity));
        arrow.func_70012_b(center.field_72450_a + offset.field_72450_a * 0.6, center.field_72448_b, center.field_72449_c + offset.field_72449_c * 0.6, 0.0f, 0.0f);
        arrow.func_70186_c(vecToTarget.field_72450_a, vecToTarget.field_72448_b + distanceH * (double)0.2f, vecToTarget.field_72449_c, velocity, variance);
        this.field_145850_b.func_72838_d((Entity)arrow);
    }

    private void resetTimer() {
        if (!this.field_145850_b.field_72995_K) {
            this.attackDelay = this.maxAttackDelay <= this.minAttackDelay ? this.minAttackDelay : this.minAttackDelay + this.field_145850_b.field_73012_v.nextInt(this.maxAttackDelay - this.minAttackDelay);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74776_a(TAG_ACTIVATION_RANGE, this.activationRange);
        tag.func_74757_a(TAG_CHECK_SIGHT, this.checkSight);
        tag.func_74776_a(TAG_DAMAGE, this.attackDamage);
        tag.func_74768_a(TAG_DELAY_MIN, this.minAttackDelay);
        tag.func_74768_a(TAG_DELAY_MAX, this.maxAttackDelay);
        if (this.typeData != null) {
            tag.func_74782_a(TAG_TYPE_DATA, (NBTBase)this.typeData);
        }
        tag.func_74768_a(TAG_DELAY, this.attackDelay);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b(TAG_ACTIVATION_RANGE, 99)) {
            this.activationRange = tag.func_74760_g(TAG_ACTIVATION_RANGE);
        }
        if (tag.func_150297_b(TAG_CHECK_SIGHT, 99)) {
            this.checkSight = tag.func_74767_n(TAG_CHECK_SIGHT);
        }
        if (tag.func_150297_b(TAG_DAMAGE, 99)) {
            this.attackDamage = tag.func_74760_g(TAG_DAMAGE);
        }
        if (tag.func_150297_b(TAG_DELAY_MIN, 99)) {
            this.minAttackDelay = tag.func_74762_e(TAG_DELAY_MIN);
        }
        if (tag.func_150297_b(TAG_DELAY_MAX, 99)) {
            this.maxAttackDelay = tag.func_74762_e(TAG_DELAY_MAX);
        }
        this.typeData = tag.func_150297_b(TAG_TYPE_DATA, (int)tag.func_74732_a()) ? tag.func_74775_l(TAG_TYPE_DATA) : null;
        if (tag.func_150297_b(TAG_DELAY, 99)) {
            this.attackDelay = tag.func_74762_e(TAG_DELAY);
        }
    }

    public boolean func_183000_F() {
        return true;
    }
}

