/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.tileentity;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class TileEntityFloorTrap
extends TileEntity
implements ITickable {
    private static final int TO_TRIGGER_DELAY = 10;
    private static final String TAG_ACTIVATION_RANGE = "ActivationRange";
    private static final String TAG_CHECK_SIGHT = "CheckSight";
    private static final String TAG_TYPE_DATA = "TypeData";
    private static final String TAG_DELAY = "Delay";
    private float activationRange;
    private boolean checkSight;
    private NBTTagCompound typeData;
    private int triggerDelay = -1;

    public void resetTrap() {
        this.triggerDelay = -1;
    }

    public void tripTrap() {
        this.triggerDelay = 0;
    }

    public void tripTrapRandom() {
        this.triggerDelay = this.field_145850_b.field_73012_v.nextInt(10);
    }

    public void disableTrap(int duration) {
        this.triggerDelay = -1 - duration;
    }

    public void disableTrap() {
        this.triggerDelay = 10;
    }

    public NBTTagCompound getOrCreateTypeData() {
        if (this.typeData == null) {
            this.typeData = new NBTTagCompound();
        }
        return this.typeData;
    }

    public void initializeFloorTrap(EnumFloorTrapType trapType, Config dimConfig, Random random) {
        Config.FeatureFloorTrap trapConfig = trapType.getFeatureConfig(dimConfig);
        this.activationRange = trapConfig.ACTIVATION_RANGE;
        this.checkSight = trapConfig.CHECK_SIGHT;
    }

    private EnumFloorTrapType getTrapType() {
        IBlockState block;
        if (this.field_174879_c != null && this.field_145850_b != null && (block = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == ModObjects.FLOOR_TRAP) {
            return (EnumFloorTrapType)((Object)block.func_177229_b(EnumFloorTrapType.PROPERTY));
        }
        return EnumFloorTrapType.TNT;
    }

    public EntityPlayer getTarget() {
        return TrapHelper.getNearestValidPlayerInRange(this.field_145850_b, this.field_174879_c.func_177984_a(), this.activationRange, this.checkSight, true);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.triggerDelay == -1) {
                if (TrapHelper.isValidPlayerInRange(this.field_145850_b, this.field_174879_c.func_177984_a(), this.activationRange, this.checkSight, true)) {
                    this.tripTrap();
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                ++this.triggerDelay;
                if (this.triggerDelay == 10) {
                    this.triggerTrap();
                }
            }
        }
    }

    private void triggerTrap() {
        Config dimConfig = Config.getOrDefault(this.field_145850_b);
        EnumFloorTrapType trapType = this.getTrapType();
        trapType.triggerTrap(dimConfig, this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74776_a(TAG_ACTIVATION_RANGE, this.activationRange);
        tag.func_74757_a(TAG_CHECK_SIGHT, this.checkSight);
        if (this.typeData != null) {
            tag.func_74782_a(TAG_TYPE_DATA, (NBTBase)this.typeData);
        }
        tag.func_74768_a(TAG_DELAY, this.triggerDelay);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b(TAG_ACTIVATION_RANGE, 99)) {
            this.activationRange = tag.func_74760_g(TAG_ACTIVATION_RANGE);
        }
        if (tag.func_150297_b(TAG_CHECK_SIGHT, 99)) {
            this.checkSight = tag.func_74767_n(TAG_CHECK_SIGHT);
        }
        this.typeData = tag.func_150297_b(TAG_TYPE_DATA, (int)tag.func_74732_a()) ? tag.func_74775_l(TAG_TYPE_DATA) : null;
        if (tag.func_150297_b(TAG_DELAY, 99)) {
            this.triggerDelay = tag.func_74762_e(TAG_DELAY);
        }
    }

    public boolean func_183000_F() {
        return true;
    }
}

