/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.tileentity;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.WeightedRandomConfig;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDeadlySpawner
extends TileEntity
implements ITickable {
    private static final int EVENT_TIMER_RESET = 1;
    private static final String TAG_DYNAMIC_SPAWN_LIST = "DynamicSpawnList";
    private static final String TAG_ACTIVATION_RANGE = "ActivationRange";
    private static final String TAG_CHECK_SIGHT = "CheckSight";
    private static final String TAG_DELAY_MIN = "DelayMin";
    private static final String TAG_DELAY_MAX = "DelayMax";
    private static final String TAG_DELAY_PROGRESSIVE = "DelayProgressive";
    private static final String TAG_SPAWN_COUNT = "SpawnCount";
    private static final String TAG_SPAWN_RANGE = "SpawnRange";
    private static final String TAG_SPAWN_ENTITY = "SpawnEntity";
    private static final String TAG_DELAY = "Delay";
    private static final String TAG_DELAY_BUILDUP = "DelayBuildup";
    private WeightedRandomConfig dynamicSpawnList;
    private float activationRange;
    private boolean checkSight;
    private int minSpawnDelay;
    private int maxSpawnDelay;
    private int progressiveSpawnDelay;
    private int spawnCount;
    private float spawnRange;
    private Class<? extends Entity> entityToSpawn = EntityPig.class;
    private boolean activated;
    private int activationDelay;
    private int spawnDelay = 10;
    private double spawnDelayBuildup;
    private Entity cachedEntity;
    private double mobRotation;
    private double prevMobRotation;

    public void initializeSpawner(EnumSpawnerType spawnerType, Config dimConfig, Random random) {
        Config.FeatureSpawner spawnerConfig = spawnerType.getFeatureConfig(dimConfig);
        this.dynamicSpawnList = random.nextFloat() < spawnerConfig.DYNAMIC_CHANCE ? spawnerConfig.SPAWN_LIST : null;
        this.activationRange = spawnerConfig.ACTIVATION_RANGE;
        this.checkSight = spawnerConfig.CHECK_SIGHT;
        this.minSpawnDelay = spawnerConfig.DELAY_MIN;
        this.maxSpawnDelay = spawnerConfig.DELAY_MAX;
        this.progressiveSpawnDelay = spawnerConfig.DELAY_PROGRESSIVE;
        this.spawnCount = spawnerConfig.SPAWN_COUNT;
        this.spawnRange = spawnerConfig.SPAWN_RANGE;
        this.setEntityToSpawn(spawnerConfig.SPAWN_LIST.nextItem(random));
    }

    private void setEntityToSpawn(ResourceLocation registryName) {
        this.entityToSpawn = EntityList.getClass((ResourceLocation)registryName);
        if (this.entityToSpawn == null) {
            DeadlyWorldMod.log().warn("Spawner received non-registered entity name '{}' - This is probably caused by an error or change in the config for DIM_{} (expect to see pig spawners)", (Object)registryName, (Object)this.field_145850_b.field_73011_w.getDimension());
            this.entityToSpawn = EntityPig.class;
        }
        this.cachedEntity = null;
    }

    private EnumSpawnerType getSpawnerType() {
        IBlockState block;
        if (this.field_174879_c != null && this.field_145850_b != null && (block = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == ModObjects.DEADLY_SPAWNER) {
            return (EnumSpawnerType)((Object)block.func_177229_b(EnumSpawnerType.PROPERTY));
        }
        return EnumSpawnerType.DEFAULT;
    }

    public void func_73660_a() {
        if (this.activationDelay > 0) {
            --this.activationDelay;
        } else {
            this.activationDelay = 4;
            this.activated = TrapHelper.isValidPlayerInRange(this.field_145850_b, this.field_174879_c, this.activationRange, false, false);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.activated) {
                double xPos = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
                double yPos = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
                double zPos = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, xPos, yPos, zPos, 0.0, 0.0, 0.0, new int[0]);
                this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, xPos, yPos, zPos, 0.0, 0.0, 0.0, new int[0]);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.prevMobRotation = this.mobRotation;
                this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            }
        } else if (this.activated) {
            if (this.spawnDelay < 0) {
                this.resetTimer(false);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else if (this.checkSight && !TrapHelper.isValidPlayerInRange(this.field_145850_b, this.field_174879_c, this.activationRange, true, false)) {
                this.spawnDelay = 6 + this.field_145850_b.field_73012_v.nextInt(10);
            } else {
                this.doSpawn();
            }
        } else if (this.spawnDelayBuildup > (double)this.minSpawnDelay) {
            this.spawnDelayBuildup -= (double)this.progressiveSpawnDelay * Config.get().GENERAL.PROGRESSIVE_RECOVERY;
        }
    }

    private void doSpawn() {
        Config dimConfig = Config.getOrDefault(this.field_145850_b);
        EnumSpawnerType spawnerType = this.getSpawnerType();
        DifficultyInstance difficultyInstance = this.field_145850_b.func_175649_E(this.field_174879_c);
        boolean success = false;
        for (int i = 0; i < this.spawnCount; ++i) {
            Entity entity;
            double xSpawn = (double)this.field_174879_c.func_177958_n() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.spawnRange;
            double ySpawn = this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3) - 1;
            double zSpawn = (double)this.field_174879_c.func_177952_p() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)this.spawnRange;
            try {
                entity = this.entityToSpawn.getConstructor(World.class).newInstance(this.field_145850_b);
            }
            catch (Exception ex) {
                DeadlyWorldMod.log().error("Encountered exception while constructing entity '{}'", this.entityToSpawn, (Object)ex);
                break;
            }
            int nearbyEntities = this.field_145850_b.func_72872_a(entity.getClass(), new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
            if (nearbyEntities >= this.spawnCount * 2) break;
            entity.func_70012_b(xSpawn, ySpawn, zSpawn, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof EntityLiving) {
                EntityLiving entityLiving = (EntityLiving)entity;
                if (!this.canSpawnNearLocation(entityLiving, xSpawn, ySpawn, zSpawn)) continue;
                entityLiving.func_180482_a(difficultyInstance, null);
                spawnerType.initializeEntity(entityLiving, dimConfig, this.field_145850_b, this.field_174879_c);
            }
            this.field_145850_b.func_72838_d(entity);
            this.field_145850_b.func_175718_b(2004, this.field_174879_c, 0);
            success = true;
            if (!(entity instanceof EntityLiving)) continue;
            ((EntityLiving)entity).func_70656_aK();
        }
        this.resetTimer(success);
    }

    private boolean canSpawnNearLocation(EntityLiving entity, double x, double y, double z) {
        return entity.func_70058_J() || this.trySpawnOffsets(entity, x, y, z, EnumFacing.UP, EnumFacing.DOWN) || this.trySpawnOffsets(entity, x, y, z, EnumFacing.field_176754_o) || this.trySpawnOffsets(entity, x, y + 1.0, z, EnumFacing.field_176754_o);
    }

    private boolean trySpawnOffsets(EntityLiving entity, double x, double y, double z, EnumFacing ... facings) {
        for (EnumFacing facing : facings) {
            entity.func_70107_b(x + (double)facing.func_82601_c(), y + (double)facing.func_96559_d(), z + (double)facing.func_82599_e());
            if (!entity.func_70058_J()) continue;
            return true;
        }
        return false;
    }

    private void resetTimer(boolean incrProgressiveDelay) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.maxSpawnDelay <= this.minSpawnDelay) {
                this.spawnDelay = this.minSpawnDelay;
            } else if (this.progressiveSpawnDelay <= 0) {
                this.spawnDelay = this.minSpawnDelay + this.field_145850_b.field_73012_v.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
            } else {
                if (this.spawnDelayBuildup < (double)this.minSpawnDelay) {
                    this.spawnDelayBuildup = this.minSpawnDelay;
                }
                this.spawnDelay = (int)this.spawnDelayBuildup;
                if (incrProgressiveDelay) {
                    this.spawnDelayBuildup = Math.min((double)this.maxSpawnDelay, this.spawnDelayBuildup + (double)this.progressiveSpawnDelay * (1.0 + 0.1 * (this.field_145850_b.field_73012_v.nextDouble() - 0.5)));
                }
            }
            if (this.dynamicSpawnList != null) {
                this.setEntityToSpawn(this.dynamicSpawnList.nextItem(this.field_145850_b.field_73012_v));
                IBlockState block = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, block, block, 4);
            }
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)ModObjects.DEADLY_SPAWNER, 1, 0);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a(TAG_DYNAMIC_SPAWN_LIST, this.dynamicSpawnList == null ? "" : this.dynamicSpawnList.toString());
        tag.func_74757_a(TAG_CHECK_SIGHT, this.checkSight);
        tag.func_74768_a(TAG_DELAY_MAX, this.maxSpawnDelay);
        tag.func_74768_a(TAG_DELAY_PROGRESSIVE, this.progressiveSpawnDelay);
        tag.func_74768_a(TAG_SPAWN_COUNT, this.spawnCount);
        tag.func_74776_a(TAG_SPAWN_RANGE, this.spawnRange);
        tag.func_74780_a(TAG_DELAY_BUILDUP, this.spawnDelayBuildup);
        return this.writeNBTSentToClient(tag);
    }

    private NBTTagCompound writeNBTSentToClient(NBTTagCompound tag) {
        tag.func_74776_a(TAG_ACTIVATION_RANGE, this.activationRange);
        tag.func_74768_a(TAG_DELAY_MIN, this.minSpawnDelay);
        tag.func_74778_a(TAG_SPAWN_ENTITY, this.entityToSpawn == EntityPig.class ? "" : EntityList.func_191306_a(this.entityToSpawn).toString());
        tag.func_74768_a(TAG_DELAY, this.spawnDelay);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        String line;
        super.func_145839_a(tag);
        if (tag.func_150297_b(TAG_DYNAMIC_SPAWN_LIST, TrapHelper.NBT_TYPE_STRING)) {
            line = tag.func_74779_i(TAG_DYNAMIC_SPAWN_LIST);
            this.dynamicSpawnList = line == null || line.isEmpty() ? null : new WeightedRandomConfig(line);
        }
        if (tag.func_150297_b(TAG_ACTIVATION_RANGE, 99)) {
            this.activationRange = tag.func_74760_g(TAG_ACTIVATION_RANGE);
        }
        if (tag.func_150297_b(TAG_CHECK_SIGHT, 99)) {
            this.checkSight = tag.func_74767_n(TAG_CHECK_SIGHT);
        }
        if (tag.func_150297_b(TAG_DELAY_MIN, 99)) {
            this.minSpawnDelay = tag.func_74762_e(TAG_DELAY_MIN);
        }
        if (tag.func_150297_b(TAG_DELAY_MAX, 99)) {
            this.maxSpawnDelay = tag.func_74762_e(TAG_DELAY_MAX);
        }
        if (tag.func_150297_b(TAG_DELAY_PROGRESSIVE, 99)) {
            this.progressiveSpawnDelay = tag.func_74762_e(TAG_DELAY_PROGRESSIVE);
        }
        if (tag.func_150297_b(TAG_SPAWN_COUNT, 99)) {
            this.spawnCount = tag.func_74762_e(TAG_SPAWN_COUNT);
        }
        if (tag.func_150297_b(TAG_SPAWN_RANGE, 99)) {
            this.spawnRange = tag.func_74760_g(TAG_SPAWN_RANGE);
        }
        if (tag.func_150297_b(TAG_SPAWN_ENTITY, TrapHelper.NBT_TYPE_STRING)) {
            line = tag.func_74779_i(TAG_SPAWN_ENTITY);
            if (line == null || line.isEmpty()) {
                this.entityToSpawn = EntityPig.class;
                this.cachedEntity = null;
            } else {
                this.setEntityToSpawn(new ResourceLocation(line));
            }
        }
        if (tag.func_150297_b(TAG_DELAY, 99)) {
            this.spawnDelay = tag.func_74762_e(TAG_DELAY);
        }
        if (tag.func_150297_b(TAG_DELAY_BUILDUP, 99)) {
            this.spawnDelayBuildup = tag.func_74769_h(TAG_DELAY_BUILDUP);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189515_b(new NBTTagCompound());
        return this.writeNBTSentToClient(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (this.field_145850_b.field_72995_K) {
            this.handleUpdateTag(pkt.func_148857_g());
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (this.field_145850_b.field_72995_K && id == 1) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public boolean func_183000_F() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getRenderEntity() {
        if (this.cachedEntity == null && this.field_145850_b != null) {
            try {
                this.cachedEntity = this.entityToSpawn.getConstructor(World.class).newInstance(this.field_145850_b);
            }
            catch (Exception ex) {
                DeadlyWorldMod.log().error("Encountered exception while constructing entity for render '{}'", this.entityToSpawn, (Object)ex);
                this.cachedEntity = new EntityPig(this.field_145850_b);
            }
            if (this.cachedEntity instanceof EntityLiving) {
                ((EntityLiving)this.cachedEntity).func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
            }
        }
        return this.cachedEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRenderEntityRotation(float partialTicks) {
        return (float)(this.prevMobRotation + (this.mobRotation - this.prevMobRotation) * (double)partialTicks);
    }
}

