/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.tileentity;

import fathertoast.deadlyworld.config.WeightedEnumConfig;
import fathertoast.deadlyworld.item.EnumDeadlyEventType;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import fathertoast.deadlyworld.tileentity.EnumChestType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;

public enum EnumSurpriseChestType implements WeightedEnumConfig.Meta
{
    TNT(EnumDeadlyEventType.TNT, 10){

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            super.buildChestLootTable(loot);
            loot.addThemePoolExplosives();
            loot.addLootTable("base", "Vanilla Chest", LootTableList.field_186422_d);
        }
    }
    ,
    LAVA(EnumDeadlyEventType.LAVA, 5){

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            super.buildChestLootTable(loot);
            loot.addThemePoolFire();
            loot.addLootTable("base", "Vanilla Chest", LootTableList.field_186422_d);
        }
    }
    ,
    POISON_GAS(EnumDeadlyEventType.POISON_GAS, 5){

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            super.buildChestLootTable(loot);
            loot.addThemePoolBrewing();
            loot.addLootTable("base", "Vanilla Chest", LootTableList.field_186422_d);
        }
    };

    public final ResourceLocation LOOT_TABLE_CHEST;
    public final String NAME;
    public final int DEFAULT_WEIGHT;
    public final EnumDeadlyEventType EVENT;

    private EnumSurpriseChestType(EnumDeadlyEventType event, int defaultWeight) {
        this.NAME = event.NAME;
        this.DEFAULT_WEIGHT = defaultWeight;
        this.EVENT = event;
        this.LOOT_TABLE_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("deadlyworld", "feature_chests/chests/" + EnumChestType.SURPRISE.NAME + "/" + event.NAME));
    }

    public void buildChestLootTable(LootTableBuilder loot) {
        loot.addLootTable("surprise", "Event", this.EVENT.LOOT_TABLE);
    }

    @Override
    public int defaultWeight() {
        return this.DEFAULT_WEIGHT;
    }

    public String toString() {
        return this.NAME;
    }
}

