/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.tileentity;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.WeightedEnumConfig;
import java.util.Random;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;

public enum EnumPotionArrowType implements WeightedEnumConfig.Meta
{
    SLOWNESS("slowness", 4){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_76421_d, dimConfig.TOWER_POTION.SLOWNESS_DURATION, dimConfig.TOWER_POTION.SLOWNESS_POTENCY));
        }
    }
    ,
    POISON("poison", 4){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_76436_u, dimConfig.TOWER_POTION.POISON_DURATION, dimConfig.TOWER_POTION.POISON_POTENCY));
        }
    }
    ,
    WITHER("wither", 1){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_82731_v, dimConfig.TOWER_POTION.WITHER_DURATION, dimConfig.TOWER_POTION.WITHER_POTENCY));
        }
    }
    ,
    HARM("harm", 1){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_76433_i, 0, dimConfig.TOWER_POTION.HARM_POTENCY));
        }
    }
    ,
    HUNGER("hunger", 2){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_76438_s, dimConfig.TOWER_POTION.HUNGER_DURATION, dimConfig.TOWER_POTION.HUNGER_POTENCY));
        }
    }
    ,
    BLINDNESS("blindness", 2){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_76440_q, dimConfig.TOWER_POTION.BLINDNESS_DURATION));
        }
    }
    ,
    WEAKNESS("weakness", 2){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_76437_t, dimConfig.TOWER_POTION.WEAKNESS_DURATION, dimConfig.TOWER_POTION.WEAKNESS_POTENCY));
            arrow.func_184558_a(new PotionEffect(MobEffects.field_76419_f, dimConfig.TOWER_POTION.WEAKNESS_DURATION, dimConfig.TOWER_POTION.WEAKNESS_POTENCY));
        }
    }
    ,
    LEVITATION("levitation", 1){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            arrow.func_184558_a(new PotionEffect(MobEffects.field_188424_y, dimConfig.TOWER_POTION.LEVITATION_DURATION, dimConfig.TOWER_POTION.LEVITATION_POTENCY));
        }
    }
    ,
    RANDOM("random", 1){

        @Override
        public void addEffects(Random random, Config dimConfig, EntityTippedArrow arrow) {
            9.values()[random.nextInt(9.values().length - 1)].addEffects(random, dimConfig, arrow);
        }
    };

    private final String NAME;
    public final int DEFAULT_WEIGHT;

    private EnumPotionArrowType(String name, int defaultWeight) {
        this.NAME = name;
        this.DEFAULT_WEIGHT = defaultWeight;
    }

    public abstract void addEffects(Random var1, Config var2, EntityTippedArrow var3);

    @Override
    public int defaultWeight() {
        return this.DEFAULT_WEIGHT;
    }

    public String toString() {
        return this.NAME;
    }

    public static EnumPotionArrowType fromString(String name) {
        for (EnumPotionArrowType value : EnumPotionArrowType.values()) {
            if (!value.NAME.equals(name)) continue;
            return value;
        }
        DeadlyWorldMod.log().warn("Attempted to load invalid potion arrow type with name '{}'", (Object)name);
        return RANDOM;
    }
}

