/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.tileentity;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.featuregen.WorldGenChest;
import fathertoast.deadlyworld.item.EnumDeadlyEventType;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public enum EnumChestType implements IStringSerializable
{
    DEFAULT("simple"){

        @Override
        public Config.FeatureChest getFeatureConfig(Config dimConfig) {
            return dimConfig.CHEST_DEFAULT;
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolExploration();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateChest(WorldGenChest generator, BlockPos chestPos, Config dimConfig, World world, Random random) {
        }
    }
    ,
    VALUABLE("valuable"){

        @Override
        public Config.FeatureChest getFeatureConfig(Config dimConfig) {
            return dimConfig.CHEST_VALUABLE;
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolValuable();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateChest(WorldGenChest generator, BlockPos chestPos, Config dimConfig, World world, Random random) {
            IBlockState coverBlock = dimConfig.CHEST_VALUABLE.COVER_BLOCKS.TOTAL_WEIGHT > 0 ? dimConfig.CHEST_VALUABLE.COVER_BLOCKS.nextBlock(random) : Blocks.field_150343_Z.func_176223_P();
            generator.setBlock(dimConfig, world, random, chestPos.func_177982_a(0, -1, 0), coverBlock);
            generator.setBlock(dimConfig, world, random, chestPos.func_177982_a(0, 1, 0), coverBlock);
            generator.setBlock(dimConfig, world, random, chestPos.func_177982_a(-1, 0, 0), coverBlock);
            generator.setBlock(dimConfig, world, random, chestPos.func_177982_a(0, 0, -1), coverBlock);
            generator.setBlock(dimConfig, world, random, chestPos.func_177982_a(1, 0, 0), coverBlock);
            generator.setBlock(dimConfig, world, random, chestPos.func_177982_a(0, 0, 1), coverBlock);
        }
    }
    ,
    TRAPPED("trapped"){

        @Override
        public Config.FeatureChest getFeatureConfig(Config dimConfig) {
            return dimConfig.CHEST_TRAPPED;
        }

        @Override
        public boolean canTypeBePlaced(World world, BlockPos position) {
            return world.func_180495_p(position.func_177982_a(0, -1, 0)).func_185917_h() && super.canTypeBePlaced(world, position);
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolExplosives();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateChest(WorldGenChest generator, BlockPos chestPos, Config dimConfig, World world, Random random) {
            generator.setBlock(dimConfig, world, random, chestPos.func_177982_a(0, -1, 0), Blocks.field_150335_W.func_176223_P());
        }
    }
    ,
    TNT_FLOOR_TRAP("tnt_floor_trapped"){

        @Override
        public Config.FeatureChest getFeatureConfig(Config dimConfig) {
            return dimConfig.CHEST_TNT_FLOOR_TRAP;
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolExplosives();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateChest(WorldGenChest generator, BlockPos chestPos, Config dimConfig, World world, Random random) {
            IBlockState blockState = ModObjects.FLOOR_TRAP.func_176223_P().func_177226_a(EnumFloorTrapType.PROPERTY, (Comparable)((Object)EnumFloorTrapType.TNT));
            BlockPos trapPos = chestPos.func_177982_a(0, -1, 0);
            generator.setBlock(dimConfig, world, random, trapPos, blockState);
            ModObjects.FLOOR_TRAP.initTileEntity(world, trapPos, blockState, dimConfig, random);
        }
    }
    ,
    INFESTED("infested"){

        @Override
        public Config.FeatureChest getFeatureConfig(Config dimConfig) {
            return dimConfig.CHEST_INFESTED;
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addLootTable("event", "Spawn Silverfish", EnumDeadlyEventType.SILVERFISH.LOOT_TABLE);
            loot.addThemePoolBuggy();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateChest(WorldGenChest generator, BlockPos chestPos, Config dimConfig, World world, Random random) {
        }
    }
    ,
    SURPRISE("surprise"){

        @Override
        public Config.FeatureChest getFeatureConfig(Config dimConfig) {
            return dimConfig.CHEST_SURPRISE;
        }

        @Override
        public ResourceLocation getLootTable(Config dimConfig, World world, Random random, BlockPos position) {
            return dimConfig.CHEST_SURPRISE.SURPRISE_TYPE_LIST.nextItem((Random)random).LOOT_TABLE_CHEST;
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
        }

        @Override
        public void decorateChest(WorldGenChest generator, BlockPos chestPos, Config dimConfig, World world, Random random) {
        }
    }
    ,
    MIMIC("mimic"){

        @Override
        public Config.FeatureChest getFeatureConfig(Config dimConfig) {
            return dimConfig.CHEST_MIMIC;
        }

        @Override
        public ResourceLocation getLootTable(Config dimConfig, World world, Random random, BlockPos position) {
            return EnumDeadlyEventType.SPAWN_MIMIC.LOOT_TABLE;
        }

        @Override
        public void buildChestLootTable(LootTableBuilder loot) {
            loot.addThemePoolValuable();
            super.buildChestLootTable(loot);
        }

        @Override
        public void decorateChest(WorldGenChest generator, BlockPos chestPos, Config dimConfig, World world, Random random) {
        }
    };

    public static final String FEATURE_PATH = "chests/";
    public final ResourceLocation LOOT_TABLE_CHEST;
    public final String NAME;
    public final String DISPLAY_NAME;

    private EnumChestType(String name) {
        this(name, name.replace("_", " ") + " chests");
    }

    private EnumChestType(String name, String prettyName) {
        this.NAME = name;
        this.DISPLAY_NAME = prettyName;
        this.LOOT_TABLE_CHEST = new ResourceLocation("deadlyworld", "feature_chests/chests/" + name);
        if (!"surprise".equals(name)) {
            LootTableList.func_186375_a((ResourceLocation)this.LOOT_TABLE_CHEST);
        }
    }

    public abstract Config.FeatureChest getFeatureConfig(Config var1);

    public void buildChestLootTable(LootTableBuilder loot) {
        loot.addLootTable("base", "Vanilla Chest", LootTableList.field_186422_d);
    }

    public boolean canTypeBePlaced(World world, BlockPos position) {
        return !world.func_180495_p(position.func_177982_a(0, 2, 0)).func_185917_h() && world.func_175623_d(position.func_177982_a(0, 1, 0));
    }

    public ResourceLocation getLootTable(Config dimConfig, World world, Random random, BlockPos position) {
        return this.LOOT_TABLE_CHEST;
    }

    public abstract void decorateChest(WorldGenChest var1, BlockPos var2, Config var3, World var4, Random var5);

    public WorldGenChest makeWorldGen() {
        return new WorldGenChest(this);
    }

    public String toString() {
        return this.NAME;
    }

    public String func_176610_l() {
        return this.NAME;
    }
}

