/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.oregen;

import fathertoast.deadlyworld.config.TargetBlock;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

class WorldGenDeadlyMinable {
    private static final BlockPos[] COVERED_TEST_POS = new BlockPos[]{new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 0, -1)};
    private IBlockState veinBlock;
    private boolean veinCovered = false;

    WorldGenDeadlyMinable() {
    }

    IBlockState getFill() {
        return this.veinBlock;
    }

    WorldGenDeadlyMinable setFill(IBlockState block) {
        this.veinBlock = block;
        return this;
    }

    WorldGenDeadlyMinable setCovered() {
        this.veinCovered = true;
        return this;
    }

    WorldGenDeadlyMinable setCovered(boolean covered) {
        this.veinCovered = covered;
        return this;
    }

    boolean generate(int veinSize, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position) {
        int generated = 0;
        float orientation = random.nextFloat() * (float)Math.PI;
        double xiMin = (float)position.func_177958_n() + MathHelper.func_76126_a((float)orientation) * (float)veinSize / 8.0f;
        double xiMax = (float)position.func_177958_n() - MathHelper.func_76126_a((float)orientation) * (float)veinSize / 8.0f;
        double yiMin = position.func_177956_o() + random.nextInt(3) - 2;
        double yiMax = position.func_177956_o() + random.nextInt(3) - 2;
        double ziMin = (float)position.func_177952_p() + MathHelper.func_76134_b((float)orientation) * (float)veinSize / 8.0f;
        double ziMax = (float)position.func_177952_p() - MathHelper.func_76134_b((float)orientation) * (float)veinSize / 8.0f;
        for (int blockNumber = 0; blockNumber < veinSize; ++blockNumber) {
            float ratio = (float)blockNumber / (float)veinSize;
            double xi = xiMin + (xiMax - xiMin) * (double)ratio;
            double yi = yiMin + (yiMax - yiMin) * (double)ratio;
            double zi = ziMin + (ziMax - ziMin) * (double)ratio;
            double mgntd = random.nextDouble() * (double)veinSize / 16.0;
            double radius = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * ratio)) + 1.0f) * mgntd + 1.0) / 2.0;
            int xMin = MathHelper.func_76128_c((double)(xi - radius));
            int yMin = MathHelper.func_76128_c((double)(yi - radius));
            int zMin = MathHelper.func_76128_c((double)(zi - radius));
            int xMax = MathHelper.func_76128_c((double)(xi + radius));
            int yMax = MathHelper.func_76128_c((double)(yi + radius));
            int zMax = MathHelper.func_76128_c((double)(zi + radius));
            for (int x = xMin; x <= xMax; ++x) {
                double dx = ((double)x + 0.5 - xi) / radius;
                if (!(dx * dx < 1.0)) continue;
                for (int y = yMin; y <= yMax; ++y) {
                    double dy = ((double)y + 0.5 - yi) / radius;
                    if (!(dx * dx + dy * dy < 1.0)) continue;
                    for (int z = zMin; z <= zMax; ++z) {
                        BlockPos placementPos;
                        IBlockState blockToReplace;
                        double dz = ((double)z + 0.5 - zi) / radius;
                        if (!(dx * dx + dy * dy + dz * dz < 1.0) || !replaceableBlocks.matches(blockToReplace = world.func_180495_p(placementPos = new BlockPos(x, y, z))) || !this.setBlock(world, random, placementPos, blockToReplace)) continue;
                        ++generated;
                    }
                }
            }
        }
        return generated > 0;
    }

    protected boolean setBlock(World world, Random random, BlockPos position, IBlockState blockToReplace) {
        if (this.veinCovered) {
            for (BlockPos testPos : COVERED_TEST_POS) {
                IBlockState testBlock = world.func_180495_p(position.func_177971_a((Vec3i)testPos));
                if (testBlock.func_185917_h() || testBlock.func_177230_c().equals(this.veinBlock.func_177230_c())) continue;
                return false;
            }
        }
        world.func_180501_a(position, this.veinBlock, 18);
        return true;
    }
}

