/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.oregen;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.oregen.WorldGenDeadlyMinable;
import fathertoast.deadlyworld.oregen.WorldGenDeadlySilverfish;
import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OreGenerator {
    private static final IBlockState DIORITE = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
    private static final IBlockState GRANITE = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
    private static final IBlockState ANDESITE = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
    private WorldGenDeadlyMinable genLava = new WorldGenDeadlyMinable().setFill(Blocks.field_150353_l.func_176223_P()).setCovered();
    private WorldGenDeadlyMinable genWater = new WorldGenDeadlyMinable().setFill(Blocks.field_150355_j.func_176223_P()).setCovered();
    private WorldGenDeadlyMinable genSilverfish = new WorldGenDeadlySilverfish().setFill(ModObjects.INFESTED_COBBLE.func_176223_P());
    private WorldGenDeadlyMinable genUserDefinedOre = new WorldGenDeadlyMinable();
    private WorldGenDeadlyMinable genExtraOre = new WorldGenDeadlyMinable();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void preOreGen(DecorateBiomeEvent.Pre event) {
        World world = event.getWorld();
        Config config = Config.get(world);
        if (config != null) {
            Random random = event.getRand();
            BlockPos chunkCenterPos = event.getChunkPos().func_180331_a(8, 0, 8);
            this.generateOre(config, config.VEIN_LAVA, this.genLava, world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_WATER, this.genWater, world, random, chunkCenterPos);
            int userDefinedVeinCount = config.VEINS.USER_DEFINED_VEIN_COUNT;
            for (int i = 0; i < userDefinedVeinCount; ++i) {
                Config.VeinUserDefined veinConfig = config.VEINS.USER_DEFINED_VEINS[i];
                this.generateOre(config, veinConfig, this.genUserDefinedOre.setFill(veinConfig.FILL_BLOCK).setCovered(veinConfig.COVERED), world, random, chunkCenterPos);
            }
            this.generateOre(config, config.VEIN_DIRT, this.genExtraOre.setFill(Blocks.field_150346_d.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_GRAVEL, this.genExtraOre.setFill(Blocks.field_150351_n.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_SAND, this.genExtraOre.setFill(Blocks.field_150354_m.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_DIORITE, this.genExtraOre.setFill(DIORITE), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_GRANITE, this.genExtraOre.setFill(GRANITE), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_ANDESITE, this.genExtraOre.setFill(ANDESITE), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_COAL, this.genExtraOre.setFill(Blocks.field_150365_q.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_QUARTZ, this.genExtraOre.setFill(Blocks.field_150449_bY.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_IRON, this.genExtraOre.setFill(Blocks.field_150366_p.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_GOLD, this.genExtraOre.setFill(Blocks.field_150352_o.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_REDSTONE, this.genExtraOre.setFill(Blocks.field_150450_ax.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_DIAMOND, this.genExtraOre.setFill(Blocks.field_150482_ag.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_LAPIS, this.genExtraOre.setFill(Blocks.field_150369_x.func_176223_P()), world, random, chunkCenterPos);
            this.generateOre(config, config.VEIN_EMERALD, this.genExtraOre.setFill(Blocks.field_150412_bA.func_176223_P()), world, random, chunkCenterPos);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void postOreGen(DecorateBiomeEvent.Post event) {
        World world = event.getWorld();
        Config config = Config.get(world);
        if (config != null) {
            Random random = event.getRand();
            BlockPos chunkCenterPos = event.getChunkPos().func_180331_a(8, 0, 8);
            this.generateOre(config, config.VEIN_SILVERFISH, this.genSilverfish, world, random, chunkCenterPos);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void oreGen(OreGenEvent.GenerateMinable event) {
        World world = event.getWorld();
        Config config = Config.get(world);
        if (config != null) {
            switch (event.getType()) {
                case COAL: {
                    if (!config.VEINS.DISABLE_COAL_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case DIAMOND: {
                    if (!config.VEINS.DISABLE_DIAMOND_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case DIRT: {
                    if (!config.VEINS.DISABLE_DIRT_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case GOLD: {
                    if (!config.VEINS.DISABLE_GOLD_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case GRAVEL: {
                    if (!config.VEINS.DISABLE_GRAVEL_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case IRON: {
                    if (!config.VEINS.DISABLE_IRON_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case LAPIS: {
                    if (!config.VEINS.DISABLE_LAPIS_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case REDSTONE: {
                    if (!config.VEINS.DISABLE_REDSTONE_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case QUARTZ: {
                    if (!config.VEINS.DISABLE_QUARTZ_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case DIORITE: {
                    if (!config.VEINS.DISABLE_DIORITE_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case GRANITE: {
                    if (!config.VEINS.DISABLE_GRANITE_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case ANDESITE: {
                    if (!config.VEINS.DISABLE_ANDESITE_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case EMERALD: {
                    if (!config.VEINS.DISABLE_EMERALD_VEINS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case SILVERFISH: {
                    if (!config.VEINS.DISABLE_SILVERFISH_VEINS) break;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    private void generateOre(Config config, Config.VeinConfig veinConfig, WorldGenDeadlyMinable generator, World world, Random random, BlockPos chunkCenterPos) {
        for (float count = veinConfig.getPlacements(world, chunkCenterPos); count >= 1.0f || count > 0.0f && count > random.nextFloat(); count -= 1.0f) {
            BlockPos veinPos = chunkCenterPos.func_177982_a(random.nextInt(16), OreGenerator.nextHeight(veinConfig, random), random.nextInt(16));
            boolean gen = generator.generate(OreGenerator.nextSize(veinConfig, random), config.TERRAIN.REPLACEABLE_BLOCKS, world, random, veinPos);
            if (!gen || !veinConfig.DEBUG_MARKER) continue;
            DeadlyWorldMod.mark(world, veinPos, generator.getFill());
        }
    }

    private static int nextSize(Config.VeinConfig veinConfig, Random random) {
        if (veinConfig.SIZES[0] >= veinConfig.SIZES[1]) {
            return veinConfig.SIZES[0];
        }
        return random.nextInt(veinConfig.SIZES[1] - veinConfig.SIZES[0]) + veinConfig.SIZES[0];
    }

    private static int nextHeight(Config.VeinConfig veinConfig, Random random) {
        if (veinConfig.HEIGHTS[0] >= veinConfig.HEIGHTS[1]) {
            return veinConfig.HEIGHTS[0];
        }
        return random.nextInt(veinConfig.HEIGHTS[1] - veinConfig.HEIGHTS[0]) + veinConfig.HEIGHTS[0];
    }
}

