/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.loot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.featuregen.FeatureGenerator;
import fathertoast.deadlyworld.item.EnumDeadlyEventType;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import fathertoast.deadlyworld.tileentity.EnumChestType;
import fathertoast.deadlyworld.tileentity.EnumSurpriseChestType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;

@ParametersAreNonnullByDefault
public class LootTableHelper {
    private static final String FILE_EXT = ".json";
    private static final Gson GSON_LOOT_TABLES = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).setPrettyPrinting().create();

    public static void generateBaseLootTables(File configDir) {
        File runDir = configDir.getParentFile();
        if (!"run".equals(runDir.getName())) {
            return;
        }
        File projectDir = runDir.getParentFile();
        File lootTablesDir = new File(projectDir, "src/main/resources/assets/deadlyworld/loot_tables/");
        if (!lootTablesDir.exists()) {
            return;
        }
        DeadlyWorldMod.log().warn("Generating base loot tables...");
        long startTime = System.nanoTime();
        DeadlyWorldMod.log().warn("Loot table directory: '{}'", (Object)lootTablesDir.getAbsolutePath());
        LootTableHelper.deleteAllLootTables(lootTablesDir);
        LootTableHelper.createAllLootTables(lootTablesDir);
        long estimatedTime = System.nanoTime() - startTime;
        DeadlyWorldMod.log().warn("Generated base loot tables in {} ms", (Object)((double)estimatedTime / 1000000.0));
    }

    private static void deleteAllLootTables(File directory) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    LootTableHelper.deleteAllLootTables(file);
                }
                if (file.delete()) continue;
                DeadlyWorldMod.log().error("Failed to delete file: '{}'", (Object)file.getPath());
            }
        }
    }

    private static void createAllLootTables(File lootTablesDir) {
        lootTablesDir.mkdirs();
        LootTableHelper.createUtilityLootTables(new File(lootTablesDir, "events/"));
        LootTableHelper.createBlockLootTables(new File(lootTablesDir, "blocks/"));
        LootTableHelper.createFeatureLootTables(new File(lootTablesDir, "feature_chests/"));
    }

    private static void createUtilityLootTables(File subDir) {
        subDir.mkdirs();
        for (EnumDeadlyEventType event : EnumDeadlyEventType.values()) {
            LootTableBuilder loot = new LootTableBuilder();
            event.buildLootTable(loot);
            LootTableHelper.generateFile(subDir, event.NAME, loot);
        }
    }

    private static void createBlockLootTables(File subDir) {
        LootTableBuilder loot;
        subDir.mkdirs();
        File blockDir = new File(subDir, "floor_trap/");
        blockDir.mkdirs();
        for (EnumFloorTrapType enumFloorTrapType : EnumFloorTrapType.values()) {
            loot = new LootTableBuilder();
            enumFloorTrapType.buildBlockLootTable(loot);
            LootTableHelper.generateFile(blockDir, enumFloorTrapType.NAME, loot);
        }
        blockDir = new File(subDir, "deadly_spawner/");
        blockDir.mkdirs();
        for (Enum enum_ : EnumSpawnerType.values()) {
            loot = new LootTableBuilder();
            ((EnumSpawnerType)enum_).buildBlockLootTable(loot);
            LootTableHelper.generateFile(blockDir, ((EnumSpawnerType)enum_).NAME, loot);
        }
        blockDir = new File(subDir, "tower_dispenser/");
        blockDir.mkdirs();
        for (Enum enum_ : EnumTowerType.values()) {
            loot = new LootTableBuilder();
            ((EnumTowerType)enum_).buildBlockLootTable(loot);
            LootTableHelper.generateFile(blockDir, ((EnumTowerType)enum_).NAME, loot);
        }
    }

    private static void createFeatureLootTables(File subDir) {
        LootTableBuilder loot;
        subDir.mkdirs();
        File featureDir = new File(subDir, "chests/");
        featureDir.mkdirs();
        for (EnumChestType enumChestType : EnumChestType.values()) {
            if (enumChestType == EnumChestType.SURPRISE) continue;
            loot = new LootTableBuilder();
            enumChestType.buildChestLootTable(loot);
            LootTableHelper.generateFile(featureDir, enumChestType.NAME, loot);
        }
        featureDir = new File(subDir, "chests/" + EnumChestType.SURPRISE.NAME + "/");
        featureDir.mkdirs();
        for (Enum enum_ : EnumSurpriseChestType.values()) {
            loot = new LootTableBuilder();
            ((EnumSurpriseChestType)enum_).buildChestLootTable(loot);
            LootTableHelper.generateFile(featureDir, ((EnumSurpriseChestType)enum_).NAME, loot);
        }
        featureDir = new File(subDir, "deadly_spawners/");
        featureDir.mkdirs();
        for (Enum enum_ : EnumSpawnerType.values()) {
            if (enum_ == EnumSpawnerType.DUNGEON) continue;
            loot = new LootTableBuilder();
            ((EnumSpawnerType)enum_).buildChestLootTable(loot);
            LootTableHelper.generateFile(featureDir, ((EnumSpawnerType)enum_).NAME, loot);
        }
        LootTableBuilder loot2 = new LootTableBuilder();
        FeatureGenerator.DUNGEON_FEATURE.buildChestLootTable(loot2);
        LootTableHelper.generateFile(subDir, FeatureGenerator.DUNGEON_FEATURE.NAME, loot2);
    }

    private static void generateFile(File directory, String path, LootTableBuilder loot) {
        File lootTableFile = new File(directory, path.toLowerCase() + FILE_EXT);
        try {
            lootTableFile.createNewFile();
            FileWriter out = new FileWriter(lootTableFile);
            GSON_LOOT_TABLES.toJson((Object)loot.toLootTable(), LootTable.class, (Appendable)out);
            out.close();
        }
        catch (IOException ex) {
            DeadlyWorldMod.log().error("Failed to generate loot table: '{}'", (Object)lootTableFile.getPath(), (Object)ex);
        }
    }
}

