/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.loot;

import fathertoast.deadlyworld.loot.LootEntryItemBuilder;
import fathertoast.deadlyworld.loot.LootPoolBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;

public class LootTableBuilder {
    private final List<LootPool> pools = new ArrayList<LootPool>();

    public LootTable toLootTable() {
        return new LootTable(this.pools.toArray(new LootPool[0]));
    }

    public LootTableBuilder addThemePoolExploration() {
        LootPoolBuilder pool = new LootPoolBuilder("exploration").setRolls(1.0f, 3.0f);
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Bow", (Item)Items.field_151031_f).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Arrow", Items.field_151032_g).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Stone Sword", Items.field_151052_q).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Iron Sword", Items.field_151040_l).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Sword", Items.field_151048_u).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Shield", Items.field_185159_cQ).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Water Bucket", Items.field_151131_as).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Lava Bucket", Items.field_151129_at).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Milk Bucket", Items.field_151117_aB).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Ender Pearl", Items.field_151079_bi).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Clock", Items.field_151113_aN).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Compass", Items.field_151111_aL).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Map", (Item)Items.field_151148_bJ).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Book", Items.field_151122_aG).setWeight(5).enchant(10, 30, true).toLootEntry());
        this.pools.add(pool.toLootPool());
        return this;
    }

    public LootTableBuilder addThemePoolValuable() {
        LootPoolBuilder pool = new LootPoolBuilder("valuable").setRolls(1.0f, 3.0f);
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Iron Ingot", Items.field_151042_j).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gold Ingot", Items.field_151043_k).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond", Items.field_151045_i).setWeight(5).setCount(1, 3).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Emerald", Items.field_151166_bC).setWeight(5).setCount(1, 3).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Cake", Blocks.field_150414_aQ).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gold Carrot", Items.field_151150_bK).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gold Apple", Items.field_151153_ao).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Epic Apple", new ItemStack(Items.field_151153_ao, 1, 1)).setWeight(2).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Iron Helmet", (Item)Items.field_151028_Y).setWeight(3).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Iron Chestplate", (Item)Items.field_151030_Z).setWeight(3).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Iron Leggings", (Item)Items.field_151165_aa).setWeight(3).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Iron Boots", (Item)Items.field_151167_ab).setWeight(3).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Sword", Items.field_151048_u).setWeight(2).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Pick", Items.field_151046_w).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Axe", Items.field_151056_x).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Shovel", Items.field_151047_v).setWeight(2).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Helmet", (Item)Items.field_151161_ac).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Chestplate", (Item)Items.field_151163_ad).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Leggings", (Item)Items.field_151173_ae).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond Boots", (Item)Items.field_151175_af).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Book", Items.field_151122_aG).setWeight(10).enchant(30, true).toLootEntry());
        this.pools.add(pool.toLootPool());
        return this;
    }

    public LootTableBuilder addThemePoolExplosives() {
        LootPoolBuilder pool = new LootPoolBuilder("explosives").setRolls(1.0f, 3.0f);
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gunpowder", Items.field_151016_H).setWeight(20).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("TNT", Blocks.field_150335_W).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("TNT Minecart", Items.field_151142_bV).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Flame Bow", (Item)Items.field_151031_f).applyOneRandomEnchant(Enchantments.field_185311_w).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Fire Charge", Items.field_151059_bz).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Flint & Steel", Items.field_151033_d).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Redstone", Items.field_151137_ax).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Repeater", Items.field_151107_aW).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Comparator", Items.field_151132_bS).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Observer", Blocks.field_190976_dk).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Daylight Detector", (Block)Blocks.field_150453_bW).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Shears", (Item)Items.field_151097_aZ).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("String", Items.field_151007_F).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Tripwire", (Block)Blocks.field_150479_bC).setWeight(5).setCount(2).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Book", Items.field_151122_aG).setWeight(5).applyOneRandomEnchant(Enchantments.field_185297_d, Enchantments.field_191530_r, Enchantments.field_185311_w).toLootEntry());
        this.pools.add(pool.toLootPool());
        return this;
    }

    public LootTableBuilder addThemePoolFire() {
        LootPoolBuilder pool = new LootPoolBuilder("fiery").setRolls(1.0f, 3.0f);
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Flame Bow", (Item)Items.field_151031_f).applyOneRandomEnchant(Enchantments.field_185311_w).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Arrow", Items.field_151032_g).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Fire Sword", Items.field_151040_l).applyOneRandomEnchant(Enchantments.field_77334_n).setWeight(5).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Torch", Blocks.field_150478_aa).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Fire Charge", Items.field_151059_bz).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Flint & Steel", Items.field_151033_d).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Lava Bucket", Items.field_151129_at).setWeight(10).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Magma", Blocks.field_189877_df).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Glowstone Dust", Items.field_151114_aO).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Blaze Powder", Items.field_151065_br).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Magma Cream", Items.field_151064_bs).setWeight(10).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Book", Items.field_151122_aG).setWeight(5).applyOneRandomEnchant(Enchantments.field_77329_d, Enchantments.field_77334_n, Enchantments.field_185311_w).toLootEntry());
        this.pools.add(pool.toLootPool());
        return this;
    }

    public LootTableBuilder addThemePoolBrewing() {
        LootPoolBuilder pool = new LootPoolBuilder("brewing").setRolls(1.0f, 3.0f);
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Glass Bottle", Items.field_151069_bo).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Glowstone Dust", Items.field_151114_aO).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Redstone Dust", Items.field_151137_ax).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gunpowder", Items.field_151016_H).setWeight(15).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Fermented Eye", Items.field_151071_bq).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Spider Eye", Items.field_151070_bp).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Sugar", Items.field_151102_aT).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gold Melon", Items.field_151060_bw).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gold Carrot", Items.field_151150_bK).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Rabbit Foot", Items.field_179556_br).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Pufferfish", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a())).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Blaze Powder", Items.field_151065_br).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Magma Cream", Items.field_151064_bs).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Ghast Tear", Items.field_151073_bk).setWeight(5).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Book", Items.field_151122_aG).setWeight(5).enchant(10, 30, true).toLootEntry());
        this.pools.add(pool.toLootPool());
        return this;
    }

    public LootTableBuilder addThemePoolBuggy() {
        LootPoolBuilder pool = new LootPoolBuilder("buggy").setRolls(4.0f);
        ResourceLocation name = EntityList.func_191306_a(EntitySilverfish.class);
        ItemStack spawnEgg = new ItemStack(Items.field_151063_bx);
        ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)name);
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Silverfish Egg", spawnEgg).setWeight(10).setCount(1, 8).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Beetroot Seeds", Items.field_185163_cU).setWeight(15).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Melon Seeds", Items.field_151081_bc).setWeight(15).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Pumpkin Seeds", Items.field_151080_bb).setWeight(15).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Wheat Seeds", Items.field_151014_N).setWeight(15).setCount(1, 4).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Iron Nugget", Items.field_191525_da).setWeight(10).setCount(1, 9).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Gold Nugget", Items.field_151074_bl).setWeight(10).setCount(1, 9).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Diamond", Items.field_151045_i).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Emerald", Items.field_151166_bC).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Cake", Blocks.field_150414_aQ).setWeight(1).toLootEntry());
        pool.addEntry((LootEntry)new LootEntryItemBuilder("Enchanted Book", Items.field_151122_aG).setWeight(2).applyOneRandomEnchant(Enchantments.field_185308_t, Enchantments.field_185304_p, Enchantments.field_151370_z, Enchantments.field_180312_n, Enchantments.field_185306_r).toLootEntry());
        this.pools.add(pool.toLootPool());
        return this;
    }

    public LootTableBuilder addPool(LootPool pool) {
        this.pools.add(pool);
        return this;
    }

    public LootTableBuilder addLootTable(String id, String name, ResourceLocation lootTable) {
        return this.addPool(new LootPoolBuilder(id).addEntryTable(name, lootTable).toLootPool());
    }

    public LootTableBuilder addGuaranteedDrop(String id, String name, Block block, int count) {
        return this.addGuaranteedDrop(id, name, Item.func_150898_a((Block)block), count);
    }

    public LootTableBuilder addGuaranteedDrop(String id, String name, Item item, int count) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(count).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addCommonDrop(String id, String name, Block block) {
        return this.addCommonDrop(id, name, Item.func_150898_a((Block)block));
    }

    public LootTableBuilder addCommonDrop(String id, String name, Item item) {
        return this.addCommonDrop(id, name, item, 2);
    }

    public LootTableBuilder addCommonDrop(String id, String name, ItemStack item) {
        return this.addCommonDrop(id, name, item, 2);
    }

    public LootTableBuilder addCommonDrop(String id, String name, Block block, int max) {
        return this.addCommonDrop(id, name, Item.func_150898_a((Block)block), max);
    }

    public LootTableBuilder addCommonDrop(String id, String name, Item item, int max) {
        return this.addCommonDrop(id, name, item, 0, max);
    }

    public LootTableBuilder addCommonDrop(String id, String name, ItemStack item, int max) {
        return this.addCommonDrop(id, name, item, 0, max);
    }

    public LootTableBuilder addCommonDrop(String id, String name, Block block, int min, int max) {
        return this.addCommonDrop(id, name, Item.func_150898_a((Block)block), min, max);
    }

    public LootTableBuilder addCommonDrop(String id, String name, Item item, int min, int max) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(min, max).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addCommonDrop(String id, String name, ItemStack item, int min, int max) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(min, max).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addSemicommonDrop(String id, String name, Block block) {
        return this.addSemicommonDrop(id, name, Item.func_150898_a((Block)block));
    }

    public LootTableBuilder addSemicommonDrop(String id, String name, Item item) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(-1, 1).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addSemicommonDrop(String id, String name, ItemStack item) {
        return this.addPool(new LootPoolBuilder(id).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(-1, 1).addLootingBonus(0.0f, 1.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addClusterDrop(String id, String name, Block block) {
        return this.addClusterDrop(id, name, Item.func_150898_a((Block)block));
    }

    public LootTableBuilder addClusterDrop(String id, String name, Item item) {
        return this.addClusterDrop(id, name, item, 8);
    }

    public LootTableBuilder addClusterDrop(String id, String name, ItemStack item) {
        return this.addClusterDrop(id, name, item, 8);
    }

    public LootTableBuilder addClusterDrop(String id, String name, Block block, int max) {
        return this.addClusterDrop(id, name, Item.func_150898_a((Block)block), max);
    }

    public LootTableBuilder addClusterDrop(String id, String name, Item item, int max) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(1, max).addLootingBonus(0.0f, (float)max / 4.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addClusterDrop(String id, String name, ItemStack item, int max) {
        return this.addPool(new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS).addEntry((LootEntry)new LootEntryItemBuilder(name, item).setCount(1, max).addLootingBonus(0.0f, (float)max / 4.0f).toLootEntry()).toLootPool());
    }

    public LootTableBuilder addUncommonDrop(String id, String name, Block ... blocks) {
        return this.addUncommonDrop(id, name, LootTableBuilder.toItemArray(blocks));
    }

    public LootTableBuilder addUncommonDrop(String id, String name, Item ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addUncommonDrop(String id, String name, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.UNCOMMON_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).setWeight(items[i].func_190916_E()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addRareDrop(String id, String name, Block ... blocks) {
        return this.addRareDrop(id, name, LootTableBuilder.toItemArray(blocks));
    }

    public LootTableBuilder addRareDrop(String id, String name, Item ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.RARE_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addRareDrop(String id, String name, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.RARE_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).setWeight(items[i].func_190916_E()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addEpicDrop(String id, String name, Block ... blocks) {
        return this.addEpicDrop(id, name, LootTableBuilder.toItemArray(blocks));
    }

    public LootTableBuilder addEpicDrop(String id, String name, Item ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.EPIC_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    public LootTableBuilder addEpicDrop(String id, String name, ItemStack ... items) {
        LootPoolBuilder pool = new LootPoolBuilder(id).addConditions(LootPoolBuilder.EPIC_CONDITIONS);
        for (int i = 0; i < items.length; ++i) {
            pool.addEntry((LootEntry)new LootEntryItemBuilder(name + " " + (i + 1), items[i]).setWeight(items[i].func_190916_E()).toLootEntry());
        }
        return this.addPool(pool.toLootPool());
    }

    private static Item[] toItemArray(Block[] blocks) {
        Item[] items = new Item[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            items[i] = Item.func_150898_a((Block)blocks[i]);
        }
        return items;
    }
}

