/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.loot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class LootPoolBuilder {
    public static final LootCondition[] NO_CONDITIONS = new LootCondition[0];
    public static final LootFunction[] NO_FUNCTIONS = new LootFunction[0];
    public static final LootCondition[] UNCOMMON_CONDITIONS = new LootCondition[]{new RandomChanceWithLooting(0.25f, 0.1f)};
    public static final LootCondition[] RARE_CONDITIONS = new LootCondition[]{new RandomChanceWithLooting(0.025f, 0.01f)};
    public static final LootCondition[] EPIC_CONDITIONS = new LootCondition[]{new RandomChanceWithLooting(0.0f, 0.015f)};
    public static final RandomValueRange ONE_ROLL = new RandomValueRange(1.0f);
    public static final RandomValueRange NO_ROLL = new RandomValueRange(0.0f);
    private final String name;
    private RandomValueRange rolls = ONE_ROLL;
    private RandomValueRange bonusRolls = NO_ROLL;
    private final List<LootEntry> lootEntries = new ArrayList<LootEntry>();
    private final List<LootCondition> poolConditions = new ArrayList<LootCondition>();

    public LootPoolBuilder(String id) {
        this.name = id;
    }

    public LootPool toLootPool() {
        return new LootPool(this.lootEntries.toArray(new LootEntry[0]), this.poolConditions.toArray(NO_CONDITIONS), this.rolls, this.bonusRolls, this.name);
    }

    public LootPoolBuilder setRolls(float value) {
        this.rolls = new RandomValueRange(value);
        return this;
    }

    public LootPoolBuilder setRolls(float min, float max) {
        this.rolls = new RandomValueRange(min, max);
        return this;
    }

    public LootPoolBuilder setBonusRolls(float value) {
        this.bonusRolls = new RandomValueRange(value);
        return this;
    }

    public LootPoolBuilder setBonusRolls(float min, float max) {
        this.bonusRolls = new RandomValueRange(min, max);
        return this;
    }

    public LootPoolBuilder addConditions(LootCondition ... conditions) {
        this.poolConditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public LootPoolBuilder addEntry(LootEntry entry) {
        this.lootEntries.add(entry);
        return this;
    }

    public LootPoolBuilder addEntryTable(String name, ResourceLocation lootTable) {
        return this.addEntryTable(name, lootTable, 1, 0, NO_CONDITIONS);
    }

    public LootPoolBuilder addEntryTable(String name, ResourceLocation lootTable, int weight, int quality) {
        return this.addEntryTable(name, lootTable, weight, quality, NO_CONDITIONS);
    }

    public LootPoolBuilder addEntryTable(String name, ResourceLocation lootTable, int weight, int quality, LootCondition[] conditions) {
        return this.addEntry((LootEntry)new LootEntryTable(lootTable, weight, quality, conditions, name));
    }

    public LootPoolBuilder addEntryEmpty(String name, int weight, int quality) {
        return this.addEntryEmpty(name, weight, quality, NO_CONDITIONS);
    }

    public LootPoolBuilder addEntryEmpty(String name, int weight, int quality, LootCondition[] conditions) {
        return this.addEntry((LootEntry)new LootEntryEmpty(weight, quality, conditions, name));
    }
}

