/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.loot;

import fathertoast.deadlyworld.loot.LootPoolBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.EntityHasProperty;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraft.world.storage.loot.functions.Smelt;
import net.minecraft.world.storage.loot.properties.EntityOnFire;
import net.minecraft.world.storage.loot.properties.EntityProperty;

public class LootEntryItemBuilder {
    private final String name;
    private Item item;
    private int weight = 1;
    private int quality = 0;
    private final List<LootFunction> itemFunctions = new ArrayList<LootFunction>();
    private final List<LootCondition> entryConditions = new ArrayList<LootCondition>();

    public LootEntryItemBuilder(String id, Item baseItem) {
        this.name = id;
        this.item = baseItem;
    }

    public LootEntryItemBuilder(String id, Block block) {
        this(id, Item.func_150898_a((Block)block));
    }

    public LootEntryItemBuilder(String id, ItemStack itemStack) {
        this(id, itemStack.func_77973_b());
        if (itemStack.func_77978_p() != null) {
            this.setNBTTag(itemStack.func_77978_p().func_74737_b());
        }
        if (!itemStack.func_77984_f() && itemStack.func_77960_j() != 0) {
            this.setMetadata(itemStack.func_77960_j());
        }
    }

    public LootEntryItem toLootEntry() {
        return new LootEntryItem(this.item, this.weight, this.quality, this.itemFunctions.toArray(LootPoolBuilder.NO_FUNCTIONS), this.entryConditions.toArray(LootPoolBuilder.NO_CONDITIONS), this.name);
    }

    public LootEntryItemBuilder setWeight(int value) {
        this.weight = value;
        return this;
    }

    public LootEntryItemBuilder setQuality(int value) {
        this.quality = value;
        return this;
    }

    public LootEntryItemBuilder addCondition(LootCondition condition) {
        this.entryConditions.add(condition);
        return this;
    }

    public LootEntryItemBuilder setCount(int value) {
        return this.addFunction((LootFunction)new SetCount(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)value)));
    }

    public LootEntryItemBuilder setCount(int min, int max) {
        return this.addFunction((LootFunction)new SetCount(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)min, (float)max)));
    }

    public LootEntryItemBuilder addLootingBonus(float value) {
        return this.addFunction((LootFunction)new LootingEnchantBonus(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange(value), 0));
    }

    public LootEntryItemBuilder addLootingBonus(float min, float max) {
        return this.addLootingBonus(min, max, 0);
    }

    public LootEntryItemBuilder addLootingBonus(float min, float max, int limit) {
        return this.addFunction((LootFunction)new LootingEnchantBonus(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange(min, max), limit));
    }

    public LootEntryItemBuilder setDamage(int value) {
        return this.addFunction((LootFunction)new SetDamage(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)value)));
    }

    public LootEntryItemBuilder setMetadata(int min, int max) {
        return this.addFunction((LootFunction)new SetMetadata(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)min, (float)max)));
    }

    public LootEntryItemBuilder setMetadata(int value) {
        return this.addFunction((LootFunction)new SetMetadata(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)value)));
    }

    public LootEntryItemBuilder setDamage(int min, int max) {
        return this.addFunction((LootFunction)new SetDamage(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)min, (float)max)));
    }

    public LootEntryItemBuilder setNBTTag(NBTTagCompound tag) {
        return this.addFunction((LootFunction)new SetNBT(LootPoolBuilder.NO_CONDITIONS, tag));
    }

    public LootEntryItemBuilder smeltIfBurning() {
        return this.addFunction((LootFunction)new Smelt(new LootCondition[]{new EntityHasProperty(new EntityProperty[]{new EntityOnFire(true)}, LootContext.EntityTarget.THIS)}));
    }

    public LootEntryItemBuilder applyOneRandomApplicableEnchant() {
        return this.addFunction((LootFunction)new EnchantRandomly(LootPoolBuilder.NO_CONDITIONS, null));
    }

    public LootEntryItemBuilder applyOneRandomEnchant(Enchantment ... enchantments) {
        return this.addFunction((LootFunction)new EnchantRandomly(LootPoolBuilder.NO_CONDITIONS, Arrays.asList(enchantments)));
    }

    public LootEntryItemBuilder enchant(int level, boolean treasure) {
        return this.addFunction((LootFunction)new EnchantWithLevels(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)level), treasure));
    }

    public LootEntryItemBuilder enchant(int levelMin, int levelMax, boolean treasure) {
        return this.addFunction((LootFunction)new EnchantWithLevels(LootPoolBuilder.NO_CONDITIONS, new RandomValueRange((float)levelMin, (float)levelMax), treasure));
    }

    public LootEntryItemBuilder addFunction(LootFunction function) {
        this.itemFunctions.add(function);
        return this;
    }
}

