/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.item;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.featuregen.FeatureGenerator;
import fathertoast.deadlyworld.featuregen.WorldGenDeadlyWorldFeature;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFeatureTester
extends Item {
    public static final String ID = "feature_tester";
    private static final String TAG_FEATURE_NAME = "DWFeatureName";
    private static final String LANG_KEY = "tile.deadlyworld.feature_tester.tooltip";

    public ItemFeatureTester() {
        this.func_77625_d(1);
    }

    private String getFeatureName(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(TAG_FEATURE_NAME, TrapHelper.NBT_TYPE_STRING)) {
            return tag.func_74779_i(TAG_FEATURE_NAME);
        }
        return "";
    }

    private WorldGenDeadlyWorldFeature getFeature(ItemStack stack) {
        String featureName = this.getFeatureName(stack);
        if (!featureName.isEmpty()) {
            for (WorldGenDeadlyWorldFeature feature : FeatureGenerator.FEATURE_LIST) {
                if (!feature.NAME.equals(featureName)) continue;
                return feature;
            }
        }
        return null;
    }

    private ItemStack setFeature(ItemStack stack, WorldGenDeadlyWorldFeature feature) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74778_a(TAG_FEATURE_NAME, feature.NAME);
        return stack;
    }

    private ItemStack createFeatureTester(WorldGenDeadlyWorldFeature feature) {
        return this.setFeature(new ItemStack((Item)this), feature);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (WorldGenDeadlyWorldFeature feature : FeatureGenerator.FEATURE_LIST) {
                items.add((Object)this.createFeatureTester(feature));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_74838_a((String)LANG_KEY) + " \"" + I18n.func_74838_a((String)("tile.deadlyworld.feature_tester.tooltip." + this.getFeatureName(stack))) + "\"");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !stack.func_190926_b()) {
            WorldGenDeadlyWorldFeature feature = this.getFeature(stack);
            if (feature != null) {
                String dimension = Config.getDimensionKey(world);
                Config dimConfig = Config.get(world);
                if (dimConfig == null) {
                    dimConfig = Config.get();
                    DeadlyWorldMod.log().warn("[Player='{}',@{}] Feature tester is being used in a disabled dimension ({}); generating feature:'{}' using config for dimension '{}'", (Object)player.func_70005_c_(), (Object)pos, (Object)dimension, (Object)feature.NAME, (Object)DimensionType.OVERWORLD.func_186065_b());
                } else {
                    DeadlyWorldMod.log().info("[Player='{}',@{}] Feature tester generating feature:'{}' using config for dimension '{}'", (Object)player.func_70005_c_(), (Object)pos, (Object)feature.NAME, (Object)dimension);
                }
                feature.placeFeature(dimConfig, dimConfig.TERRAIN.REPLACEABLE_BLOCKS, world, player.func_70681_au(), pos);
            } else {
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 0;
    }
}

