/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.item;

import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.item.EnumDeadlyEventType;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDeadlyEvent
extends Item {
    public static final String ID = "event_item";
    private static final String TAG_EVENT_NAME = "DWEvent";
    private static final String LANG_KEY = "tile.deadlyworld.event_item.tooltip";

    public ItemDeadlyEvent() {
        this.func_77625_d(1);
    }

    void trigger(ItemStack stack, World world, Vec3d pos, EntityPlayer player) {
        Config dimConfig = Config.getOrDefault(world);
        this.getEvent(stack).trigger(dimConfig, world, pos, player);
    }

    private String getEventNameId(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(TAG_EVENT_NAME, TrapHelper.NBT_TYPE_STRING)) {
            return tag.func_74779_i(TAG_EVENT_NAME);
        }
        return "";
    }

    private EnumDeadlyEventType getEvent(ItemStack stack) {
        String eventName = this.getEventNameId(stack);
        if (!eventName.isEmpty()) {
            for (EnumDeadlyEventType eventType : EnumDeadlyEventType.values()) {
                if (!eventType.NAME.equals(eventName)) continue;
                return eventType;
            }
        }
        return EnumDeadlyEventType.NONE;
    }

    private ItemStack setEvent(ItemStack stack, EnumDeadlyEventType eventType) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74778_a(TAG_EVENT_NAME, eventType.NAME);
        return stack;
    }

    public ItemStack createEventItem(EnumDeadlyEventType eventType) {
        return this.setEvent(new ItemStack((Item)this), eventType);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (EnumDeadlyEventType eventType : EnumDeadlyEventType.values()) {
                if (eventType == EnumDeadlyEventType.NONE) continue;
                items.add((Object)this.createEventItem(eventType));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(TextFormatting.AQUA.toString() + I18n.func_74838_a((String)LANG_KEY) + " \"" + I18n.func_74838_a((String)("tile.deadlyworld.event_item.tooltip." + this.getEvent((ItemStack)stack).NAME)) + "\"");
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 0;
    }
}

