/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.item;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.item.EnumPotionCloudType;
import fathertoast.deadlyworld.loot.LootEntryItemBuilder;
import fathertoast.deadlyworld.loot.LootPoolBuilder;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import fathertoast.deadlyworld.tileentity.EnumChestType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootTableList;

public enum EnumDeadlyEventType {
    NONE("none"){

        @Override
        void trigger(Config dimConfig, World world, Vec3d pos, EntityPlayer player) {
        }
    }
    ,
    SILVERFISH("spawn_silverfish"){

        @Override
        void trigger(Config dimConfig, World world, Vec3d pos, EntityPlayer player) {
            for (int i = 0; i < dimConfig.CHEST_INFESTED.SILVERFISH_COUNT; ++i) {
                float angle = (float)Math.PI * 2 * world.field_73012_v.nextFloat();
                EntitySilverfish silverfish = new EntitySilverfish(world);
                silverfish.func_70012_b(pos.field_72450_a, pos.field_72448_b + 0.1, pos.field_72449_c, (float)Math.toDegrees(angle), 0.0f);
                float speed = dimConfig.CHEST_INFESTED.LAUNCH_SPEED * world.field_73012_v.nextFloat() + 0.02f;
                silverfish.func_70624_b((EntityLivingBase)player);
                silverfish.func_180482_a(world.func_175649_E(new BlockPos(pos)), null);
                silverfish.field_70159_w = MathHelper.func_76126_a((float)angle) * speed;
                silverfish.field_70181_x = 0.2f + 0.2f * world.field_73012_v.nextFloat();
                silverfish.field_70179_y = MathHelper.func_76134_b((float)angle) * speed;
                world.func_72838_d((Entity)silverfish);
            }
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187850_fa, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
    ,
    TNT("tnt"){

        @Override
        void trigger(Config dimConfig, World world, Vec3d pos, EntityPlayer player) {
            int fuseRange = dimConfig.CHEST_SURPRISE.TNT_FUSE_TIME_MAX - dimConfig.CHEST_SURPRISE.TNT_FUSE_TIME_MIN;
            if (fuseRange <= 0) {
                fuseRange = 1;
            }
            for (int i = 0; i < dimConfig.CHEST_SURPRISE.TNT_COUNT; ++i) {
                EntityTNTPrimed tntPrimed = new EntityTNTPrimed(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, null);
                float speed = dimConfig.CHEST_SURPRISE.TNT_LAUNCH_SPEED * world.field_73012_v.nextFloat() + 0.02f;
                tntPrimed.func_184534_a(dimConfig.CHEST_SURPRISE.TNT_FUSE_TIME_MIN + world.field_73012_v.nextInt(fuseRange));
                tntPrimed.field_70159_w *= (double)speed;
                tntPrimed.field_70181_x += (double)(0.1f + 0.1f * world.field_73012_v.nextFloat());
                tntPrimed.field_70179_y *= (double)speed;
                world.func_72838_d((Entity)tntPrimed);
            }
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
    ,
    LAVA("lava"){

        @Override
        void trigger(Config dimConfig, World world, Vec3d pos, EntityPlayer player) {
            BlockPos lavaPos = new BlockPos(pos);
            Block blockAtTrigger = world.func_180495_p(lavaPos).func_177230_c();
            if (blockAtTrigger instanceof BlockChest) {
                lavaPos = lavaPos.func_177982_a(0, 1, 0);
            }
            if (world.func_180495_p(lavaPos).func_185917_h()) {
                world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                world.func_180501_a(lavaPos, Blocks.field_150356_k.func_176223_P(), 11);
                world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
    ,
    POISON_GAS("poison_gas"){

        @Override
        void trigger(Config dimConfig, World world, Vec3d pos, EntityPlayer player) {
            float minRadius = 0.5f;
            EnumPotionCloudType cloudType = dimConfig.CHEST_SURPRISE.GAS_POTION_TYPE_LIST.nextItem(world.field_73012_v);
            EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            cloudType.addEffects(dimConfig, cloud);
            cloud.func_184481_a(null);
            cloud.func_184485_d(dimConfig.CHEST_SURPRISE.GAS_DURATION_DELAY);
            cloud.func_184486_b(dimConfig.CHEST_SURPRISE.GAS_DURATION);
            cloud.func_184483_a(0.5f);
            cloud.func_184487_c((dimConfig.CHEST_SURPRISE.GAS_MAX_RADIUS - 0.5f) / (float)dimConfig.CHEST_SURPRISE.GAS_DURATION);
            cloud.func_184495_b(0.0f);
            world.func_72838_d((Entity)cloud);
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187825_fO, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
    ,
    SPAWN_MIMIC("spawn_mimic"){

        @Override
        void trigger(Config dimConfig, World world, Vec3d pos, EntityPlayer player) {
            EntityZombie entity;
            BlockPos chestPos = new BlockPos(pos);
            Block chestBlock = world.func_180495_p(chestPos).func_177230_c();
            if (chestBlock instanceof BlockChest) {
                world.func_175698_g(chestPos);
            } else {
                chestBlock = Blocks.field_150486_ae;
            }
            ItemStack chestItem = new ItemStack(chestBlock);
            NBTTagCompound tileEntityTag = chestItem.func_190925_c("BlockEntityTag");
            tileEntityTag.func_74778_a("LootTable", EnumChestType.MIMIC.LOOT_TABLE_CHEST.toString());
            tileEntityTag.func_74772_a("LootTableSeed", world.field_73012_v.nextLong());
            String space = TextFormatting.YELLOW.toString() + " " + TextFormatting.OBFUSCATED.toString();
            String line = "Not" + space + "A" + space + "Mimic";
            if (world.field_73012_v.nextInt(3) == 0) {
                line = "Maybe" + space + line;
            }
            if (world.field_73012_v.nextInt(6) == 0) {
                line = "Really" + space + line;
            }
            if (world.field_73012_v.nextInt(9) == 0) {
                line = "Definitely" + space + line;
            }
            NBTTagList tooltip = new NBTTagList();
            tooltip.func_74742_a((NBTBase)new NBTTagString(TextFormatting.YELLOW.toString() + TextFormatting.OBFUSCATED.toString() + line));
            chestItem.func_190925_c("display").func_74782_a("Lore", (NBTBase)tooltip);
            ResourceLocation registryName = dimConfig.CHEST_MIMIC.SPAWN_LIST.nextItem(world.field_73012_v);
            Class<EntityZombie> entityToSpawn = EntityList.getClass((ResourceLocation)registryName);
            if (entityToSpawn == null) {
                DeadlyWorldMod.log().warn("Spawn mimic event received non-registered entity name '{}' - This is probably caused by an error or change in the config for DIM_{} (defaulting to zombie)", (Object)registryName, (Object)world.field_73011_w.getDimension());
                entityToSpawn = EntityZombie.class;
            }
            try {
                entity = (Entity)entityToSpawn.getConstructor(World.class).newInstance(world);
            }
            catch (Exception ex) {
                DeadlyWorldMod.log().error("Encountered exception while constructing entity '{}'", (Object)entityToSpawn, (Object)ex);
                entity = new EntityZombie(world);
            }
            entity.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, world.field_73012_v.nextFloat() * 2.0f * (float)Math.PI, 0.0f);
            entity.field_70181_x = 0.3f;
            if (entity instanceof EntityLiving) {
                IAttributeInstance attrib;
                EntityLiving livingEntity = (EntityLiving)entity;
                if (world.field_73012_v.nextFloat() < dimConfig.CHEST_MIMIC.BABY_CHANCE) {
                    if (entity instanceof EntityZombie) {
                        entity.func_82227_f(true);
                    } else if (entity instanceof EntityAgeable) {
                        ((EntityAgeable)entity).func_70873_a(Integer.MIN_VALUE);
                    }
                }
                livingEntity.func_180482_a(world.func_175649_E(chestPos), null);
                livingEntity.func_184201_a(EntityEquipmentSlot.HEAD, chestItem);
                livingEntity.func_184642_a(EntityEquipmentSlot.HEAD, 2.0f);
                livingEntity.func_110163_bv();
                if (dimConfig.CHEST_MIMIC.MULTIPLIER_DAMAGE != 1.0f) {
                    try {
                        attrib = livingEntity.func_110148_a(SharedMonsterAttributes.field_111264_e);
                        attrib.func_111128_a(attrib.func_111125_b() * (double)dimConfig.CHEST_MIMIC.MULTIPLIER_DAMAGE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dimConfig.CHEST_MIMIC.MULTIPLIER_HEALTH != 1.0f) {
                    try {
                        attrib = livingEntity.func_110148_a(SharedMonsterAttributes.field_111267_a);
                        attrib.func_111128_a(attrib.func_111125_b() * (double)dimConfig.CHEST_MIMIC.MULTIPLIER_HEALTH);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dimConfig.CHEST_MIMIC.MULTIPLIER_SPEED != 1.0f) {
                    try {
                        attrib = livingEntity.func_110148_a(SharedMonsterAttributes.field_111263_d);
                        attrib.func_111128_a(attrib.func_111125_b() * (double)dimConfig.CHEST_MIMIC.MULTIPLIER_SPEED);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                livingEntity.func_70606_j(livingEntity.func_110138_aP());
                livingEntity.func_70624_b((EntityLivingBase)player);
            }
            world.func_72838_d((Entity)entity);
            world.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187789_eW, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    };

    public static final int UPDATE_FLAGS = 11;
    public static final String PATH = "events/";
    public final String NAME;
    public final String DISPLAY_NAME;
    public final ResourceLocation LOOT_TABLE;

    private EnumDeadlyEventType(String name) {
        this(name, name.replace("_", " "));
    }

    private EnumDeadlyEventType(String name, String prettyName) {
        this.NAME = name;
        this.DISPLAY_NAME = prettyName;
        this.LOOT_TABLE = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("deadlyworld", PATH + name));
    }

    abstract void trigger(Config var1, World var2, Vec3d var3, EntityPlayer var4);

    public void buildLootTable(LootTableBuilder loot) {
        loot.addPool(new LootPoolBuilder("Event: " + this.DISPLAY_NAME).addEntry((LootEntry)new LootEntryItemBuilder("events." + this.NAME, ModObjects.EVENT_ITEM.createEventItem(this)).toLootEntry()).toLootPool());
    }
}

