/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.item;

import fathertoast.deadlyworld.item.ItemDeadlyEvent;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DeadlyEventHandler {
    private final Map<EntityPlayer, TileEntity> TILE_ENTITY_INTERACTIONS = new ConcurrentHashMap<EntityPlayer, TileEntity>();
    private final Map<EntityPlayer, Entity> ENTITY_INTERACTIONS = new ConcurrentHashMap<EntityPlayer, Entity>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        ItemStack stack;
        Item item;
        if (event.getEntity() instanceof EntityItem && (item = (stack = ((EntityItem)event.getEntity()).func_92059_d()).func_77973_b()) instanceof ItemDeadlyEvent) {
            ((ItemDeadlyEvent)stack.func_77973_b()).trigger(stack, event.getWorld(), event.getEntity().func_174791_d(), null);
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onContainerOpen(PlayerContainerEvent.Open event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            Vec3d position = this.TILE_ENTITY_INTERACTIONS.containsKey(event.getEntityPlayer()) ? new Vec3d((Vec3i)this.TILE_ENTITY_INTERACTIONS.get(event.getEntityPlayer()).func_174877_v()).func_72441_c(0.5, 0.0, 0.5) : (this.ENTITY_INTERACTIONS.containsKey(event.getEntityPlayer()) ? this.ENTITY_INTERACTIONS.get(event.getEntityPlayer()).func_174791_d() : event.getEntityPlayer().func_174791_d());
            ArrayList<ItemStack> eventsToTrigger = new ArrayList<ItemStack>();
            for (int i = 0; i < event.getContainer().field_75153_a.size(); ++i) {
                ItemStack stack = (ItemStack)event.getContainer().field_75153_a.get(i);
                if (!(stack.func_77973_b() instanceof ItemDeadlyEvent)) continue;
                eventsToTrigger.add(stack);
                event.getContainer().func_75141_a(i, ItemStack.field_190927_a);
            }
            if (!eventsToTrigger.isEmpty()) {
                event.getContainer().func_75142_b();
            }
            for (ItemStack stack : eventsToTrigger) {
                ((ItemDeadlyEvent)stack.func_77973_b()).trigger(stack, event.getEntityPlayer().field_70170_p, position, event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void recordRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile;
        if (!event.getWorld().field_72995_K && (tile = event.getWorld().func_175625_s(event.getPos())) != null) {
            this.TILE_ENTITY_INTERACTIONS.put(event.getEntityPlayer(), tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void recordRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        if (!event.getWorld().field_72995_K) {
            this.ENTITY_INTERACTIONS.put(event.getEntityPlayer(), event.getTarget());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (!this.TILE_ENTITY_INTERACTIONS.isEmpty()) {
            this.TILE_ENTITY_INTERACTIONS.clear();
        }
        if (!this.ENTITY_INTERACTIONS.isEmpty()) {
            this.ENTITY_INTERACTIONS.clear();
        }
    }
}

