/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.featuregen;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.TargetBlock;
import fathertoast.deadlyworld.featuregen.WorldGenFloorFeature;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenTowerTrap
extends WorldGenFloorFeature {
    private final EnumTowerType TYPE;
    private final IBlockState BLOCK_STATE;

    public WorldGenTowerTrap(EnumTowerType towerType) {
        super("tower." + towerType.NAME);
        this.TYPE = towerType;
        this.BLOCK_STATE = ModObjects.TOWER_DISPENSER.func_176223_P().func_177226_a(EnumTowerType.PROPERTY, (Comparable)((Object)towerType));
    }

    @Override
    public Config.FeatureTower getFeatureConfig(Config dimConfig) {
        return dimConfig.TOWER_DEFAULT;
    }

    @Override
    public BlockPos placeFeature(Config dimConfig, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position) {
        BlockPos basePos = this.getBasePos(dimConfig, world, position);
        if (basePos == null) {
            basePos = position.func_177982_a(0, 1, 0);
        }
        for (int y = basePos.func_177956_o() - position.func_177956_o(); y > 0; --y) {
            this.setBlock(dimConfig, world, random, position.func_177982_a(0, y, 0), this.TYPE.getFeatureConfig((Config)dimConfig).PILLAR_BLOCKS, Blocks.field_150364_r);
        }
        BlockPos dispenserPos = basePos.func_177982_a(0, 1, 0);
        this.setBlock(dimConfig, world, random, dispenserPos, this.BLOCK_STATE);
        ModObjects.TOWER_DISPENSER.initTileEntity(world, dispenserPos, this.BLOCK_STATE, dimConfig, random);
        return dispenserPos;
    }

    @Override
    public boolean canBePlaced(Config dimConfig, World world, BlockPos position) {
        BlockPos basePos = this.getBasePos(dimConfig, world, position);
        if (basePos == null) {
            return false;
        }
        BlockPos dispenserPos = basePos.func_177982_a(0, 1, 0);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (world.func_175623_d(dispenserPos.func_177982_a(x, 0, z))) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private BlockPos getBasePos(Config dimConfig, World world, BlockPos position) {
        for (int y = 1; y <= dimConfig.TOWER_DEFAULT.MAX_TOWER_HEIGHT; ++y) {
            BlockPos currentPos = position.func_177982_a(0, y, 0);
            if (!world.func_175623_d(currentPos)) continue;
            return currentPos;
        }
        return null;
    }
}

