/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.featuregen;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.TargetBlock;
import fathertoast.deadlyworld.featuregen.FeatureGenerator;
import fathertoast.deadlyworld.featuregen.WorldGenFloorFeature;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenSpawner
extends WorldGenFloorFeature {
    private final EnumSpawnerType TYPE;
    private final IBlockState BLOCK_STATE;

    public WorldGenSpawner(EnumSpawnerType spawnerType) {
        super("spawner." + spawnerType.NAME);
        this.TYPE = spawnerType;
        this.BLOCK_STATE = ModObjects.DEADLY_SPAWNER.func_176223_P().func_177226_a(EnumSpawnerType.PROPERTY, (Comparable)((Object)spawnerType));
    }

    @Override
    public Config.FeatureSpawner getFeatureConfig(Config dimConfig) {
        return this.TYPE.getFeatureConfig(dimConfig);
    }

    @Override
    public BlockPos placeFeature(Config dimConfig, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position) {
        if (random.nextFloat() < this.getFeatureConfig((Config)dimConfig).CHEST_CHANCE) {
            FeatureGenerator.placeChest(position, world, random, this.TYPE.LOOT_TABLE_CHEST, false);
        }
        BlockPos spawnerPos = position.func_177982_a(0, 1, 0);
        this.placeSpawner(spawnerPos, dimConfig, world, random);
        this.TYPE.decorateSpawner(this, spawnerPos, dimConfig, world, random);
        return spawnerPos;
    }

    @Override
    public boolean canBePlaced(Config dimConfig, World world, BlockPos position) {
        return this.TYPE.canTypeBePlaced(world, position);
    }

    private void placeSpawner(BlockPos pos, Config dimConfig, World world, Random random) {
        this.setBlock(dimConfig, world, random, pos, this.BLOCK_STATE);
        ModObjects.DEADLY_SPAWNER.initTileEntity(world, pos, this.BLOCK_STATE, dimConfig, random);
    }
}

