/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.featuregen;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.TargetBlock;
import fathertoast.deadlyworld.featuregen.WorldGenFloorFeature;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenFloorTrap
extends WorldGenFloorFeature {
    private final EnumFloorTrapType TYPE;
    private final IBlockState BLOCK_STATE;

    public WorldGenFloorTrap(EnumFloorTrapType trapType) {
        super("floor_trap." + trapType.NAME);
        this.TYPE = trapType;
        this.BLOCK_STATE = ModObjects.FLOOR_TRAP.func_176223_P().func_177226_a(EnumFloorTrapType.PROPERTY, (Comparable)((Object)trapType));
    }

    @Override
    public Config.FeatureFloorTrap getFeatureConfig(Config dimConfig) {
        return this.TYPE.getFeatureConfig(dimConfig);
    }

    @Override
    public BlockPos placeFeature(Config dimConfig, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position) {
        BlockPos trapPos = TrapHelper.isAnySideOpen(world, position) ? position.func_177982_a(0, -1, 0) : position;
        this.placeTrap(trapPos, dimConfig, world, random);
        return trapPos;
    }

    @Override
    public boolean canBePlaced(Config dimConfig, World world, BlockPos position) {
        BlockPos trapPos;
        if (TrapHelper.isAnySideOpen(world, position)) {
            trapPos = position.func_177982_a(0, -1, 0);
            if (TrapHelper.isAnySideOpen(world, trapPos)) {
                return false;
            }
        } else {
            trapPos = position;
        }
        return this.TYPE.canTypeBePlaced(world, trapPos);
    }

    private void placeTrap(BlockPos pos, Config dimConfig, World world, Random random) {
        BlockPos coverPos = pos.func_177982_a(0, 1, 0);
        if (dimConfig.TERRAIN.FLOOR_TRAP_COVERS.TOTAL_WEIGHT > 0 && random.nextFloat() < this.TYPE.getFeatureConfig((Config)dimConfig).COVER_CHANCE) {
            this.setBlock(dimConfig, world, random, coverPos, dimConfig.TERRAIN.FLOOR_TRAP_COVERS.nextBlock(random));
        } else if (!world.func_175623_d(coverPos)) {
            this.setBlock(dimConfig, world, random, coverPos, Blocks.field_150350_a.func_176223_P());
        }
        this.setBlock(dimConfig, world, random, pos, this.BLOCK_STATE);
        ModObjects.FLOOR_TRAP.initTileEntity(world, pos, this.BLOCK_STATE, dimConfig, random);
    }
}

