/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.featuregen;

import fathertoast.deadlyworld.ModObjects;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.TargetBlock;
import fathertoast.deadlyworld.config.WeightedBlockConfig;
import fathertoast.deadlyworld.featuregen.FeatureGenerator;
import fathertoast.deadlyworld.featuregen.WorldGenDeadlyWorldFeature;
import fathertoast.deadlyworld.loot.LootTableBuilder;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenDeadlyDungeon
extends WorldGenDeadlyWorldFeature {
    private final ResourceLocation LOOT_TABLE_CHEST;

    WorldGenDeadlyDungeon() {
        super("dungeon");
        this.LOOT_TABLE_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("deadlyworld", "feature_chests/" + this.NAME));
    }

    @Override
    public Config.FeatureConfig getFeatureConfig(Config dimensionConfig) {
        return dimensionConfig.DUNGEONS;
    }

    public void buildChestLootTable(LootTableBuilder loot) {
        loot.addThemePoolExploration();
        loot.addLootTable("base", "Vanilla Chest", LootTableList.field_186422_d);
    }

    @Override
    public BlockPos placeFeature(Config dimConfig, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position) {
        return this.placeFeature(dimConfig, replaceableBlocks, world, random, position, new BoundingBox(dimConfig, random));
    }

    private BlockPos placeFeature(Config dimConfig, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position, BoundingBox dungeonBB) {
        boolean silverfishEnabled = Config.get().GENERAL.SILVERFISH_AUTOGEN && dimConfig.DUNGEONS.SILVERFISH_CHANCE > 0.0f;
        for (int y = 4; y >= 0; --y) {
            WeightedBlockConfig.BlockList blocks = y > 0 ? dimConfig.DUNGEONS.WALL_BLOCKS : dimConfig.DUNGEONS.FLOOR_BLOCKS;
            for (int x = dungeonBB.MIN_X; x <= dungeonBB.MAX_X; ++x) {
                for (int z = dungeonBB.MIN_Z; z <= dungeonBB.MAX_Z; ++z) {
                    BlockPos blockPos = position.func_177982_a(x, y, z);
                    IBlockState block = world.func_180495_p(blockPos);
                    if (block.func_177230_c() instanceof BlockChest) continue;
                    if (y != 0 && x != dungeonBB.MIN_X && x != dungeonBB.MAX_X && z != dungeonBB.MIN_Z && z != dungeonBB.MAX_Z) {
                        world.func_175698_g(blockPos);
                        continue;
                    }
                    if (!world.func_180495_p(blockPos.func_177977_b()).func_185904_a().func_76220_a()) {
                        world.func_175698_g(blockPos);
                        continue;
                    }
                    if (!block.func_185904_a().func_76220_a()) continue;
                    if (silverfishEnabled && random.nextFloat() < dimConfig.DUNGEONS.SILVERFISH_CHANCE) {
                        this.setBlock(dimConfig, world, random, blockPos, ModObjects.infest(blocks.nextBlock(random, Blocks.field_150347_e)));
                        continue;
                    }
                    this.setBlock(dimConfig, world, random, blockPos, blocks, Blocks.field_150347_e);
                }
            }
        }
        int varX = dungeonBB.RADIUS_X * 2 + 1;
        int varZ = dungeonBB.RADIUS_Z * 2 + 1;
        block3: for (int chests = random.nextInt(dimConfig.DUNGEONS.CHESTS_VARIANCE) + dimConfig.DUNGEONS.CHESTS_MIN; chests > 0; --chests) {
            for (int attempts = 0; attempts < 3; ++attempts) {
                BlockPos chestPos = random.nextBoolean() ? position.func_177982_a(random.nextInt(varX) - dungeonBB.RADIUS_X, 1, random.nextBoolean() ? dungeonBB.RADIUS_Z : -dungeonBB.RADIUS_Z) : position.func_177982_a(random.nextBoolean() ? dungeonBB.RADIUS_X : -dungeonBB.RADIUS_X, 1, random.nextInt(varZ) - dungeonBB.RADIUS_Z);
                if (!world.func_175623_d(chestPos)) continue;
                int adjSolidBlocks = 0;
                for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                    if (!world.func_180495_p(chestPos.func_177972_a(enumfacing)).func_185904_a().func_76220_a()) continue;
                    ++adjSolidBlocks;
                }
                if (adjSolidBlocks != true) continue;
                FeatureGenerator.placeChest(chestPos, world, random, this.LOOT_TABLE_CHEST, false);
                continue block3;
            }
        }
        dimConfig.DUNGEONS.SUBFEATURE_LIST.nextItem(random).getWorldGen().placeFeature(dimConfig, replaceableBlocks, world, random, position);
        return position;
    }

    @Override
    public BlockPos generate(Config dimConfig, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position) {
        BoundingBox dungeonBB = new BoundingBox(dimConfig, random);
        if (this.canBePlaced(dimConfig, world, position, dungeonBB)) {
            return this.placeFeature(dimConfig, replaceableBlocks, world, random, position, dungeonBB);
        }
        return null;
    }

    @Override
    public boolean canBePlaced(Config dimConfig, World world, BlockPos position) {
        return false;
    }

    private boolean canBePlaced(Config dimConfig, World world, BlockPos position, BoundingBox dungeonPos) {
        int openWallBlocks = 0;
        for (DungeonLevel level : DungeonLevel.values()) {
            for (int x = dungeonPos.MIN_X; x <= dungeonPos.MAX_X; ++x) {
                block6: for (int z = dungeonPos.MIN_Z; z <= dungeonPos.MAX_Z; ++z) {
                    BlockPos blockPos = position.func_177982_a(x, level.Y, z);
                    switch (level) {
                        case FLOOR: 
                        case CEILING: {
                            if (world.func_180495_p(blockPos).func_185904_a().func_76220_a()) continue block6;
                            return false;
                        }
                        case FOOT: {
                            if (x != dungeonPos.MIN_X && x != dungeonPos.MAX_X && z != dungeonPos.MIN_Z && z != dungeonPos.MAX_Z || !world.func_175623_d(blockPos) || !world.func_175623_d(blockPos.func_177984_a()) || ++openWallBlocks <= dimConfig.DUNGEONS.OPEN_WALLS_MAX) continue block6;
                            return false;
                        }
                    }
                }
            }
        }
        return openWallBlocks >= dimConfig.DUNGEONS.OPEN_WALLS_MIN;
    }

    private class BoundingBox {
        final int RADIUS_X;
        final int RADIUS_Z;
        final int MIN_X;
        final int MAX_X;
        final int MIN_Z;
        final int MAX_Z;

        BoundingBox(Config dimConfig, Random random) {
            this(random.nextInt(dimConfig.DUNGEONS.WIDTH_VARIANCE) + dimConfig.DUNGEONS.WIDTH_MIN, random.nextInt(dimConfig.DUNGEONS.WIDTH_VARIANCE) + dimConfig.DUNGEONS.WIDTH_MIN);
        }

        BoundingBox(int radiusX, int radiusZ) {
            this.RADIUS_X = radiusX;
            this.RADIUS_Z = radiusZ;
            this.MIN_X = -radiusX - 1;
            this.MAX_X = radiusX + 1;
            this.MIN_Z = -radiusZ - 1;
            this.MAX_Z = radiusZ + 1;
        }
    }

    private static enum DungeonLevel {
        FLOOR(0),
        CEILING(5),
        FOOT(1);

        public final int Y;

        private DungeonLevel(int y) {
            this.Y = y;
        }
    }
}

