/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.featuregen;

import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.config.TargetBlock;
import fathertoast.deadlyworld.featuregen.FeatureGenerator;
import fathertoast.deadlyworld.featuregen.WorldGenFloorFeature;
import fathertoast.deadlyworld.tileentity.EnumChestType;
import fathertoast.deadlyworld.tileentity.TrapHelper;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenChest
extends WorldGenFloorFeature {
    private final EnumChestType TYPE;

    public WorldGenChest(EnumChestType chestType) {
        super("chest." + chestType.NAME);
        this.TYPE = chestType;
    }

    @Override
    public Config.FeatureConfig getFeatureConfig(Config dimConfig) {
        return this.TYPE.getFeatureConfig(dimConfig);
    }

    @Override
    public BlockPos placeFeature(Config dimConfig, TargetBlock.TargetMap replaceableBlocks, World world, Random random, BlockPos position) {
        BlockPos chestPos = position.func_177982_a(0, 1, 0);
        ResourceLocation lootTable = this.TYPE.getLootTable(dimConfig, world, random, position);
        FeatureGenerator.placeChest(chestPos, world, random, lootTable, random.nextFloat() < this.TYPE.getFeatureConfig((Config)dimConfig).TRAPPED_CHANCE);
        this.TYPE.decorateChest(this, chestPos, dimConfig, world, random);
        return chestPos;
    }

    @Override
    public boolean canBePlaced(Config dimConfig, World world, BlockPos position) {
        BlockPos trapPos;
        if (TrapHelper.isAnySideOpen(world, position)) {
            trapPos = position.func_177982_a(0, -1, 0);
            if (TrapHelper.isAnySideOpen(world, trapPos)) {
                return false;
            }
        } else {
            trapPos = position;
        }
        return this.TYPE.canTypeBePlaced(world, trapPos);
    }
}

