/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.featuregen;

import fathertoast.deadlyworld.DeadlyWorldMod;
import fathertoast.deadlyworld.block.state.EnumFloorTrapType;
import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.config.Config;
import fathertoast.deadlyworld.featuregen.WorldGenDeadlyDungeon;
import fathertoast.deadlyworld.featuregen.WorldGenDeadlyWorldFeature;
import fathertoast.deadlyworld.tileentity.EnumChestType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FeatureGenerator {
    public static final int FLAG_BLOCK_UPDATE = 1;
    public static final int FLAG_NOTIFY_CLIENTS = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FLAG_PRIORITY_RERENDER = 8;
    public static final int FLAG_NO_OBSERVER = 16;
    public static final int UPDATE_FLAGS = 18;
    public static final String CHEST_LOOT_TABLE_PATH = "feature_chests/";
    public static final List<WorldGenDeadlyWorldFeature> FEATURE_LIST = Arrays.asList(EnumTowerType.FIREBALL.makeWorldGen(), EnumTowerType.GATLING.makeWorldGen(), EnumTowerType.POTION.makeWorldGen(), EnumTowerType.FIRE.makeWorldGen(), EnumTowerType.DEFAULT.makeWorldGen(), EnumFloorTrapType.TNT.makeWorldGen(), EnumFloorTrapType.TNT_MOB.makeWorldGen(), EnumFloorTrapType.POTION.makeWorldGen(), EnumSpawnerType.SILVERFISH_NEST.makeWorldGen(), EnumSpawnerType.BRUTAL.makeWorldGen(), EnumSpawnerType.SWARM.makeWorldGen(), EnumSpawnerType.STREAM.makeWorldGen(), EnumSpawnerType.DEFAULT.makeWorldGen(), EnumChestType.VALUABLE.makeWorldGen(), EnumChestType.MIMIC.makeWorldGen(), EnumChestType.SURPRISE.makeWorldGen(), EnumChestType.TNT_FLOOR_TRAP.makeWorldGen(), EnumChestType.INFESTED.makeWorldGen(), EnumChestType.DEFAULT.makeWorldGen(), EnumChestType.TRAPPED.makeWorldGen());
    public static final WorldGenDeadlyDungeon DUNGEON_FEATURE = new WorldGenDeadlyDungeon();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void prePopulateChunk(PopulateChunkEvent.Pre event) {
        World world = event.getWorld();
        Config config = Config.get(world);
        if (config != null) {
            Random random = event.getRand();
            BlockPos chunkCenterPos = new BlockPos((event.getChunkX() << 4) + 8, 0, (event.getChunkZ() << 4) + 8);
            for (WorldGenDeadlyWorldFeature feature : FEATURE_LIST) {
                this.generateFeature(config, feature, world, random, chunkCenterPos);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void populateChunkTerrain(PopulateChunkEvent.Populate event) {
        World world = event.getWorld();
        Config config = Config.get(world);
        if (config != null) {
            switch (event.getType()) {
                case DUNGEON: {
                    if (!config.DUNGEONS.DISABLE_VANILLA_DUNGEONS) break;
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case NETHER_LAVA2: {
                    if (!config.VEINS.DISABLE_LAVA_VEINS) break;
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postPopulateChunk(PopulateChunkEvent.Post event) {
        World world = event.getWorld();
        Config config = Config.get(world);
        if (config != null) {
            Random random = event.getRand();
            BlockPos chunkCenterPos = new BlockPos((event.getChunkX() << 4) + 8, 0, (event.getChunkZ() << 4) + 8);
            this.generateMultiFeature(config, DUNGEON_FEATURE, world, random, chunkCenterPos);
        }
    }

    private void generateFeature(Config dimConfig, WorldGenDeadlyWorldFeature generator, World world, Random random, BlockPos chunkCenterPos) {
        Config.FeatureConfig featureConfig = generator.getFeatureConfig(dimConfig);
        float placementChance = featureConfig.getPlacementChance(world, chunkCenterPos);
        if (placementChance > 0.0f && random.nextFloat() < placementChance) {
            BlockPos featurePos = chunkCenterPos.func_177982_a(random.nextInt(16), FeatureGenerator.nextHeight(featureConfig, random), random.nextInt(16));
            if ((featurePos = generator.generate(dimConfig, dimConfig.TERRAIN.REPLACEABLE_BLOCKS, world, random, featurePos)) != null && featureConfig.DEBUG_MARKER) {
                DeadlyWorldMod.mark(world, featurePos.func_177981_b(5));
            }
        }
    }

    private void generateMultiFeature(Config dimConfig, WorldGenDeadlyWorldFeature generator, World world, Random random, BlockPos chunkCenterPos) {
        Config.FeatureMulti featureConfig = (Config.FeatureMulti)generator.getFeatureConfig(dimConfig);
        for (float count = featureConfig.getPlacementChance(world, chunkCenterPos); count >= 1.0f || count > 0.0f && count > random.nextFloat(); count -= 1.0f) {
            BlockPos featurePos = chunkCenterPos.func_177982_a(random.nextInt(16), FeatureGenerator.nextHeight(featureConfig, random), random.nextInt(16));
            if ((featurePos = generator.generate(dimConfig, dimConfig.TERRAIN.REPLACEABLE_BLOCKS, world, random, featurePos)) == null || !featureConfig.DEBUG_MARKER) continue;
            DeadlyWorldMod.mark(world, featurePos.func_177981_b(5));
        }
    }

    private static int nextHeight(Config.FeatureConfig featureConfig, Random random) {
        if (featureConfig.HEIGHTS[0] >= featureConfig.HEIGHTS[1]) {
            return featureConfig.HEIGHTS[0];
        }
        return random.nextInt(featureConfig.HEIGHTS[1] - featureConfig.HEIGHTS[0]) + featureConfig.HEIGHTS[0];
    }

    static void placeChest(BlockPos chestPos, World world, Random random, ResourceLocation lootTable, boolean trapped) {
        IBlockState chestState = trapped ? Blocks.field_150447_bR.func_176223_P() : Blocks.field_150486_ae.func_176223_P();
        chestState = chestState.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
        world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176458_f(world, chestPos, chestState), 18);
        TileEntity chestInventory = world.func_175625_s(chestPos);
        if (chestInventory instanceof TileEntityChest) {
            ((TileEntityChest)chestInventory).func_189404_a(lootTable, random.nextLong());
        } else {
            DeadlyWorldMod.log().error("Failed to fetch chest tile entity at [{}]! Expect an empty chest. :(", (Object)chestPos);
        }
    }
}

