/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.deadlyworld.featuregen;

import fathertoast.deadlyworld.block.state.EnumSpawnerType;
import fathertoast.deadlyworld.block.state.EnumTowerType;
import fathertoast.deadlyworld.config.WeightedEnumConfig;
import fathertoast.deadlyworld.featuregen.WorldGenDeadlyWorldFeature;

public enum EnumDungeonSubfeature implements WeightedEnumConfig.Meta
{
    SPAWNER(EnumSpawnerType.DUNGEON, 100),
    TOWER_SIMPLE(EnumTowerType.DEFAULT, 10),
    TOWER_FIRE(EnumTowerType.FIRE, 10),
    TOWER_POTION(EnumTowerType.POTION, 10),
    TOWER_GATLING(EnumTowerType.GATLING, 5),
    TOWER_FIREBALL(EnumTowerType.FIREBALL, EnumTowerType.FIREBALL.NAME, 5);

    private final String NAME;
    public final int DEFAULT_WEIGHT;
    private final Object TYPE;
    private WorldGenDeadlyWorldFeature FEATURE;

    private EnumDungeonSubfeature(EnumSpawnerType type, int defaultWeight) {
        this.NAME = "spawner_" + type.NAME;
        this.DEFAULT_WEIGHT = defaultWeight;
        this.TYPE = type;
    }

    private EnumDungeonSubfeature(EnumTowerType type, int defaultWeight) {
        this(type, type.NAME + "_arrow", defaultWeight);
    }

    private EnumDungeonSubfeature(EnumTowerType type, String name, int defaultWeight) {
        this.NAME = "tower_" + name;
        this.DEFAULT_WEIGHT = defaultWeight;
        this.TYPE = type;
    }

    public WorldGenDeadlyWorldFeature getWorldGen() {
        if (this.FEATURE == null) {
            if (this.TYPE instanceof EnumTowerType) {
                this.FEATURE = ((EnumTowerType)this.TYPE).makeWorldGen();
            } else if (this.TYPE instanceof EnumSpawnerType) {
                this.FEATURE = ((EnumSpawnerType)this.TYPE).makeWorldGen();
            }
        }
        return this.FEATURE;
    }

    @Override
    public int defaultWeight() {
        return this.DEFAULT_WEIGHT;
    }

    public String toString() {
        return this.NAME;
    }
}

